/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.better_respawn.capabilities;

import de.maxhenkel.better_respawn.Main;
import de.maxhenkel.better_respawn.capabilities.RespawnPosition;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class SpawnPointCapabilityProvider
implements ICapabilitySerializable<CompoundNBT> {
    private RespawnPosition respawnPosition;

    public SpawnPointCapabilityProvider(RespawnPosition respawnPosition) {
        this.respawnPosition = respawnPosition;
    }

    public SpawnPointCapabilityProvider() {
        this(new RespawnPosition());
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap.equals(Main.RESPAWN_CAPABILITY)) {
            return LazyOptional.of(() -> this.respawnPosition);
        }
        return LazyOptional.empty();
    }

    public CompoundNBT serializeNBT() {
        return this.respawnPosition.toNBT();
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.respawnPosition.fromNBT(nbt);
    }
}

