/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.better_respawn;

import de.maxhenkel.better_respawn.Main;
import de.maxhenkel.better_respawn.capabilities.RespawnPosition;
import de.maxhenkel.better_respawn.capabilities.SpawnPointCapabilityProvider;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.player.SpawnLocationHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerSetSpawnEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class RespawnEvents {
    private static final int FIND_SPAWN_ATTEMPTS = 16;
    private static final ResourceLocation RESPAWN_CAPABILITY_ID = new ResourceLocation("better_respawn", "respawn_location");
    private Random random = new Random();

    @SubscribeEvent
    public void onDeath(LivingDeathEvent event) {
        BlockPos respawnPos;
        Optional vec3d;
        if (!(event.getEntity() instanceof ServerPlayerEntity)) {
            return;
        }
        ServerPlayerEntity player = (ServerPlayerEntity)event.getEntity();
        if (!player.func_71121_q().func_230315_m_().func_241510_j_()) {
            return;
        }
        BlockPos bedLocation = player.func_241140_K_();
        if (bedLocation != null && (vec3d = PlayerEntity.func_242374_a((ServerWorld)player.func_71121_q(), (BlockPos)bedLocation, (float)0.0f, (boolean)false, (boolean)false)).isPresent()) {
            Vector3d spawn = (Vector3d)vec3d.get();
            if (player.func_233580_cy_().func_218139_n(new Vector3i(spawn.field_72450_a, spawn.field_72448_b, spawn.field_72449_c)) <= (Integer)Main.SERVER_CONFIG.bedRange.get()) {
                Main.LOGGER.debug("Player {} is within the range of its bed", (Object)player.func_200200_C_().func_150261_e());
                return;
            }
        }
        if ((respawnPos = this.findValidRespawnLocation(player.func_71121_q(), player.func_233580_cy_())) == null) {
            return;
        }
        player.func_242111_a(player.field_70170_p.func_234923_W_(), respawnPos, 0.0f, true, false);
        Main.LOGGER.debug("Set temporary respawn location to [{}, {}, {}]", (Object)respawnPos.func_177958_n(), (Object)respawnPos.func_177956_o(), (Object)respawnPos.func_177952_p());
    }

    @SubscribeEvent
    public void onJoinWorld(EntityJoinWorldEvent event) {
        if (!(event.getEntity() instanceof ServerPlayerEntity) || !event.getEntity().func_70089_S()) {
            return;
        }
        ServerPlayerEntity player = (ServerPlayerEntity)event.getEntity();
        RespawnPosition respawnPosition = (RespawnPosition)player.getCapability(Main.RESPAWN_CAPABILITY).orElse(null);
        if (respawnPosition == null) {
            player.func_242111_a(event.getWorld().func_234923_W_(), null, 0.0f, false, false);
            Main.LOGGER.error("Player {} has no respawn location capability", (Object)player.func_200200_C_().func_150261_e());
            return;
        }
        BlockPos respawn = respawnPosition.getPos(event.getWorld());
        player.func_242111_a(event.getWorld().func_234923_W_(), respawn, 0.0f, false, false);
        if (respawn == null) {
            Main.LOGGER.debug("Setting the players respawn position back to world spawn");
        } else {
            Main.LOGGER.debug("Setting the players respawn position back to [{}, {}, {}]", (Object)respawn.func_177958_n(), (Object)respawn.func_177956_o(), (Object)respawn.func_177952_p());
        }
    }

    @SubscribeEvent
    public void onSetSpawn(PlayerSetSpawnEvent event) {
        if (event.isForced()) {
            return;
        }
        BlockPos newSpawn = event.getNewSpawn();
        if (newSpawn != null) {
            event.getPlayer().getCapability(Main.RESPAWN_CAPABILITY).ifPresent(respawnPosition -> respawnPosition.setPos(event.getPlayer().field_70170_p, newSpawn));
            Main.LOGGER.debug("Updating the respawn location of player {} to [{}, {}, {}]", (Object)event.getPlayer().func_200200_C_().func_150261_e(), (Object)newSpawn.func_177958_n(), (Object)newSpawn.func_177956_o(), (Object)newSpawn.func_177952_p());
        }
    }

    @SubscribeEvent
    public void onClone(PlayerEvent.Clone event) {
        if (!event.isWasDeath()) {
            return;
        }
        event.getOriginal().getCapability(Main.RESPAWN_CAPABILITY).ifPresent(respawnPosition -> event.getPlayer().getCapability(Main.RESPAWN_CAPABILITY).ifPresent(respawnPosition1 -> {
            respawnPosition1.copyFrom((RespawnPosition)respawnPosition);
            Main.LOGGER.debug("Copying respawn location capability of player {}", (Object)event.getPlayer().func_200200_C_().func_150261_e());
        }));
    }

    @SubscribeEvent
    public void onPlayerCapabilityAttach(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof PlayerEntity && !(event.getObject() instanceof FakePlayer) && !((Entity)event.getObject()).getCapability(Main.RESPAWN_CAPABILITY).isPresent()) {
            event.addCapability(RESPAWN_CAPABILITY_ID, (ICapabilityProvider)new SpawnPointCapabilityProvider());
            Main.LOGGER.debug("Attaching respawn capability to player");
        }
    }

    @Nullable
    public BlockPos findValidRespawnLocation(ServerWorld world, BlockPos deathLocation) {
        int min = (Integer)Main.SERVER_CONFIG.minRespawnDistance.get();
        int max = (Integer)Main.SERVER_CONFIG.maxRespawnDistance.get();
        BlockPos pos = null;
        for (int i = 0; i < 16 && pos == null; ++i) {
            Main.LOGGER.debug("Searching for respawn location - Attempt {}/{}", (Object)(i + 1), (Object)16);
            pos = SpawnLocationHelper.func_241094_a_((ServerWorld)world, (ChunkPos)new ChunkPos(new BlockPos(this.getRandomRange(deathLocation.func_177958_n(), min, max), 0, this.getRandomRange(deathLocation.func_177952_p(), min, max))), (boolean)true);
        }
        if (pos == null) {
            Main.LOGGER.debug("Found no valid respawn location after {} attempts", (Object)16);
        } else {
            Main.LOGGER.debug("Found valid respawn location: [{}, {}, {}]", (Object)pos.func_177958_n(), (Object)pos.func_177956_o(), (Object)pos.func_177952_p());
        }
        return pos;
    }

    private int getRandomRange(int actual, int minDistance, int maxDistance) {
        return actual + (this.random.nextBoolean() ? -1 : 1) * (minDistance + this.random.nextInt(maxDistance - minDistance));
    }
}

