/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.better_respawn.corelib.death;

import de.maxhenkel.better_respawn.corelib.death.Death;
import de.maxhenkel.better_respawn.corelib.death.DeathManager;
import de.maxhenkel.better_respawn.corelib.death.PlayerDeathEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public final class DeathEvents {
    private Map<ServerPlayerEntity, Death> deathMap = new HashMap<ServerPlayerEntity, Death>();

    @SubscribeEvent(priority=EventPriority.LOWEST)
    void playerDeath(LivingDeathEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof ServerPlayerEntity)) {
            return;
        }
        ServerPlayerEntity player = (ServerPlayerEntity)event.getEntity();
        this.deathMap.put(player, Death.fromPlayer((PlayerEntity)player));
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    void playerDeath(LivingDropsEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof ServerPlayerEntity)) {
            return;
        }
        try {
            ServerPlayerEntity player = (ServerPlayerEntity)event.getEntity();
            Death death = this.deathMap.remove(player);
            if (death == null) {
                death = Death.fromPlayer((PlayerEntity)player);
            }
            Collection drops = event.getDrops();
            death.processDrops(new ArrayList<ItemEntity>(drops));
            PlayerDeathEvent playerDeathEvent = new PlayerDeathEvent(death, player, event.getSource());
            MinecraftForge.EVENT_BUS.post((Event)playerDeathEvent);
            if (playerDeathEvent.isStoreDeath()) {
                DeathManager.addDeath(player, death);
            }
            if (playerDeathEvent.isRemoveDrops()) {
                drops.clear();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void register() {
        MinecraftForge.EVENT_BUS.register((Object)new DeathEvents());
    }
}

