/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.client.renderer;

import com.mojang.blaze3d.matrix.MatrixStack;
import mod.beethoven92.betterendforge.client.renderer.BeamRenderer;
import mod.beethoven92.betterendforge.client.renderer.EndCrystalRenderer;
import mod.beethoven92.betterendforge.client.renderer.EternalCrystalRenderer;
import mod.beethoven92.betterendforge.common.block.EternalPedestal;
import mod.beethoven92.betterendforge.common.block.template.PedestalBlock;
import mod.beethoven92.betterendforge.common.init.ModBlocks;
import mod.beethoven92.betterendforge.common.init.ModItems;
import mod.beethoven92.betterendforge.common.tileentity.PedestalTileEntity;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.Property;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PedestalRenderer<T extends PedestalTileEntity>
extends TileEntityRenderer<T> {
    public PedestalRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(T tileEntityIn, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (((PedestalTileEntity)((Object)tileEntityIn)).isEmpty()) {
            return;
        }
        BlockState state = tileEntityIn.func_145831_w().func_180495_p(tileEntityIn.func_174877_v());
        if (!(state.func_177230_c() instanceof PedestalBlock)) {
            return;
        }
        ItemStack activeItem = ((PedestalTileEntity)((Object)tileEntityIn)).getStack();
        matrixStackIn.func_227860_a_();
        Minecraft minecraft = Minecraft.func_71410_x();
        IBakedModel model = minecraft.func_175599_af().func_184393_a(activeItem, tileEntityIn.func_145831_w(), null);
        Vector3f translate = model.func_177552_f().field_181699_o.field_178365_c;
        PedestalBlock pedestal = (PedestalBlock)state.func_177230_c();
        matrixStackIn.func_227861_a_((double)translate.func_195899_a(), (double)translate.func_195900_b(), (double)translate.func_195902_c());
        matrixStackIn.func_227861_a_(0.5, (double)pedestal.getHeight(state), 0.5);
        if (activeItem.func_77973_b() instanceof BlockItem) {
            matrixStackIn.func_227862_a_(1.5f, 1.5f, 1.5f);
        } else {
            matrixStackIn.func_227862_a_(1.25f, 1.25f, 1.25f);
        }
        int age = ((PedestalTileEntity)((Object)tileEntityIn)).getAge();
        if (state.func_203425_a((Block)ModBlocks.ETERNAL_PEDESTAL.get()) && ((Boolean)state.func_177229_b((Property)EternalPedestal.ACTIVATED)).booleanValue()) {
            float[] colors = EternalCrystalRenderer.colors(age);
            int y = tileEntityIn.func_174877_v().func_177956_o();
            BeamRenderer.renderLightBeam(matrixStackIn, bufferIn, age, partialTicks, -y, 1024 - y, colors, 0.25f, 0.13f, 0.16f);
            float altitude = MathHelper.func_76126_a((float)(((float)((PedestalTileEntity)((Object)tileEntityIn)).getAge() + partialTicks) / 10.0f)) * 0.1f + 0.1f;
            matrixStackIn.func_227861_a_(0.0, (double)altitude, 0.0);
        }
        if (activeItem.func_77973_b() == Items.field_185158_cP) {
            EndCrystalRenderer.render(age, ((PedestalTileEntity)((Object)tileEntityIn)).getMaxAge(), partialTicks, matrixStackIn, bufferIn, combinedLightIn);
        } else if (activeItem.func_77973_b() == ModItems.ETERNAL_CRYSTAL.get()) {
            EternalCrystalRenderer.render(age, partialTicks, matrixStackIn, bufferIn, combinedLightIn);
        } else {
            float rotation = ((float)age + partialTicks) / 25.0f + 6.0f;
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_(rotation));
            minecraft.func_175599_af().func_229111_a_(activeItem, ItemCameraTransforms.TransformType.GROUND, false, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn, model);
        }
        matrixStackIn.func_227865_b_();
    }

    public boolean isGlobalRenderer(T te) {
        return true;
    }
}

