/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.block;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Random;
import mod.beethoven92.betterendforge.common.block.BlockProperties;
import mod.beethoven92.betterendforge.common.init.ModBlocks;
import mod.beethoven92.betterendforge.common.init.ModTags;
import mod.beethoven92.betterendforge.common.util.BlockHelper;
import mod.beethoven92.betterendforge.common.util.ModMathHelper;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.entity.Entity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class NeonCactusPlantBlock
extends Block
implements IWaterLoggable {
    public static final EnumProperty<BlockProperties.TripleShape> SHAPE = BlockProperties.TRIPLE_SHAPE;
    public static final EnumProperty<BlockProperties.CactusBottom> CACTUS_BOTTOM = BlockProperties.CACTUS_BOTTOM;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final DirectionProperty FACING = BlockStateProperties.field_208155_H;
    private static final EnumMap<Direction, VoxelShape> BIG_SHAPES_OPEN = Maps.newEnumMap(Direction.class);
    private static final EnumMap<Direction, VoxelShape> MEDIUM_SHAPES_OPEN = Maps.newEnumMap(Direction.class);
    private static final EnumMap<Direction, VoxelShape> SMALL_SHAPES_OPEN = Maps.newEnumMap(Direction.class);
    private static final EnumMap<Direction.Axis, VoxelShape> BIG_SHAPES = Maps.newEnumMap(Direction.Axis.class);
    private static final EnumMap<Direction.Axis, VoxelShape> MEDIUM_SHAPES = Maps.newEnumMap(Direction.Axis.class);
    private static final EnumMap<Direction.Axis, VoxelShape> SMALL_SHAPES = Maps.newEnumMap(Direction.Axis.class);
    private static final int MAX_LENGTH = 12;

    public NeonCactusPlantBlock() {
        super(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150434_aF).func_235838_a_(s -> 15).func_200944_c());
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)FACING, (Comparable)Direction.UP)).func_206870_a(SHAPE, (Comparable)((Object)BlockProperties.TripleShape.TOP)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> stateManager) {
        stateManager.func_206894_a(new Property[]{SHAPE, CACTUS_BOTTOM, WATERLOGGED, FACING});
    }

    public BlockState func_196258_a(BlockItemUseContext ctx) {
        World world = ctx.func_195991_k();
        BlockPos pos = ctx.func_195995_a();
        Direction dir = ctx.func_196000_l();
        BlockState down = world.func_180495_p(pos.func_177972_a(dir.func_176734_d()));
        BlockState state = (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(world.func_204610_c(pos).func_206886_c() == Fluids.field_204546_a))).func_206870_a((Property)FACING, (Comparable)ctx.func_196000_l());
        state = down.func_203425_a(Blocks.field_150377_bs) || down.func_203425_a((Block)ModBlocks.ENDSTONE_DUST.get()) ? (BlockState)state.func_206870_a(CACTUS_BOTTOM, (Comparable)((Object)BlockProperties.CactusBottom.SAND)) : (down.func_203425_a((Block)ModBlocks.END_MOSS.get()) ? (BlockState)state.func_206870_a(CACTUS_BOTTOM, (Comparable)((Object)BlockProperties.CactusBottom.MOSS)) : (BlockState)state.func_206870_a(CACTUS_BOTTOM, (Comparable)((Object)BlockProperties.CactusBottom.EMPTY)));
        return state;
    }

    public BlockState func_185499_a(BlockState state, Rotation rotation) {
        return BlockHelper.rotateHorizontal(state, rotation, FACING);
    }

    public BlockState func_185471_a(BlockState state, Mirror mirror) {
        return BlockHelper.mirrorHorizontal(state, mirror, FACING);
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos pos, BlockPos facingPos) {
        Direction dir;
        BlockState downState;
        world.func_205220_G_().func_205360_a(pos, (Object)this, 2);
        if (((Boolean)state.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            world.func_205219_F_().func_205360_a(pos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        state = (downState = world.func_180495_p(pos.func_177972_a((dir = (Direction)state.func_177229_b((Property)FACING)).func_176734_d()))).func_203425_a(Blocks.field_150377_bs) || downState.func_203425_a((Block)ModBlocks.ENDSTONE_DUST.get()) ? (BlockState)state.func_206870_a(CACTUS_BOTTOM, (Comparable)((Object)BlockProperties.CactusBottom.SAND)) : (downState.func_203425_a((Block)ModBlocks.END_MOSS.get()) ? (BlockState)state.func_206870_a(CACTUS_BOTTOM, (Comparable)((Object)BlockProperties.CactusBottom.MOSS)) : (BlockState)state.func_206870_a(CACTUS_BOTTOM, (Comparable)((Object)BlockProperties.CactusBottom.EMPTY)));
        return state;
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        if (!state.func_196955_c((IWorldReader)worldIn, pos)) {
            worldIn.func_241212_a_(pos, true, null, 1);
        }
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader view, BlockPos pos, ISelectionContext context) {
        BlockProperties.TripleShape shape = (BlockProperties.TripleShape)((Object)state.func_177229_b(SHAPE));
        Direction dir = (Direction)state.func_177229_b((Property)FACING);
        BlockState next = view.func_180495_p(pos.func_177972_a(dir));
        if (next.func_203425_a((Block)this)) {
            Direction.Axis axis = dir.func_176740_k();
            if (shape == BlockProperties.TripleShape.BOTTOM) {
                return BIG_SHAPES.get(axis);
            }
            return shape == BlockProperties.TripleShape.MIDDLE ? MEDIUM_SHAPES.get(axis) : SMALL_SHAPES.get(axis);
        }
        if (shape == BlockProperties.TripleShape.BOTTOM) {
            return BIG_SHAPES_OPEN.get(dir);
        }
        return shape == BlockProperties.TripleShape.MIDDLE ? MEDIUM_SHAPES_OPEN.get(dir) : SMALL_SHAPES_OPEN.get(dir);
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        Direction dir = (Direction)state.func_177229_b((Property)FACING);
        BlockPos supportPos = pos.func_177972_a(dir.func_176734_d());
        BlockState support = worldIn.func_180495_p(supportPos);
        return support.func_203425_a((Block)this) || support.func_224755_d((IBlockReader)worldIn, supportPos, dir);
    }

    public void func_225542_b_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        Direction side;
        BlockPos sidePos;
        if (!this.func_196260_a(state, (IWorldReader)world, pos) || random.nextInt(8) > 0) {
            return;
        }
        Direction dir = (Direction)state.func_177229_b((Property)FACING);
        if (!world.func_175623_d(pos.func_177972_a(dir))) {
            return;
        }
        int length = this.getLength(state, world, pos, 12);
        if (length < 0 || length > 11) {
            return;
        }
        if (dir.func_176740_k().func_176722_c()) {
            int horizontal = this.getHorizontal(state, (ISeedReader)world, pos, 2);
            if (horizontal > random.nextInt(2)) {
                dir = Direction.UP;
                if (!world.func_180495_p(pos.func_177984_a()).func_196958_f()) {
                    return;
                }
            }
        } else if (length > 1 && world.func_180495_p(pos.func_177972_a(dir.func_176734_d())).func_203425_a((Block)this) && world.func_175623_d(sidePos = pos.func_177972_a(side = this.getSideDirection((ISeedReader)world, pos, state, dir, random)))) {
            BlockState placement = (BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a(SHAPE, (Comparable)((Object)BlockProperties.TripleShape.TOP))).func_206870_a(CACTUS_BOTTOM, (Comparable)((Object)BlockProperties.CactusBottom.EMPTY))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)FACING, (Comparable)side);
            BlockHelper.setWithoutUpdate((IWorldWriter)world, sidePos, placement);
        }
        BlockState placement = (BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a(SHAPE, (Comparable)((Object)BlockProperties.TripleShape.TOP))).func_206870_a(CACTUS_BOTTOM, (Comparable)((Object)BlockProperties.CactusBottom.EMPTY))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)FACING, (Comparable)dir);
        BlockHelper.setWithoutUpdate((IWorldWriter)world, pos.func_177972_a(dir), placement);
        this.mutateStem(placement, (ISeedReader)world, pos, 12);
    }

    public void growPlant(ISeedReader world, BlockPos pos, Random random) {
        this.growPlant(world, pos, random, ModMathHelper.randRange(6, 12, random));
    }

    public void growPlant(ISeedReader world, BlockPos pos, Random random, int iterations) {
        BlockState state = this.func_176223_P();
        BlockState downState = world.func_180495_p(pos.func_177977_b());
        state = downState.func_203425_a(Blocks.field_150377_bs) || downState.func_203425_a((Block)ModBlocks.ENDSTONE_DUST.get()) ? (BlockState)state.func_206870_a(CACTUS_BOTTOM, (Comparable)((Object)BlockProperties.CactusBottom.SAND)) : (downState.func_203425_a((Block)ModBlocks.END_MOSS.get()) ? (BlockState)state.func_206870_a(CACTUS_BOTTOM, (Comparable)((Object)BlockProperties.CactusBottom.MOSS)) : (BlockState)state.func_206870_a(CACTUS_BOTTOM, (Comparable)((Object)BlockProperties.CactusBottom.EMPTY)));
        BlockHelper.setWithoutUpdate((IWorldWriter)world, pos, state);
        ArrayList ends = Lists.newArrayList((Object[])new BlockPos.Mutable[]{pos.func_239590_i_()});
        for (int i = 0; i < iterations; ++i) {
            int count = ends.size();
            for (int n = 0; n < count; ++n) {
                if (this.growIteration(world, (BlockPos.Mutable)ends.get(n), random, ends, i)) continue;
                ends.remove(n);
                --count;
                --n;
            }
        }
    }

    private boolean growIteration(ISeedReader world, BlockPos.Mutable pos, Random random, List<BlockPos.Mutable> ends, int length) {
        Direction side;
        BlockPos sidePos;
        BlockState state = world.func_180495_p((BlockPos)pos);
        if (!state.func_203425_a((Block)this)) {
            return false;
        }
        Direction dir = (Direction)state.func_177229_b((Property)FACING);
        if (!world.func_175623_d(pos.func_177972_a(dir))) {
            return false;
        }
        if (dir.func_176740_k().func_176722_c()) {
            int horizontal = this.getHorizontal(state, world, (BlockPos)pos, 2);
            if (horizontal > random.nextInt(2)) {
                dir = Direction.UP;
                if (!world.func_180495_p(pos.func_177984_a()).func_196958_f()) {
                    return false;
                }
            }
        } else if (length > 1 && world.func_180495_p(pos.func_177977_b()).func_203425_a((Block)this) && world.func_175623_d(sidePos = pos.func_177972_a(side = this.getSideDirection(world, (BlockPos)pos, state, dir, random)))) {
            BlockState placement = (BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a(SHAPE, (Comparable)((Object)BlockProperties.TripleShape.TOP))).func_206870_a(CACTUS_BOTTOM, (Comparable)((Object)BlockProperties.CactusBottom.EMPTY))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)FACING, (Comparable)side);
            BlockHelper.setWithoutUpdate((IWorldWriter)world, sidePos, placement);
            ends.add(sidePos.func_239590_i_());
        }
        BlockState placement = (BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a(SHAPE, (Comparable)((Object)BlockProperties.TripleShape.TOP))).func_206870_a(CACTUS_BOTTOM, (Comparable)((Object)BlockProperties.CactusBottom.EMPTY))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)FACING, (Comparable)dir);
        BlockHelper.setWithoutUpdate((IWorldWriter)world, pos.func_177972_a(dir), placement);
        this.mutateStem(placement, world, (BlockPos)pos, 12);
        pos.func_189536_c(dir);
        return true;
    }

    private Direction getSideDirection(ISeedReader world, BlockPos pos, BlockState iterState, Direction dir, Random random) {
        Direction side;
        BlockPos.Mutable iterPos = pos.func_239590_i_();
        Direction startDir = dir;
        Direction lastDir = null;
        while (iterState.func_203425_a((Block)this) && startDir.func_176740_k().func_200128_b()) {
            startDir = (Direction)iterState.func_177229_b((Property)FACING);
            if (lastDir == null) {
                for (Direction side2 : BlockHelper.HORIZONTAL_DIRECTIONS) {
                    Direction sideDir;
                    BlockState sideState = world.func_180495_p(iterPos.func_177972_a(side2));
                    if (!sideState.func_203425_a((Block)this) || (sideDir = (Direction)sideState.func_177229_b((Property)FACING)) != side2) continue;
                    lastDir = sideDir;
                }
            }
            iterPos.func_189536_c(dir);
            iterState = world.func_180495_p((BlockPos)iterPos);
        }
        Direction direction = side = lastDir == null ? BlockHelper.randomHorizontal(random) : lastDir.func_176746_e();
        if (side.func_176734_d() == startDir) {
            side = side.func_176734_d();
        }
        return side;
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        entityIn.func_70097_a(DamageSource.field_76367_g, 1.0f);
    }

    private int getLength(BlockState state, ServerWorld world, BlockPos pos, int max) {
        int length = 0;
        Direction dir = ((Direction)state.func_177229_b((Property)FACING)).func_176734_d();
        BlockPos.Mutable mut = new BlockPos.Mutable().func_189533_g((Vector3i)pos);
        for (int i = 0; i < max; ++i) {
            mut.func_189536_c(dir);
            state = world.func_180495_p((BlockPos)mut);
            if (!state.func_203425_a((Block)this)) {
                if (state.func_235714_a_(ModTags.END_GROUND)) break;
                length = -1;
                break;
            }
            dir = ((Direction)state.func_177229_b((Property)FACING)).func_176734_d();
            ++length;
        }
        return length;
    }

    private int getHorizontal(BlockState state, ISeedReader world, BlockPos pos, int max) {
        int count = 0;
        Direction dir = ((Direction)state.func_177229_b((Property)FACING)).func_176734_d();
        BlockPos.Mutable mut = new BlockPos.Mutable().func_189533_g((Vector3i)pos);
        for (int i = 0; i < max; ++i) {
            mut.func_189536_c(dir);
            state = world.func_180495_p((BlockPos)mut);
            if (!state.func_203425_a((Block)this) || (dir = ((Direction)state.func_177229_b((Property)FACING)).func_176734_d()).func_96559_d() != 0) break;
            ++count;
        }
        return count;
    }

    private void mutateStem(BlockState state, ISeedReader world, BlockPos pos, int max) {
        Direction dir = ((Direction)state.func_177229_b((Property)FACING)).func_176734_d();
        BlockPos.Mutable mut = new BlockPos.Mutable().func_189533_g((Vector3i)pos);
        for (int i = 0; i < max; ++i) {
            mut.func_189536_c(dir);
            state = world.func_180495_p((BlockPos)mut);
            if (!state.func_203425_a((Block)this)) {
                return;
            }
            int size = (i + 2) * 3 / max;
            int src = ((BlockProperties.TripleShape)((Object)state.func_177229_b(SHAPE))).getIndex();
            dir = ((Direction)state.func_177229_b((Property)FACING)).func_176734_d();
            if (src >= size) continue;
            BlockProperties.TripleShape shape = BlockProperties.TripleShape.fromIndex(size);
            BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)mut, (BlockState)state.func_206870_a(SHAPE, (Comparable)((Object)shape)));
        }
    }

    static {
        BIG_SHAPES.put(Direction.Axis.X, Block.func_208617_a((double)0.0, (double)2.0, (double)2.0, (double)16.0, (double)14.0, (double)14.0));
        BIG_SHAPES.put(Direction.Axis.Y, Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0));
        BIG_SHAPES.put(Direction.Axis.Z, Block.func_208617_a((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)14.0, (double)16.0));
        MEDIUM_SHAPES.put(Direction.Axis.X, Block.func_208617_a((double)0.0, (double)3.0, (double)3.0, (double)16.0, (double)13.0, (double)13.0));
        MEDIUM_SHAPES.put(Direction.Axis.Y, Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0));
        MEDIUM_SHAPES.put(Direction.Axis.Z, Block.func_208617_a((double)3.0, (double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)16.0));
        SMALL_SHAPES.put(Direction.Axis.X, Block.func_208617_a((double)0.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0));
        SMALL_SHAPES.put(Direction.Axis.Y, Block.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0));
        SMALL_SHAPES.put(Direction.Axis.Z, Block.func_208617_a((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)16.0));
        BIG_SHAPES_OPEN.put(Direction.UP, Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0));
        BIG_SHAPES_OPEN.put(Direction.DOWN, Block.func_208617_a((double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0));
        BIG_SHAPES_OPEN.put(Direction.NORTH, Block.func_208617_a((double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)14.0, (double)16.0));
        BIG_SHAPES_OPEN.put(Direction.SOUTH, Block.func_208617_a((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)14.0, (double)14.0));
        BIG_SHAPES_OPEN.put(Direction.WEST, Block.func_208617_a((double)2.0, (double)2.0, (double)2.0, (double)16.0, (double)14.0, (double)14.0));
        BIG_SHAPES_OPEN.put(Direction.EAST, Block.func_208617_a((double)0.0, (double)2.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0));
        MEDIUM_SHAPES_OPEN.put(Direction.UP, Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)13.0, (double)13.0));
        MEDIUM_SHAPES_OPEN.put(Direction.DOWN, Block.func_208617_a((double)3.0, (double)3.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0));
        MEDIUM_SHAPES_OPEN.put(Direction.NORTH, Block.func_208617_a((double)3.0, (double)3.0, (double)3.0, (double)13.0, (double)13.0, (double)16.0));
        MEDIUM_SHAPES_OPEN.put(Direction.SOUTH, Block.func_208617_a((double)3.0, (double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)13.0));
        MEDIUM_SHAPES_OPEN.put(Direction.WEST, Block.func_208617_a((double)3.0, (double)3.0, (double)3.0, (double)16.0, (double)13.0, (double)13.0));
        MEDIUM_SHAPES_OPEN.put(Direction.EAST, Block.func_208617_a((double)0.0, (double)3.0, (double)3.0, (double)13.0, (double)13.0, (double)13.0));
        SMALL_SHAPES_OPEN.put(Direction.UP, Block.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0));
        SMALL_SHAPES_OPEN.put(Direction.DOWN, Block.func_208617_a((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0));
        SMALL_SHAPES_OPEN.put(Direction.NORTH, Block.func_208617_a((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)16.0));
        SMALL_SHAPES_OPEN.put(Direction.SOUTH, Block.func_208617_a((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)12.0));
        SMALL_SHAPES_OPEN.put(Direction.WEST, Block.func_208617_a((double)4.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0));
        SMALL_SHAPES_OPEN.put(Direction.EAST, Block.func_208617_a((double)0.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0));
    }
}

