/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.entity;

import java.util.List;
import java.util.Random;
import mod.beethoven92.betterendforge.common.init.ModBiomes;
import mod.beethoven92.betterendforge.common.init.ModItems;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.passive.fish.AbstractGroupFishEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.network.play.server.SChangeGameStatePacket;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;

public class CubozoaEntity
extends AbstractGroupFishEntity {
    public static final int VARIANTS = 2;
    private static final DataParameter<Byte> VARIANT = EntityDataManager.func_187226_a(CubozoaEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Byte> SCALE = EntityDataManager.func_187226_a(CubozoaEntity.class, (IDataSerializer)DataSerializers.field_187191_a);

    public CubozoaEntity(EntityType<CubozoaEntity> entityType, World world) {
        super(entityType, world);
    }

    public ILivingEntityData func_213386_a(IServerWorld world, DifficultyInstance difficulty, SpawnReason spawnReason, ILivingEntityData entityData, CompoundNBT entityTag) {
        ILivingEntityData data = super.func_213386_a(world, difficulty, spawnReason, entityData, entityTag);
        if (ModBiomes.getFromBiome(world.func_226691_t_(this.func_233580_cy_())) == ModBiomes.SULPHUR_SPRINGS) {
            this.field_70180_af.func_187227_b(VARIANT, (Object)1);
        }
        if (entityTag != null) {
            if (entityTag.func_74764_b("variant")) {
                this.field_70180_af.func_187227_b(VARIANT, (Object)entityTag.func_74771_c("variant"));
            }
            if (entityTag.func_74764_b("scale")) {
                this.field_70180_af.func_187227_b(SCALE, (Object)entityTag.func_74771_c("scale"));
            }
        }
        this.func_213323_x_();
        return data;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(VARIANT, (Object)0);
        this.field_70180_af.func_187214_a(SCALE, (Object)((byte)this.func_70681_au().nextInt(16)));
    }

    public void func_213281_b(CompoundNBT tag) {
        super.func_213281_b(tag);
        tag.func_74774_a("Variant", (byte)this.getVariant());
        tag.func_74774_a("Scale", ((Byte)this.field_70180_af.func_187225_a(SCALE)).byteValue());
    }

    public void func_70037_a(CompoundNBT tag) {
        super.func_70037_a(tag);
        if (tag.func_74764_b("Variant")) {
            this.field_70180_af.func_187227_b(VARIANT, (Object)tag.func_74771_c("Variant"));
        }
        if (tag.func_74764_b("Scale")) {
            this.field_70180_af.func_187227_b(SCALE, (Object)tag.func_74771_c("Scale"));
        }
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return LivingEntity.func_233639_cI_().func_233815_a_(Attributes.field_233818_a_, 2.0).func_233815_a_(Attributes.field_233819_b_, 16.0).func_233815_a_(Attributes.field_233821_d_, 0.5);
    }

    public int getVariant() {
        return ((Byte)this.field_70180_af.func_187225_a(VARIANT)).byteValue();
    }

    public float getScale() {
        return (float)((Byte)this.field_70180_af.func_187225_a(SCALE)).byteValue() / 32.0f + 0.75f;
    }

    public static boolean canSpawn(EntityType<CubozoaEntity> type, IServerWorld world, SpawnReason spawnReason, BlockPos pos, Random random) {
        AxisAlignedBB box = new AxisAlignedBB(pos).func_186662_g(16.0);
        List list = world.func_175647_a(CubozoaEntity.class, box, entity -> true);
        return list.size() < 9;
    }

    protected float func_213348_b(Pose pose, EntitySize dimensions) {
        return dimensions.field_220316_b * 0.5f;
    }

    protected ItemStack func_203707_dx() {
        ItemStack bucket = ((Item)ModItems.BUCKET_CUBOZOA.get()).func_190903_i();
        CompoundNBT tag = bucket.func_196082_o();
        tag.func_74774_a("variant", ((Byte)this.field_70180_af.func_187225_a(VARIANT)).byteValue());
        tag.func_74774_a("scale", ((Byte)this.field_70180_af.func_187225_a(SCALE)).byteValue());
        return bucket;
    }

    protected SoundEvent func_203701_dz() {
        return SoundEvents.field_203822_gO;
    }

    public void func_70100_b_(PlayerEntity player) {
        if (player instanceof ServerPlayerEntity && player.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), 0.5f)) {
            if (!this.func_174814_R()) {
                ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new SChangeGameStatePacket(SChangeGameStatePacket.field_241773_j_, 0.0f));
            }
            if (this.field_70146_Z.nextBoolean()) {
                player.func_195064_c(new EffectInstance(Effects.field_76436_u, 20, 0));
            }
        }
    }
}

