/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.entity;

import java.util.List;
import java.util.Random;
import mod.beethoven92.betterendforge.common.init.ModSoundEvents;
import mod.beethoven92.betterendforge.common.util.ModMathHelper;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;

public class ShadowWalkerEntity
extends MonsterEntity {
    public ShadowWalkerEntity(EntityType<? extends MonsterEntity> type, World worldIn) {
        super(type, worldIn);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(2, (Goal)new AttackGoal(this, 1.0, false));
        this.field_70714_bg.func_75776_a(7, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233819_b_, 35.0).func_233815_a_(Attributes.field_233821_d_, 0.15).func_233815_a_(Attributes.field_233823_f_, 4.5).func_233815_a_(Attributes.field_233826_i_, 2.0).func_233814_a_(Attributes.field_233829_l_);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_239813_am_, this.func_226277_ct_() + this.field_70146_Z.nextGaussian() * 0.2, this.func_226278_cu_() + this.field_70146_Z.nextGaussian() * 0.5 + 1.0, this.func_226281_cx_() + this.field_70146_Z.nextGaussian() * 0.2, 0.0, 0.0, 0.0);
        this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197601_L, this.func_226277_ct_() + this.field_70146_Z.nextGaussian() * 0.2, this.func_226278_cu_() + this.field_70146_Z.nextGaussian() * 0.5 + 1.0, this.func_226281_cx_() + this.field_70146_Z.nextGaussian() * 0.2, 0.0, 0.0, 0.0);
        this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197625_r, this.func_226277_ct_() + this.field_70146_Z.nextGaussian() * 0.2, this.func_226278_cu_() + this.field_70146_Z.nextGaussian() * 0.5 + 1.0, this.func_226281_cx_() + this.field_70146_Z.nextGaussian() * 0.2, 0.0, 0.0, 0.0);
    }

    protected SoundEvent func_184639_G() {
        return (SoundEvent)ModSoundEvents.ENTITY_SHADOW_WALKER.get();
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return (SoundEvent)ModSoundEvents.ENTITY_SHADOW_WALKER_DAMAGE.get();
    }

    protected SoundEvent func_184615_bR() {
        return (SoundEvent)ModSoundEvents.ENTITY_SHADOW_WALKER_DEATH.get();
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
    }

    protected float func_70599_aP() {
        return ModMathHelper.randRange(0.25f, 0.5f, this.field_70146_Z);
    }

    protected float func_70647_i() {
        return ModMathHelper.randRange(0.75f, 1.25f, this.field_70146_Z);
    }

    public static boolean canSpawn(EntityType<ShadowWalkerEntity> type, IServerWorld world, SpawnReason spawnReason, BlockPos pos, Random random) {
        if (MonsterEntity.func_223325_c(type, (IServerWorld)world, (SpawnReason)spawnReason, (BlockPos)pos, (Random)random)) {
            AxisAlignedBB box = new AxisAlignedBB(pos).func_186662_g(16.0);
            List entities = world.func_175647_a(ShadowWalkerEntity.class, box, entity -> true);
            return entities.size() < 6;
        }
        return false;
    }

    public boolean func_70652_k(Entity entityIn) {
        LivingEntity living;
        boolean attack = super.func_70652_k(entityIn);
        if (attack && entityIn instanceof LivingEntity && !(living = (LivingEntity)entityIn).func_70644_a(Effects.field_76440_q)) {
            living.func_195064_c(new EffectInstance(Effects.field_76440_q, 60));
        }
        return attack;
    }

    private final class AttackGoal
    extends MeleeAttackGoal {
        private final ShadowWalkerEntity walker;
        private int ticks;

        public AttackGoal(ShadowWalkerEntity walker, double speed, boolean pauseWhenMobIdle) {
            super((CreatureEntity)walker, speed, pauseWhenMobIdle);
            this.walker = walker;
        }

        public void func_75249_e() {
            super.func_75249_e();
            this.ticks = 0;
        }

        public void func_75251_c() {
            super.func_75251_c();
            this.walker.func_213395_q(false);
        }

        public void func_75246_d() {
            super.func_75246_d();
            ++this.ticks;
            if (this.ticks >= 5 && this.func_234041_j_() < this.func_234042_k_() / 2) {
                this.walker.func_213395_q(true);
            } else {
                this.walker.func_213395_q(false);
            }
        }
    }
}

