/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.init;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import mod.beethoven92.betterendforge.common.block.EndSignBlock;
import mod.beethoven92.betterendforge.common.block.material.StoneMaterial;
import mod.beethoven92.betterendforge.common.block.template.EndFurnaceBlock;
import mod.beethoven92.betterendforge.common.init.ModBlocks;
import mod.beethoven92.betterendforge.common.init.ModItems;
import mod.beethoven92.betterendforge.common.tileentity.EChestTileEntity;
import mod.beethoven92.betterendforge.common.tileentity.ESignTileEntity;
import mod.beethoven92.betterendforge.common.tileentity.EndBarrelTileEntity;
import mod.beethoven92.betterendforge.common.tileentity.EndFurnaceTileEntity;
import mod.beethoven92.betterendforge.common.tileentity.EndStoneSmelterTileEntity;
import mod.beethoven92.betterendforge.common.tileentity.EternalPedestalTileEntity;
import mod.beethoven92.betterendforge.common.tileentity.HydrothermalVentTileEntity;
import mod.beethoven92.betterendforge.common.tileentity.InfusionPedestalTileEntity;
import mod.beethoven92.betterendforge.common.tileentity.PedestalTileEntity;
import net.minecraft.block.BarrelBlock;
import net.minecraft.block.Block;
import net.minecraft.block.ChestBlock;
import net.minecraft.item.BlockItem;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ModTileEntityTypes {
    public static final DeferredRegister<TileEntityType<?>> TILE_ENTITY_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.TILE_ENTITIES, (String)"betterendforge");
    public static final RegistryObject<TileEntityType<PedestalTileEntity>> PEDESTAL = TILE_ENTITY_TYPES.register("pedestal_tile_entity", () -> TileEntityType.Builder.func_223042_a(PedestalTileEntity::new, (Block[])ModTileEntityTypes.getPedestals()).func_206865_a(null));
    public static final RegistryObject<TileEntityType<EternalPedestalTileEntity>> ETERNAL_PEDESTAL = TILE_ENTITY_TYPES.register("eternal_pedestal_tile_entity", () -> TileEntityType.Builder.func_223042_a(EternalPedestalTileEntity::new, (Block[])new Block[]{(Block)ModBlocks.ETERNAL_PEDESTAL.get()}).func_206865_a(null));
    public static final RegistryObject<TileEntityType<InfusionPedestalTileEntity>> INFUSION_PEDESTAL = TILE_ENTITY_TYPES.register("infusion_pedestal_tile_entity", () -> TileEntityType.Builder.func_223042_a(InfusionPedestalTileEntity::new, (Block[])new Block[]{(Block)ModBlocks.INFUSION_PEDESTAL.get()}).func_206865_a(null));
    public static final RegistryObject<TileEntityType<EndStoneSmelterTileEntity>> END_STONE_SMELTER = TILE_ENTITY_TYPES.register("end_stone_smelter_tile_entity", () -> TileEntityType.Builder.func_223042_a(EndStoneSmelterTileEntity::new, (Block[])new Block[]{(Block)ModBlocks.END_STONE_SMELTER.get()}).func_206865_a(null));
    public static final RegistryObject<TileEntityType<HydrothermalVentTileEntity>> HYDROTHERMAL_VENT = TILE_ENTITY_TYPES.register("hydrothermal_vent_tile_entity", () -> TileEntityType.Builder.func_223042_a(HydrothermalVentTileEntity::new, (Block[])new Block[]{(Block)ModBlocks.HYDROTHERMAL_VENT.get()}).func_206865_a(null));
    public static final RegistryObject<TileEntityType<EChestTileEntity>> CHEST = TILE_ENTITY_TYPES.register("chest", () -> TileEntityType.Builder.func_223042_a(EChestTileEntity::new, (Block[])ModTileEntityTypes.getChests()).func_206865_a(null));
    public static final RegistryObject<TileEntityType<ESignTileEntity>> SIGN = TILE_ENTITY_TYPES.register("sign", () -> TileEntityType.Builder.func_223042_a(ESignTileEntity::new, (Block[])ModTileEntityTypes.getSigns()).func_206865_a(null));
    public static final RegistryObject<TileEntityType<EndBarrelTileEntity>> BARREL = TILE_ENTITY_TYPES.register("barrel", () -> TileEntityType.Builder.func_223042_a(EndBarrelTileEntity::new, (Block[])ModTileEntityTypes.getBarrels()).func_206865_a(null));
    public static final RegistryObject<TileEntityType<EndFurnaceTileEntity>> FURNACE = TILE_ENTITY_TYPES.register("furnace", () -> TileEntityType.Builder.func_223042_a(EndFurnaceTileEntity::new, (Block[])ModTileEntityTypes.getFurnaces()).func_206865_a(null));

    static Block[] getPedestals() {
        ArrayList<IForgeRegistryEntry> result = new ArrayList<IForgeRegistryEntry>();
        for (StoneMaterial m : StoneMaterial.getMaterials()) {
            result.add(m.pedestal.get());
        }
        result.add(ModBlocks.PURPUR_PEDESTAL.get());
        result.add(ModBlocks.QUARTZ_PEDESTAL.get());
        result.add(ModBlocks.ANDESITE_PEDESTAL.get());
        result.add(ModBlocks.DIORITE_PEDESTAL.get());
        result.add(ModBlocks.GRANITE_PEDESTAL.get());
        return result.toArray(new Block[0]);
    }

    static Block[] getChests() {
        ArrayList result = Lists.newArrayList();
        ModItems.ITEMS.getEntries().forEach(item -> {
            Block block;
            if (item.get() instanceof BlockItem && (block = ((BlockItem)item.get()).func_179223_d()) instanceof ChestBlock) {
                result.add(block);
            }
        });
        return result.toArray(new Block[0]);
    }

    static Block[] getSigns() {
        ArrayList result = Lists.newArrayList();
        ModItems.ITEMS.getEntries().forEach(item -> {
            Block block;
            if (item.get() instanceof BlockItem && (block = ((BlockItem)item.get()).func_179223_d()) instanceof EndSignBlock) {
                result.add(block);
            }
        });
        return result.toArray(new Block[0]);
    }

    static Block[] getBarrels() {
        ArrayList result = Lists.newArrayList();
        ModItems.ITEMS.getEntries().forEach(item -> {
            Block block;
            if (item.get() instanceof BlockItem && (block = ((BlockItem)item.get()).func_179223_d()) instanceof BarrelBlock) {
                result.add(block);
            }
        });
        return result.toArray(new Block[0]);
    }

    static Block[] getFurnaces() {
        ArrayList result = Lists.newArrayList();
        ModItems.ITEMS.getEntries().forEach(item -> {
            Block block;
            if (item.get() instanceof BlockItem && (block = ((BlockItem)item.get()).func_179223_d()) instanceof EndFurnaceBlock) {
                result.add(block);
            }
        });
        return result.toArray(new Block[0]);
    }
}

