/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.particles;

import mod.beethoven92.betterendforge.common.block.TenaneaFlowersBlock;
import mod.beethoven92.betterendforge.common.util.ModMathHelper;
import net.minecraft.client.particle.IAnimatedSprite;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.SpriteTexturedParticle;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TenaneaPetalParticle
extends SpriteTexturedParticle {
    private double preVX;
    private double preVY;
    private double preVZ;
    private double nextVX;
    private double nextVY;
    private double nextVZ;

    protected TenaneaPetalParticle(ClientWorld world, double x, double y, double z, double r, double g, double b, IAnimatedSprite spriteWithAge) {
        super(world, x, y, z, r, g, b);
        this.func_217566_b(spriteWithAge);
        int color = TenaneaFlowersBlock.getBlockColor(new BlockPos(x, y, z));
        this.field_70552_h = (float)(color >> 16 & 0xFF) / 255.0f;
        this.field_70553_i = (float)(color >> 8 & 0xFF) / 255.0f;
        this.field_70551_j = (float)(color & 0xFF) / 255.0f;
        this.field_70547_e = ModMathHelper.randRange(120, 200, this.field_187136_p);
        this.field_70544_f = ModMathHelper.randRange(0.05f, 0.15f, this.field_187136_p);
        this.field_82339_as = 0.0f;
        this.preVX = 0.0;
        this.preVY = 0.0;
        this.preVZ = 0.0;
        this.nextVX = this.field_187136_p.nextGaussian() * 0.02;
        this.nextVY = -this.field_187136_p.nextDouble() * 0.02 - 0.02;
        this.nextVZ = this.field_187136_p.nextGaussian() * 0.02;
    }

    public IParticleRenderType func_217558_b() {
        return IParticleRenderType.field_217603_c;
    }

    public void func_189213_a() {
        int ticks = this.field_70546_d & 0x3F;
        if (ticks == 0) {
            this.preVX = this.nextVX;
            this.preVY = this.nextVY;
            this.preVZ = this.nextVZ;
            this.nextVX = this.field_187136_p.nextGaussian() * 0.02;
            this.nextVY = -this.field_187136_p.nextDouble() * 0.02 - 0.02;
            this.nextVZ = this.field_187136_p.nextGaussian() * 0.02;
        }
        double delta = (double)ticks / 63.0;
        if (this.field_70546_d <= 40) {
            this.func_82338_g((float)this.field_70546_d / 40.0f);
        } else if (this.field_70546_d >= this.field_70547_e - 40) {
            this.func_82338_g((float)(this.field_70547_e - this.field_70546_d) / 40.0f);
        }
        if (this.field_70546_d >= this.field_70547_e) {
            this.func_187112_i();
        }
        this.field_187129_i = MathHelper.func_219803_d((double)delta, (double)this.preVX, (double)this.nextVX);
        this.field_187130_j = MathHelper.func_219803_d((double)delta, (double)this.preVY, (double)this.nextVY);
        this.field_187131_k = MathHelper.func_219803_d((double)delta, (double)this.preVZ, (double)this.nextVZ);
        super.func_189213_a();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements IParticleFactory<BasicParticleType> {
        private final IAnimatedSprite sprite;

        public Factory(IAnimatedSprite sprite) {
            this.sprite = sprite;
        }

        public Particle makeParticle(BasicParticleType type, ClientWorld worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new TenaneaPetalParticle(worldIn, x, y, z, 1.0, 1.0, 1.0, this.sprite);
        }
    }
}

