/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.teleporter;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import mod.beethoven92.betterendforge.common.util.JsonFactory;
import mod.beethoven92.betterendforge.common.util.ModMathHelper;
import mod.beethoven92.betterendforge.config.jsons.JsonConfigWriter;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.server.ServerWorld;

public class EndPortals {
    private static PortalInfo[] portals;

    public static void loadPortals() {
        JsonArray array;
        JsonObject json;
        File file = new File(JsonConfigWriter.MOD_CONFIG_DIR, "portals.json");
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            json = EndPortals.makeDefault(file);
        } else {
            json = JsonFactory.getJsonObject(file);
        }
        if (!json.has("portals") || !json.get("portals").isJsonArray()) {
            json = EndPortals.makeDefault(file);
        }
        if ((array = json.get("portals").getAsJsonArray()).size() == 0) {
            json = EndPortals.makeDefault(file);
            array = json.get("portals").getAsJsonArray();
        }
        portals = new PortalInfo[array.size()];
        for (int i = 0; i < portals.length; ++i) {
            EndPortals.portals[i] = new PortalInfo(array.get(i).getAsJsonObject());
        }
    }

    public static int getCount() {
        return ModMathHelper.max(portals.length - 1, 1);
    }

    public static ServerWorld getWorld(MinecraftServer server, int state) {
        if (state >= portals.length) {
            return server.func_241755_D_();
        }
        return portals[state].getWorld(server);
    }

    public static int getPortalState(ResourceLocation item) {
        for (int i = 0; i < portals.length; ++i) {
            if (!portals[i].item.equals((Object)item)) continue;
            return i;
        }
        return 0;
    }

    public static int getColor(int state) {
        return portals[state].color;
    }

    public static boolean isAvailableItem(ResourceLocation item) {
        for (int i = 0; i < portals.length; ++i) {
            if (!portals[i].item.equals((Object)item)) continue;
            return true;
        }
        return false;
    }

    private static JsonObject makeDefault(File file) {
        JsonObject jsonObject = new JsonObject();
        JsonFactory.storeJson(file, (JsonElement)jsonObject);
        JsonArray array = new JsonArray();
        jsonObject.add("portals", (JsonElement)array);
        array.add((JsonElement)EndPortals.makeDefault().toJson());
        JsonFactory.storeJson(file, (JsonElement)jsonObject);
        return jsonObject;
    }

    private static PortalInfo makeDefault() {
        return new PortalInfo(new ResourceLocation("minecraft:overworld"), new ResourceLocation("betterendforge", "eternal_crystal"), 255, 255, 255);
    }

    private static class PortalInfo {
        private final ResourceLocation dimension;
        private final ResourceLocation item;
        private final int color;
        private ServerWorld world;

        PortalInfo(JsonObject obj) {
            this(new ResourceLocation(JsonFactory.getString(obj, "dimension", "minecraft:overworld")), new ResourceLocation(JsonFactory.getString(obj, "item", "betterendforge:eternal_crystal")), JsonFactory.getInt(obj, "colorRed", 255), JsonFactory.getInt(obj, "colorGreen", 255), JsonFactory.getInt(obj, "colorBlue", 255));
        }

        PortalInfo(ResourceLocation dimension, ResourceLocation item, int r, int g, int b) {
            this.dimension = dimension;
            this.item = item;
            this.color = ModMathHelper.color(r, g, b);
        }

        ServerWorld getWorld(MinecraftServer server) {
            if (this.world != null) {
                return this.world;
            }
            for (ServerWorld world : server.func_212370_w()) {
                if (!world.func_234923_W_().func_240901_a_().equals((Object)this.dimension)) continue;
                this.world = world;
                return world;
            }
            return server.func_241755_D_();
        }

        JsonObject toJson() {
            JsonObject obj = new JsonObject();
            obj.addProperty("dimension", this.dimension.toString());
            obj.addProperty("item", this.item.toString());
            obj.addProperty("colorRed", (Number)(this.color >> 16 & 0xFF));
            obj.addProperty("colorGreen", (Number)(this.color >> 8 & 0xFF));
            obj.addProperty("colorBlue", (Number)(this.color & 0xFF));
            return obj;
        }
    }
}

