/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.tileentity;

import mod.beethoven92.betterendforge.common.block.EndBarrelBlock;
import mod.beethoven92.betterendforge.common.init.ModTileEntityTypes;
import net.minecraft.block.BarrelBlock;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.ChestContainer;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.LockableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class EndBarrelTileEntity
extends LockableLootTileEntity {
    private NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)27, (Object)ItemStack.field_190927_a);
    private int viewerCount;

    private EndBarrelTileEntity(TileEntityType<?> type) {
        super(type);
    }

    public EndBarrelTileEntity() {
        this((TileEntityType)ModTileEntityTypes.BARREL.get());
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        if (!this.func_184282_c(tag)) {
            ItemStackHelper.func_191282_a((CompoundNBT)tag, this.inventory);
        }
        return tag;
    }

    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.inventory = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        if (!this.func_184283_b(tag)) {
            ItemStackHelper.func_191283_b((CompoundNBT)tag, this.inventory);
        }
    }

    public int func_70302_i_() {
        return 27;
    }

    protected NonNullList<ItemStack> func_190576_q() {
        return this.inventory;
    }

    protected void func_199721_a(NonNullList<ItemStack> list) {
        this.inventory = list;
    }

    protected ITextComponent func_213907_g() {
        return new TranslationTextComponent("container.barrel");
    }

    protected Container func_213906_a(int syncId, PlayerInventory playerInventory) {
        return ChestContainer.func_216992_a((int)syncId, (PlayerInventory)playerInventory, (IInventory)this);
    }

    public void func_174889_b(PlayerEntity player) {
        if (!player.func_175149_v()) {
            if (this.viewerCount < 0) {
                this.viewerCount = 0;
            }
            ++this.viewerCount;
            BlockState blockState = this.func_195044_w();
            boolean bl = (Boolean)blockState.func_177229_b((Property)BarrelBlock.field_220093_b);
            if (!bl) {
                this.playSound(blockState, SoundEvents.field_219602_O);
                this.setOpen(blockState, true);
            }
            this.scheduleTick();
        }
    }

    private void scheduleTick() {
        this.field_145850_b.func_205220_G_().func_205360_a(this.func_174877_v(), (Object)this.func_195044_w().func_177230_c(), 5);
    }

    public void tick() {
        int i = this.field_174879_c.func_177958_n();
        int j = this.field_174879_c.func_177956_o();
        int k = this.field_174879_c.func_177952_p();
        this.viewerCount = ChestTileEntity.func_213976_a((World)this.field_145850_b, (LockableTileEntity)this, (int)i, (int)j, (int)k);
        if (this.viewerCount > 0) {
            this.scheduleTick();
        } else {
            BlockState blockState = this.func_195044_w();
            if (!(blockState.func_177230_c() instanceof EndBarrelBlock)) {
                this.func_145843_s();
                return;
            }
            boolean bl = (Boolean)blockState.func_177229_b((Property)BarrelBlock.field_220093_b);
            if (bl) {
                this.playSound(blockState, SoundEvents.field_219601_N);
                this.setOpen(blockState, false);
            }
        }
    }

    public void func_174886_c(PlayerEntity player) {
        if (!player.func_175149_v()) {
            --this.viewerCount;
        }
    }

    private void setOpen(BlockState state, boolean open) {
        this.field_145850_b.func_180501_a(this.func_174877_v(), (BlockState)state.func_206870_a((Property)BarrelBlock.field_220093_b, (Comparable)Boolean.valueOf(open)), 3);
    }

    private void playSound(BlockState blockState, SoundEvent soundEvent) {
        Vector3i vec3i = ((Direction)blockState.func_177229_b((Property)BarrelBlock.field_220092_a)).func_176730_m();
        double d = (double)this.field_174879_c.func_177958_n() + 0.5 + (double)vec3i.func_177958_n() / 2.0;
        double e = (double)this.field_174879_c.func_177956_o() + 0.5 + (double)vec3i.func_177956_o() / 2.0;
        double f = (double)this.field_174879_c.func_177952_p() + 0.5 + (double)vec3i.func_177952_p() / 2.0;
        this.field_145850_b.func_184148_a((PlayerEntity)null, d, e, f, soundEvent, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
    }
}

