/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.tileentity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;
import mod.beethoven92.betterendforge.common.block.EndStoneSmelter;
import mod.beethoven92.betterendforge.common.init.ModTileEntityTypes;
import mod.beethoven92.betterendforge.common.inventory.EndStoneSmelterContainer;
import mod.beethoven92.betterendforge.common.recipes.AlloyingRecipe;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IRecipeHelperPopulator;
import net.minecraft.inventory.IRecipeHolder;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.AbstractCookingRecipe;
import net.minecraft.item.crafting.BlastingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeItemHelper;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.LockableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class EndStoneSmelterTileEntity
extends LockableTileEntity
implements ITickableTileEntity,
IRecipeHolder,
IRecipeHelperPopulator,
ISidedInventory {
    private static final int[] TOP_SLOTS = new int[]{0, 1};
    private static final int[] BOTTOM_SLOTS = new int[]{2, 3};
    private static final int[] SIDE_SLOTS = new int[]{2};
    private static final Map<Item, Integer> AVAILABLE_FUELS = Maps.newHashMap();
    private final Object2IntOpenHashMap<ResourceLocation> recipesUsed;
    protected NonNullList<ItemStack> items;
    protected final IIntArray data;
    private IRecipe<?> lastRecipe;
    private int smeltTimeTotal;
    private int smeltTime;
    private int burnTime;
    private int fuelTime;
    LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((ISidedInventory)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});

    public EndStoneSmelterTileEntity() {
        super((TileEntityType)ModTileEntityTypes.END_STONE_SMELTER.get());
        this.recipesUsed = new Object2IntOpenHashMap();
        this.items = NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);
        this.data = new IIntArray(){

            public int func_221476_a(int index) {
                switch (index) {
                    case 0: {
                        return EndStoneSmelterTileEntity.this.burnTime;
                    }
                    case 1: {
                        return EndStoneSmelterTileEntity.this.fuelTime;
                    }
                    case 2: {
                        return EndStoneSmelterTileEntity.this.smeltTime;
                    }
                    case 3: {
                        return EndStoneSmelterTileEntity.this.smeltTimeTotal;
                    }
                }
                return 0;
            }

            public void func_221477_a(int index, int value) {
                switch (index) {
                    case 0: {
                        EndStoneSmelterTileEntity.this.burnTime = value;
                        break;
                    }
                    case 1: {
                        EndStoneSmelterTileEntity.this.fuelTime = value;
                        break;
                    }
                    case 2: {
                        EndStoneSmelterTileEntity.this.smeltTime = value;
                        break;
                    }
                    case 3: {
                        EndStoneSmelterTileEntity.this.smeltTimeTotal = value;
                    }
                }
            }

            public int func_221478_a() {
                return 4;
            }
        };
        this.registerFuels();
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74777_a("BurnTime", (short)this.burnTime);
        compound.func_74777_a("FuelTime", (short)this.fuelTime);
        compound.func_74777_a("SmeltTime", (short)this.smeltTime);
        compound.func_74777_a("SmeltTimeTotal", (short)this.smeltTimeTotal);
        ItemStackHelper.func_191282_a((CompoundNBT)compound, this.items);
        CompoundNBT usedRecipes = new CompoundNBT();
        this.recipesUsed.forEach((identifier, integer) -> usedRecipes.func_74768_a(identifier.toString(), integer.intValue()));
        compound.func_218657_a("RecipesUsed", (INBT)usedRecipes);
        return compound;
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.items = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((CompoundNBT)nbt, this.items);
        this.burnTime = nbt.func_74765_d("BurnTime");
        this.fuelTime = nbt.func_74765_d("FuelTime");
        this.smeltTime = nbt.func_74765_d("SmeltTime");
        this.smeltTimeTotal = nbt.func_74765_d("SmeltTimeTotal");
        CompoundNBT compound = nbt.func_74775_l("RecipesUsed");
        for (String id : compound.func_150296_c()) {
            this.recipesUsed.put((Object)new ResourceLocation(id), compound.func_74762_e(id));
        }
    }

    private void registerFuels() {
        EndStoneSmelterTileEntity.registerFuel((IItemProvider)Items.field_151129_at, 16000);
        EndStoneSmelterTileEntity.registerFuel((IItemProvider)Blocks.field_150402_ci, 12000);
        EndStoneSmelterTileEntity.registerFuel((IItemProvider)Items.field_151072_bj, 2000);
    }

    private boolean isBurning() {
        return this.burnTime > 0;
    }

    public void dropExperience(PlayerEntity player) {
        ArrayList list = Lists.newArrayList();
        for (Object2IntMap.Entry entry : this.recipesUsed.object2IntEntrySet()) {
            this.field_145850_b.func_199532_z().func_215367_a((ResourceLocation)entry.getKey()).ifPresent(recipe -> {
                list.add(recipe);
                if (recipe instanceof AlloyingRecipe) {
                    AlloyingRecipe alloying = (AlloyingRecipe)recipe;
                    this.dropExperience(player.field_70170_p, player.func_213303_ch(), entry.getIntValue(), alloying.getExperience());
                } else {
                    BlastingRecipe blasting = (BlastingRecipe)recipe;
                    this.dropExperience(player.field_70170_p, player.func_213303_ch(), entry.getIntValue(), blasting.func_222138_b());
                }
            });
        }
        player.func_195065_a((Collection)list);
        this.recipesUsed.clear();
    }

    private void dropExperience(World world, Vector3d vec3d, int i, float f) {
        int j = MathHelper.func_76141_d((float)((float)i * f));
        float g = MathHelper.func_226164_h_((float)((float)i * f));
        if (g != 0.0f && Math.random() < (double)g) {
            ++j;
        }
        while (j > 0) {
            int k = ExperienceOrbEntity.func_70527_a((int)j);
            j -= k;
            world.func_217376_c((Entity)new ExperienceOrbEntity(world, vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, k));
        }
    }

    public void func_73660_a() {
        boolean initialBurning = this.isBurning();
        if (initialBurning) {
            --this.burnTime;
        }
        boolean burning = this.isBurning();
        if (!this.field_145850_b.field_72995_K) {
            ItemStack fuel = (ItemStack)this.items.get(2);
            if (!burning && (fuel.func_190926_b() || ((ItemStack)this.items.get(0)).func_190926_b() && ((ItemStack)this.items.get(1)).func_190926_b())) {
                if (!burning && this.smeltTime > 0) {
                    this.smeltTime = MathHelper.func_76125_a((int)(this.smeltTime - 2), (int)0, (int)this.smeltTimeTotal);
                }
            } else {
                IRecipe recipe = this.field_145850_b.func_199532_z().func_215371_a(AlloyingRecipe.TYPE, (IInventory)this, this.field_145850_b).orElse(null);
                if (recipe == null) {
                    recipe = this.field_145850_b.func_199532_z().func_215371_a(IRecipeType.field_222151_c, (IInventory)this, this.field_145850_b).orElse(null);
                }
                boolean accepted = this.canAcceptRecipeOutput(recipe);
                if (!burning && accepted) {
                    this.fuelTime = this.burnTime = this.getBurnTime(fuel);
                    burning = this.isBurning();
                    if (burning) {
                        if (!fuel.func_190926_b()) {
                            Item item = fuel.func_77973_b();
                            fuel.func_190918_g(1);
                            if (fuel.func_190926_b()) {
                                Item remainFuel = item.func_77668_q();
                                this.items.set(2, (Object)(remainFuel == null ? ItemStack.field_190927_a : new ItemStack((IItemProvider)remainFuel)));
                            }
                        }
                        this.func_70296_d();
                    }
                }
                if (burning && accepted) {
                    ++this.smeltTime;
                    if (this.smeltTime == this.smeltTimeTotal) {
                        this.smeltTime = 0;
                        this.smeltTimeTotal = this.getSmeltTime();
                        this.craftRecipe(recipe);
                        this.func_70296_d();
                    }
                } else {
                    this.smeltTime = 0;
                }
            }
            if (initialBurning != burning) {
                this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a((Property)EndStoneSmelter.LIT, (Comparable)Boolean.valueOf(burning)), 3);
                this.func_70296_d();
            }
        }
    }

    protected boolean canAcceptRecipeOutput(IRecipe<?> recipe) {
        if (recipe == null) {
            return false;
        }
        boolean validInput = false;
        if (recipe instanceof AlloyingRecipe) {
            validInput = !((ItemStack)this.items.get(0)).func_190926_b() && !((ItemStack)this.items.get(1)).func_190926_b();
        } else {
            boolean bl = validInput = !((ItemStack)this.items.get(0)).func_190926_b() || !((ItemStack)this.items.get(1)).func_190926_b();
        }
        if (validInput) {
            ItemStack result = recipe.func_77571_b();
            if (result.func_190926_b()) {
                return false;
            }
            ItemStack output = (ItemStack)this.items.get(3);
            int outCount = output.func_190916_E();
            int total = outCount + result.func_190916_E();
            if (output.func_190926_b()) {
                return true;
            }
            if (!output.func_185136_b(result)) {
                return false;
            }
            if (outCount < this.func_70297_j_() && outCount < output.func_77976_d()) {
                return this.func_70297_j_() >= total;
            }
            return output.func_190916_E() < result.func_77976_d();
        }
        return false;
    }

    private void craftRecipe(IRecipe<?> recipe) {
        if (recipe == null || !this.canAcceptRecipeOutput(recipe)) {
            return;
        }
        ItemStack result = recipe.func_77571_b();
        ItemStack output = (ItemStack)this.items.get(3);
        if (output.func_190926_b()) {
            this.items.set(3, (Object)result.func_77946_l());
        } else if (output.func_77973_b() == result.func_77973_b()) {
            output.func_190917_f(result.func_190916_E());
        }
        if (!this.field_145850_b.field_72995_K) {
            this.func_193056_a(recipe);
        }
        if (recipe instanceof AlloyingRecipe) {
            ((ItemStack)this.items.get(0)).func_190918_g(1);
            ((ItemStack)this.items.get(1)).func_190918_g(1);
        } else if (!((ItemStack)this.items.get(0)).func_190926_b()) {
            ((ItemStack)this.items.get(0)).func_190918_g(1);
        } else {
            ((ItemStack)this.items.get(1)).func_190918_g(1);
        }
    }

    public int func_70302_i_() {
        return this.items.size();
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.items) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.items.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.items, (int)index, (int)count);
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.items, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        ItemStack itemStack = (ItemStack)this.items.get(index);
        boolean stackValid = !stack.func_190926_b() && stack.func_185136_b(itemStack) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)itemStack);
        this.items.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        if (!(index != 0 && index != 1 || stackValid)) {
            this.smeltTimeTotal = this.getSmeltTime();
            this.smeltTime = 0;
            this.func_70296_d();
        }
    }

    protected int getSmeltTime() {
        int smeltTime = this.field_145850_b.func_199532_z().func_215371_a(AlloyingRecipe.TYPE, (IInventory)this, this.field_145850_b).map(AlloyingRecipe::getSmeltTime).orElse(0);
        if (smeltTime == 0) {
            smeltTime = this.field_145850_b.func_199532_z().func_215371_a(IRecipeType.field_222151_c, (IInventory)this, this.field_145850_b).map(AbstractCookingRecipe::func_222137_e).orElse(200);
            smeltTime = (int)((double)smeltTime / 1.5);
        }
        return smeltTime;
    }

    public int[] func_180463_a(Direction side) {
        if (side == Direction.DOWN) {
            return BOTTOM_SLOTS;
        }
        return side == Direction.UP ? TOP_SLOTS : SIDE_SLOTS;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, Direction direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return direction != Direction.DOWN || index != 2 || stack.func_77973_b() == Items.field_151133_ar || stack.func_77973_b() == Items.field_151131_as;
    }

    public boolean func_70300_a(PlayerEntity player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174888_l() {
        this.items.clear();
    }

    protected ITextComponent func_213907_g() {
        return new TranslationTextComponent("container.betterendforge.end_stone_smelter");
    }

    protected Container func_213906_a(int id, PlayerInventory player) {
        return new EndStoneSmelterContainer(id, player, (IInventory)this, this.data);
    }

    public void func_194018_a(RecipeItemHelper helper) {
        for (ItemStack itemstack : this.items) {
            helper.func_194112_a(itemstack);
        }
    }

    public void func_193056_a(IRecipe<?> recipe) {
        if (recipe != null) {
            ResourceLocation recipeId = recipe.func_199560_c();
            this.recipesUsed.addTo((Object)recipeId, 1);
            this.lastRecipe = recipe;
        }
    }

    public IRecipe<?> func_193055_i() {
        return this.lastRecipe;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (index == 3) {
            return false;
        }
        if (index != 2) {
            return true;
        }
        ItemStack itemStack = (ItemStack)this.items.get(2);
        return EndStoneSmelterTileEntity.isFuel(stack) || stack.func_77973_b() == Items.field_151133_ar && itemStack.func_77973_b() != Items.field_151133_ar;
    }

    public static boolean isFuel(ItemStack stack) {
        return AVAILABLE_FUELS.containsKey(stack.func_77973_b()) && ForgeHooks.getBurnTime((ItemStack)stack) > 0;
    }

    protected int getBurnTime(ItemStack fuel) {
        if (fuel.func_190926_b()) {
            return 0;
        }
        Item item = fuel.func_77973_b();
        return AVAILABLE_FUELS.getOrDefault(item, 0);
    }

    public static void registerFuel(IItemProvider fuel, int time) {
        if (AVAILABLE_FUELS.containsKey(fuel)) {
            AVAILABLE_FUELS.replace(fuel.func_199767_j(), time);
        } else {
            AVAILABLE_FUELS.put(fuel.func_199767_j(), time);
        }
    }

    public static void registerFuel(ITag<Item> tag, int time) {
        Iterator<Item> tagItems = tag.func_230236_b_().iterator();
        tagItems.forEachRemaining(item -> EndStoneSmelterTileEntity.registerFuel((IItemProvider)item, time));
    }

    public static Map<Item, Integer> getAvailableFuels() {
        return AVAILABLE_FUELS;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (!this.field_145846_f && facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == Direction.UP) {
                return this.handlers[0].cast();
            }
            if (facing == Direction.DOWN) {
                return this.handlers[1].cast();
            }
            return this.handlers[2].cast();
        }
        return super.getCapability(capability, facing);
    }

    protected void invalidateCaps() {
        super.invalidateCaps();
        for (int x = 0; x < this.handlers.length; ++x) {
            this.handlers[x].invalidate();
        }
    }
}

