/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.world.feature;

import java.util.Random;
import java.util.function.Function;
import mod.beethoven92.betterendforge.common.init.ModTags;
import mod.beethoven92.betterendforge.common.util.BlockHelper;
import mod.beethoven92.betterendforge.common.util.ModMathHelper;
import mod.beethoven92.betterendforge.common.util.sdf.SDF;
import mod.beethoven92.betterendforge.common.util.sdf.operator.SDFDisplacement;
import mod.beethoven92.betterendforge.common.util.sdf.operator.SDFScale3D;
import mod.beethoven92.betterendforge.common.util.sdf.operator.SDFSubtraction;
import mod.beethoven92.betterendforge.common.util.sdf.operator.SDFTranslate;
import mod.beethoven92.betterendforge.common.util.sdf.primitive.SDFSphere;
import mod.beethoven92.betterendforge.common.world.generator.OpenSimplexNoise;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.material.Material;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class BushWithOuterFeature
extends Feature<NoFeatureConfig> {
    private static final Direction[] DIRECTIONS = Direction.values();
    private static final Function<BlockState, Boolean> REPLACE = state -> {
        if (state.func_185904_a().equals(Material.field_151585_k)) {
            return true;
        }
        return state.func_185904_a().func_76222_j();
    };
    private final Block outer_leaves;
    private final Block leaves;
    private final Block stem;

    public BushWithOuterFeature(Block leaves, Block outer_leaves, Block stem) {
        super(NoFeatureConfig.field_236558_a_);
        this.outer_leaves = outer_leaves;
        this.leaves = leaves;
        this.stem = stem;
    }

    public boolean generate(ISeedReader world, ChunkGenerator chunkGenerator_, Random random, BlockPos pos, NoFeatureConfig config) {
        if (!world.func_180495_p(pos.func_177977_b()).func_177230_c().func_203417_a(ModTags.END_GROUND) && !world.func_180495_p(pos.func_177984_a()).func_177230_c().func_203417_a(ModTags.END_GROUND)) {
            return false;
        }
        float radius = ModMathHelper.randRange(1.8f, 3.5f, random);
        OpenSimplexNoise noise = new OpenSimplexNoise(random.nextInt());
        SDF sphere = new SDFSphere().setRadius(radius).setBlock(this.leaves);
        sphere = new SDFScale3D().setScale(1.0f, 0.5f, 1.0f).setSource(sphere);
        sphere = new SDFDisplacement().setFunction(vec -> Float.valueOf((float)noise.eval((double)vec.func_195899_a() * 0.2, (double)vec.func_195900_b() * 0.2, (double)vec.func_195902_c() * 0.2) * 3.0f)).setSource(sphere);
        sphere = new SDFDisplacement().setFunction(vec -> Float.valueOf(ModMathHelper.randRange(-2.0f, 2.0f, random))).setSource(sphere);
        sphere = new SDFSubtraction().setSourceA(sphere).setSourceB(new SDFTranslate().setTranslate(0.0f, -radius, 0.0f).setSource(sphere));
        sphere.setReplaceFunction(REPLACE);
        sphere.addPostProcess(info -> {
            if (info.getState().func_177230_c() instanceof LeavesBlock) {
                int distance = info.getPos().func_218139_n((Vector3i)pos);
                if (distance < 7) {
                    return (BlockState)info.getState().func_206870_a((Property)LeavesBlock.field_208494_a, (Comparable)Integer.valueOf(distance));
                }
                return Blocks.field_150350_a.func_176223_P();
            }
            return info.getState();
        }).addPostProcess(info -> {
            if (info.getState().func_177230_c() instanceof LeavesBlock) {
                ModMathHelper.shuffle(DIRECTIONS, random);
                for (Direction dir : DIRECTIONS) {
                    if (!info.getState(dir).func_196958_f()) continue;
                    info.setBlockPos(info.getPos().func_177972_a(dir), (BlockState)this.outer_leaves.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208155_H, (Comparable)dir));
                }
            }
            return info.getState();
        });
        sphere.fillRecursive((IWorld)world, pos);
        BlockHelper.setWithoutUpdate((IWorldWriter)world, pos, this.stem);
        for (Direction d : Direction.values()) {
            BlockPos p = pos.func_177972_a(d);
            if (!world.func_175623_d(p)) continue;
            if (this.leaves instanceof LeavesBlock) {
                BlockHelper.setWithoutUpdate((IWorldWriter)world, p, (BlockState)this.leaves.func_176223_P().func_206870_a((Property)LeavesBlock.field_208494_a, (Comparable)Integer.valueOf(1)));
                continue;
            }
            BlockHelper.setWithoutUpdate((IWorldWriter)world, p, this.leaves.func_176223_P());
        }
        return true;
    }
}

