/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.world.feature;

import java.util.Random;
import mod.beethoven92.betterendforge.common.init.ModBlocks;
import mod.beethoven92.betterendforge.common.init.ModTags;
import mod.beethoven92.betterendforge.common.util.ModMathHelper;
import mod.beethoven92.betterendforge.common.util.sdf.SDF;
import mod.beethoven92.betterendforge.common.util.sdf.operator.SDFDisplacement;
import mod.beethoven92.betterendforge.common.util.sdf.operator.SDFScale3D;
import mod.beethoven92.betterendforge.common.util.sdf.primitive.SDFSphere;
import mod.beethoven92.betterendforge.common.world.generator.OpenSimplexNoise;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class ObsidianBoulderFeature
extends Feature<NoFeatureConfig> {
    public ObsidianBoulderFeature() {
        super(NoFeatureConfig.field_236558_a_);
    }

    public boolean generate(ISeedReader world, ChunkGenerator chunkGenerator, Random random, BlockPos pos, NoFeatureConfig config) {
        if (!world.func_180495_p((pos = world.func_205770_a(Heightmap.Type.WORLD_SURFACE, new BlockPos(pos.func_177958_n() + random.nextInt(16), pos.func_177956_o(), pos.func_177952_p() + random.nextInt(16)))).func_177977_b()).func_235714_a_(ModTags.END_GROUND)) {
            return false;
        }
        int count = ModMathHelper.randRange(1, 5, random);
        for (int i = 0; i < count; ++i) {
            BlockPos p = world.func_205770_a(Heightmap.Type.WORLD_SURFACE, new BlockPos(pos.func_177958_n() + random.nextInt(16) - 8, pos.func_177956_o(), pos.func_177952_p() + random.nextInt(16) - 8));
            this.makeBoulder(world, p, random);
        }
        return true;
    }

    private void makeBoulder(ISeedReader world, BlockPos pos, Random random) {
        if (!world.func_180495_p(pos.func_177977_b()).func_235714_a_(ModTags.END_GROUND)) {
            return;
        }
        float radius = ModMathHelper.randRange(1.0f, 5.0f, random);
        SDF sphere = new SDFSphere().setRadius(radius).setBlock(Blocks.field_150343_Z);
        float sx = ModMathHelper.randRange(0.7f, 1.3f, random);
        float sy = ModMathHelper.randRange(0.7f, 1.3f, random);
        float sz = ModMathHelper.randRange(0.7f, 1.3f, random);
        sphere = new SDFScale3D().setScale(sx, sy, sz).setSource(sphere);
        OpenSimplexNoise noise = new OpenSimplexNoise(random.nextLong());
        sphere = new SDFDisplacement().setFunction(vec -> Float.valueOf((float)(noise.eval((double)vec.func_195899_a() * 0.2, (double)vec.func_195900_b() * 0.2, (double)vec.func_195902_c() * 0.2) * 1.5))).setSource(sphere);
        BlockState mossy = ((Block)ModBlocks.MOSSY_OBSIDIAN.get()).func_176223_P();
        sphere.addPostProcess(info -> {
            if (info.getStateUp().func_196958_f() && random.nextFloat() > 0.1f) {
                return mossy;
            }
            return info.getState();
        }).setReplaceFunction(state -> state.func_185904_a().func_76222_j() || state.func_235714_a_(ModTags.GEN_TERRAIN) || state.func_185904_a().equals(Material.field_151585_k)).fillRecursive((IWorld)world, pos);
    }
}

