/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.world.structure.piece;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Random;
import mod.beethoven92.betterendforge.common.init.ModBiomes;
import mod.beethoven92.betterendforge.common.init.ModBlocks;
import mod.beethoven92.betterendforge.common.init.ModStructurePieces;
import mod.beethoven92.betterendforge.common.init.ModTags;
import mod.beethoven92.betterendforge.common.util.ModMathHelper;
import mod.beethoven92.betterendforge.common.world.generator.OpenSimplexNoise;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class MountainPiece
extends StructurePiece {
    private Map<Integer, Integer> heightmap = Maps.newHashMap();
    private BlockPos center;
    private float radius;
    private float height;
    private float r2;
    private OpenSimplexNoise noise1;
    private OpenSimplexNoise noise2;
    private BlockState top;
    private int seed1;
    private int seed2;
    private ResourceLocation biomeID;

    public MountainPiece(BlockPos center, float radius, float height, Random rand, Biome biome) {
        super(ModStructurePieces.MOUNTAIN_PIECE, rand.nextInt());
        this.center = center;
        this.radius = radius;
        this.height = height;
        this.r2 = radius * radius;
        this.seed1 = rand.nextInt();
        this.seed2 = rand.nextInt();
        this.noise1 = new OpenSimplexNoise(this.seed1);
        this.noise2 = new OpenSimplexNoise(this.seed2);
        this.top = biome.func_242440_e().func_242502_e().func_204108_a();
        this.biomeID = ModBiomes.getBiomeID(biome);
        this.makeBoundingBox();
    }

    public MountainPiece(TemplateManager p_i50677_1_, CompoundNBT nbt) {
        super(ModStructurePieces.MOUNTAIN_PIECE, nbt);
        this.center = new BlockPos(nbt.func_74762_e("centerX"), nbt.func_74762_e("centerY"), nbt.func_74762_e("centerZ"));
        this.radius = nbt.func_74760_g("radius");
        this.height = nbt.func_74760_g("height");
        this.biomeID = new ResourceLocation(nbt.func_74779_i("biomeid"));
        this.r2 = this.radius * this.radius;
        this.seed1 = nbt.func_74762_e("seed1");
        this.seed2 = nbt.func_74762_e("seed2");
        this.noise1 = new OpenSimplexNoise(this.seed1);
        this.noise2 = new OpenSimplexNoise(this.seed2);
        this.top = ModBiomes.getBiome(this.biomeID).getBiome().func_242440_e().func_242502_e().func_204108_a();
        this.makeBoundingBox();
    }

    protected void func_143011_b(CompoundNBT tagCompound) {
        tagCompound.func_74768_a("centerX", this.center.func_177958_n());
        tagCompound.func_74768_a("centerY", this.center.func_177956_o());
        tagCompound.func_74768_a("centerZ", this.center.func_177952_p());
        tagCompound.func_74776_a("radius", this.radius);
        tagCompound.func_74776_a("height", this.height);
        tagCompound.func_74768_a("seed1", this.seed1);
        tagCompound.func_74768_a("seed2", this.seed2);
        tagCompound.func_74778_a("biomeid", this.biomeID.toString());
    }

    private void makeBoundingBox() {
        int minX = MathHelper.func_76141_d((float)((float)this.center.func_177958_n() - this.radius));
        int minZ = MathHelper.func_76141_d((float)((float)this.center.func_177952_p() - this.radius));
        int maxX = MathHelper.func_76141_d((float)((float)this.center.func_177958_n() + this.radius + 1.0f));
        int maxZ = MathHelper.func_76141_d((float)((float)this.center.func_177952_p() + this.radius + 1.0f));
        this.field_74887_e = new MutableBoundingBox(minX, minZ, maxX, maxZ);
    }

    public boolean func_230383_a_(ISeedReader world, StructureManager manager, ChunkGenerator chunkGenerator, Random random, MutableBoundingBox box, ChunkPos chunkPos, BlockPos blockPos) {
        int height;
        int z;
        int x;
        int radius;
        int i;
        int sx = chunkPos.func_180334_c();
        int sz = chunkPos.func_180333_d();
        BlockPos.Mutable pos = new BlockPos.Mutable();
        IChunk chunk = world.func_212866_a_(chunkPos.field_77276_a, chunkPos.field_77275_b);
        Heightmap map = chunk.func_217303_b(Heightmap.Type.WORLD_SURFACE);
        Heightmap map2 = chunk.func_217303_b(Heightmap.Type.WORLD_SURFACE_WG);
        for (int x2 = 0; x2 < 16; ++x2) {
            int px = x2 + sx;
            int px2 = px - this.center.func_177958_n();
            px2 *= px2;
            pos.func_223471_o(x2);
            for (int z2 = 0; z2 < 16; ++z2) {
                float maxY;
                float dist;
                int pz = z2 + sz;
                int pz2 = pz - this.center.func_177952_p();
                if (!((dist = (float)(px2 + (pz2 *= pz2))) < this.r2)) continue;
                pos.func_223472_q(z2);
                dist = 1.0f - (float)Math.pow(dist / this.r2, 0.3);
                int minY = map.func_202273_a(x2, z2);
                if (minY < 10) continue;
                pos.func_185336_p(minY);
                while (!chunk.func_180495_p((BlockPos)pos).func_235714_a_(ModTags.GEN_TERRAIN) && pos.func_177956_o() > 56 && !chunk.func_180495_p(pos.func_177977_b()).func_203425_a(Blocks.field_201941_jj)) {
                    pos.func_185336_p(pos.func_177956_o() - 1);
                }
                minY = pos.func_177956_o();
                if ((minY = Math.max(minY, map2.func_202273_a(x2, z2))) <= this.center.func_177956_o() - 8 || !((maxY = dist * this.height * this.getHeightClamp(world, 12, px, pz)) > 0.0f)) continue;
                maxY *= (float)this.noise1.eval((double)px * 0.05, (double)pz * 0.05) * 0.3f + 0.7f;
                maxY *= (float)this.noise1.eval((double)px * 0.1, (double)pz * 0.1) * 0.1f + 0.8f;
                int maxYI = (int)(maxY += (float)this.center.func_177956_o());
                int cover = maxYI - 1;
                boolean needCover = this.noise1.eval((double)px * 0.1, (double)pz * 0.1) + ModMathHelper.randRange(-0.4, 0.4, random) - (double)(this.center.func_177956_o() + 14) * 0.1 > 0.0;
                for (int y = minY - 1; y < maxYI; ++y) {
                    pos.func_185336_p(y);
                    chunk.func_177436_a((BlockPos)pos, needCover && y == cover ? this.top : Blocks.field_150377_bs.func_176223_P(), false);
                }
            }
        }
        map = chunk.func_217303_b(Heightmap.Type.WORLD_SURFACE);
        int count = (map.func_202273_a(8, 8) - (this.center.func_177956_o() + 24)) / 7;
        count = MathHelper.func_76125_a((int)count, (int)0, (int)8);
        for (i = 0; i < count; ++i) {
            radius = MathHelper.func_76136_a((Random)random, (int)2, (int)3);
            float fill = MathHelper.func_151240_a((Random)random, (float)0.0f, (float)1.0f);
            x = MathHelper.func_76136_a((Random)random, (int)radius, (int)(15 - radius));
            int y = map.func_202273_a(x, z = MathHelper.func_76136_a((Random)random, (int)radius, (int)(15 - radius)));
            if (y <= 80) continue;
            pos.func_181079_c(x, y, z);
            if (chunk.func_180495_p(pos.func_177977_b()).func_177230_c() != Blocks.field_150377_bs) continue;
            height = MathHelper.func_76141_d((float)((float)radius * MathHelper.func_151240_a((Random)random, (float)1.5f, (float)3.0f) + (float)(y - 80) * 0.3f));
            this.crystal(chunk, (BlockPos)pos, radius, height, fill, random);
        }
        count = (map.func_202273_a(8, 8) - (this.center.func_177956_o() + 24)) / 2;
        count = MathHelper.func_76125_a((int)count, (int)4, (int)8);
        for (i = 0; i < count; ++i) {
            radius = MathHelper.func_76136_a((Random)random, (int)1, (int)2);
            float fill = random.nextBoolean() ? 0.0f : 1.0f;
            x = MathHelper.func_76136_a((Random)random, (int)radius, (int)(15 - radius));
            int y = map.func_202273_a(x, z = MathHelper.func_76136_a((Random)random, (int)radius, (int)(15 - radius)));
            if (y <= 80) continue;
            pos.func_181079_c(x, y, z);
            if (chunk.func_180495_p(pos.func_177977_b()).func_177230_c() != Blocks.field_150377_bs) continue;
            height = MathHelper.func_76141_d((float)((float)radius * MathHelper.func_151240_a((Random)random, (float)1.5f, (float)3.0f) + (float)(y - 80) * 0.3f));
            this.crystal(chunk, (BlockPos)pos, radius, height, fill, random);
        }
        return true;
    }

    private int getHeight(ISeedReader world, BlockPos pos) {
        int p = (pos.func_177958_n() & 0x7FF) << 11 | pos.func_177952_p() & 0x7FF;
        int h = this.heightmap.getOrDefault(p, Integer.MIN_VALUE);
        if (h > Integer.MIN_VALUE) {
            return h;
        }
        if (!ModBiomes.getBiomeID(world.func_226691_t_(pos)).equals((Object)this.biomeID)) {
            this.heightmap.put(p, -10);
            return -10;
        }
        h = world.func_201676_a(Heightmap.Type.WORLD_SURFACE_WG, pos.func_177958_n(), pos.func_177952_p());
        if ((h = MathHelper.func_76130_a((int)(h - this.center.func_177956_o()))) > 4) {
            h = 4 - h;
            this.heightmap.put(p, h);
            return h;
        }
        h = MathHelper.func_76128_c((double)(this.noise2.eval((double)pos.func_177958_n() * 0.01, (double)pos.func_177952_p() * 0.01) * this.noise2.eval((double)pos.func_177958_n() * 0.002, (double)pos.func_177952_p() * 0.002) * 8.0 + 8.0));
        if (h < 0) {
            this.heightmap.put(p, 0);
            return 0;
        }
        this.heightmap.put(p, h);
        return h;
    }

    private float getHeightClamp(ISeedReader world, int radius, int posX, int posZ) {
        BlockPos.Mutable mut = new BlockPos.Mutable();
        int r2 = radius * radius;
        float height = 0.0f;
        float max = 0.0f;
        for (int x = -radius; x <= radius; ++x) {
            mut.func_223471_o(posX + x);
            int x2 = x * x;
            for (int z = -radius; z <= radius; ++z) {
                mut.func_223472_q(posZ + z);
                int z2 = z * z;
                if (x2 + z2 >= r2) continue;
                float mult = 1.0f - (float)Math.sqrt(x2 + z2) / (float)radius;
                max += mult;
                height += (float)this.getHeight(world, (BlockPos)mut) * mult;
            }
        }
        return MathHelper.func_76131_a((float)((height /= max) / (float)radius), (float)0.0f, (float)1.0f);
    }

    private void crystal(IChunk chunk, BlockPos pos, int radius, int height, float fill, Random random) {
        BlockPos.Mutable mut = new BlockPos.Mutable();
        int max = MathHelper.func_76141_d((float)(fill * (float)radius + (float)radius + 0.5f));
        height += pos.func_177956_o();
        Heightmap map = chunk.func_217303_b(Heightmap.Type.WORLD_SURFACE);
        int coefX = MathHelper.func_76136_a((Random)random, (int)-1, (int)1);
        int coefZ = MathHelper.func_76136_a((Random)random, (int)-1, (int)1);
        for (int x = -radius; x <= radius; ++x) {
            mut.func_223471_o(x + pos.func_177958_n());
            if (mut.func_177958_n() < 0 || mut.func_177958_n() >= 16) continue;
            int ax = Math.abs(x);
            for (int z = -radius; z <= radius; ++z) {
                int az;
                mut.func_223472_q(z + pos.func_177952_p());
                if (mut.func_177952_p() < 0 || mut.func_177952_p() >= 16 || ax + (az = Math.abs(z)) >= max) continue;
                int minY = map.func_202273_a(mut.func_177958_n(), mut.func_177952_p()) - MathHelper.func_76136_a((Random)random, (int)3, (int)7);
                if (pos.func_177956_o() - minY > 8) {
                    minY = pos.func_177956_o() - 8;
                }
                int h = coefX * x + coefZ * z + height;
                for (int y = minY; y < h; ++y) {
                    mut.func_185336_p(y);
                    chunk.func_177436_a((BlockPos)mut, ((Block)ModBlocks.AURORA_CRYSTAL.get()).func_176223_P(), false);
                }
            }
        }
    }
}

