/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.world.structure.piece;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Random;
import mod.beethoven92.betterendforge.common.init.ModBiomes;
import mod.beethoven92.betterendforge.common.init.ModStructurePieces;
import mod.beethoven92.betterendforge.common.util.ModMathHelper;
import mod.beethoven92.betterendforge.common.world.generator.OpenSimplexNoise;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class PaintedMountainPiece
extends StructurePiece {
    private Map<Integer, Integer> heightmap = Maps.newHashMap();
    private OpenSimplexNoise noise1;
    private OpenSimplexNoise noise2;
    private BlockPos center;
    private float radius;
    private float height;
    private float r2;
    private ResourceLocation biomeID;
    private BlockState[] slises;
    private int seed1;
    private int seed2;

    public PaintedMountainPiece(BlockPos center, float radius, float height, Random random, Biome biome, BlockState[] slises) {
        super(ModStructurePieces.PAINTED_MOUNTAIN_PIECE, random.nextInt());
        this.center = center;
        this.radius = radius;
        this.height = height;
        this.r2 = radius * radius;
        this.seed1 = random.nextInt();
        this.seed2 = random.nextInt();
        this.noise1 = new OpenSimplexNoise(this.seed1);
        this.noise2 = new OpenSimplexNoise(this.seed2);
        this.biomeID = ModBiomes.getBiomeID(biome);
        this.slises = slises;
        this.makeBoundingBox();
    }

    public PaintedMountainPiece(TemplateManager p_i50677_1_, CompoundNBT nbt) {
        super(ModStructurePieces.PAINTED_MOUNTAIN_PIECE, nbt);
        this.center = new BlockPos(nbt.func_74762_e("centerX"), nbt.func_74762_e("centerY"), nbt.func_74762_e("centerZ"));
        this.radius = nbt.func_74760_g("radius");
        this.height = nbt.func_74760_g("height");
        this.biomeID = new ResourceLocation(nbt.func_74779_i("biome"));
        this.r2 = this.radius * this.radius;
        this.seed1 = nbt.func_74762_e("seed1");
        this.seed2 = nbt.func_74762_e("seed2");
        this.noise1 = new OpenSimplexNoise(this.seed1);
        this.noise2 = new OpenSimplexNoise(this.seed2);
        ListNBT slise = nbt.func_150295_c("slises", 10);
        this.slises = new BlockState[slise.size()];
        for (int i = 0; i < this.slises.length; ++i) {
            this.slises[i] = NBTUtil.func_190008_d((CompoundNBT)slise.func_150305_b(i));
        }
        this.makeBoundingBox();
    }

    protected void func_143011_b(CompoundNBT tagCompound) {
        tagCompound.func_74768_a("centerX", this.center.func_177958_n());
        tagCompound.func_74768_a("centerY", this.center.func_177956_o());
        tagCompound.func_74768_a("centerZ", this.center.func_177952_p());
        tagCompound.func_74776_a("radius", this.radius);
        tagCompound.func_74776_a("height", this.height);
        tagCompound.func_74778_a("biome", this.biomeID.toString());
        tagCompound.func_74768_a("seed1", this.seed1);
        tagCompound.func_74768_a("seed2", this.seed2);
        ListNBT slise = new ListNBT();
        for (BlockState state : this.slises) {
            slise.add((Object)NBTUtil.func_190009_a((BlockState)state));
        }
        tagCompound.func_218657_a("slises", (INBT)slise);
    }

    private void makeBoundingBox() {
        int minX = ModMathHelper.floor((float)this.center.func_177958_n() - this.radius);
        int minZ = ModMathHelper.floor((float)this.center.func_177952_p() - this.radius);
        int maxX = ModMathHelper.floor((float)this.center.func_177958_n() + this.radius + 1.0f);
        int maxZ = ModMathHelper.floor((float)this.center.func_177952_p() + this.radius + 1.0f);
        this.field_74887_e = new MutableBoundingBox(minX, minZ, maxX, maxZ);
    }

    public boolean func_230383_a_(ISeedReader world, StructureManager manager, ChunkGenerator chunkGenerator, Random random, MutableBoundingBox box, ChunkPos chunkPos, BlockPos blockPos) {
        int sx = chunkPos.func_180334_c();
        int sz = chunkPos.func_180333_d();
        BlockPos.Mutable pos = new BlockPos.Mutable();
        IChunk chunk = world.func_212866_a_(chunkPos.field_77276_a, chunkPos.field_77275_b);
        Heightmap map = chunk.func_217303_b(Heightmap.Type.WORLD_SURFACE);
        Heightmap map2 = chunk.func_217303_b(Heightmap.Type.WORLD_SURFACE_WG);
        for (int x = 0; x < 16; ++x) {
            int px = x + sx;
            int px2 = px - this.center.func_177958_n();
            px2 *= px2;
            pos.func_223471_o(x);
            for (int z = 0; z < 16; ++z) {
                float maxY;
                float dist;
                int pz = z + sz;
                int pz2 = pz - this.center.func_177952_p();
                if (!((dist = (float)(px2 + (pz2 *= pz2))) < this.r2)) continue;
                pos.func_223472_q(z);
                dist = 1.0f - dist / this.r2;
                int minY = map.func_202273_a(x, z);
                pos.func_185336_p(minY - 1);
                while (chunk.func_180495_p((BlockPos)pos).func_196958_f() && pos.func_177956_o() > 50) {
                    pos.func_185336_p(minY--);
                }
                minY = pos.func_177956_o();
                if ((minY = Math.max(minY, map2.func_202273_a(x, z))) <= 56 || !((maxY = dist * this.height * this.getHeightClamp(world, 8, px, pz)) > 0.0f)) continue;
                maxY *= (float)this.noise1.eval((double)px * 0.05, (double)pz * 0.05) * 0.3f + 0.7f;
                maxY *= (float)this.noise1.eval((double)px * 0.1, (double)pz * 0.1) * 0.1f + 0.9f;
                maxY += 56.0f;
                float offset = (float)(this.noise1.eval((double)px * 0.07, (double)pz * 0.07) * 5.0 + this.noise1.eval((double)px * 0.2, (double)pz * 0.2) * 2.0 + 7.0);
                int y = minY - 1;
                while ((float)y < maxY) {
                    pos.func_185336_p(y);
                    int index = ModMathHelper.floor(((float)y + offset) * 0.65f) % this.slises.length;
                    chunk.func_177436_a((BlockPos)pos, this.slises[index], false);
                    ++y;
                }
            }
        }
        return true;
    }

    private int getHeight(ISeedReader world, BlockPos pos) {
        int p = (pos.func_177958_n() & 0x7FF) << 11 | pos.func_177952_p() & 0x7FF;
        int h = this.heightmap.getOrDefault(p, Integer.MIN_VALUE);
        if (h > Integer.MIN_VALUE) {
            return h;
        }
        if (!ModBiomes.getBiomeID(world.func_226691_t_(pos)).equals((Object)this.biomeID)) {
            this.heightmap.put(p, -4);
            return -4;
        }
        h = world.func_201676_a(Heightmap.Type.WORLD_SURFACE_WG, pos.func_177958_n(), pos.func_177952_p());
        if (h < 57) {
            this.heightmap.put(p, -4);
            return -4;
        }
        h = ModMathHelper.floor(this.noise2.eval((double)pos.func_177958_n() * 0.005, (double)pos.func_177952_p() * 0.005) * this.noise2.eval((double)pos.func_177958_n() * 0.001, (double)pos.func_177952_p() * 0.001) * 8.0 + 8.0);
        if (h < 0) {
            this.heightmap.put(p, 0);
            return 0;
        }
        this.heightmap.put(p, h);
        return h;
    }

    private float getHeightClamp(ISeedReader world, int radius, int posX, int posZ) {
        BlockPos.Mutable mut = new BlockPos.Mutable();
        float height = 0.0f;
        float max = 0.0f;
        for (int x = -radius; x <= radius; ++x) {
            mut.func_223471_o(posX + x);
            int x2 = x * x;
            for (int z = -radius; z <= radius; ++z) {
                mut.func_223472_q(posZ + z);
                int z2 = z * z;
                float mult = 1.0f - (float)Math.sqrt(x2 + z2) / (float)radius;
                if (!(mult > 0.0f)) continue;
                max += mult;
                height += (float)this.getHeight(world, (BlockPos)mut) * mult;
            }
        }
        return MathHelper.func_76131_a((float)((height /= max) / (float)radius), (float)0.0f, (float)1.0f);
    }
}

