/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.mixin;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import mod.beethoven92.betterendforge.common.init.ModBiomes;
import mod.beethoven92.betterendforge.common.world.biome.BetterEndBiome;
import mod.beethoven92.betterendforge.common.world.generator.BiomeMap;
import mod.beethoven92.betterendforge.common.world.generator.OpenSimplexNoise;
import mod.beethoven92.betterendforge.common.world.generator.TerrainGenerator;
import mod.beethoven92.betterendforge.config.CommonConfig;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.biome.provider.EndBiomeProvider;
import net.minecraft.world.gen.SimplexNoiseGenerator;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EndBiomeProvider.class}, priority=100)
public abstract class EndBiomeProviderMixin
extends BiomeProvider {
    private static final OpenSimplexNoise SMALL_NOISE = new OpenSimplexNoise(8324L);
    private Biome centerBiome;
    private Biome barrens;
    private BiomeMap mapLand;
    private BiomeMap mapVoid;
    @Shadow
    @Final
    private Registry<Biome> field_242640_g;
    @Shadow
    @Final
    private SimplexNoiseGenerator field_201546_a;
    @Shadow
    @Final
    private long field_235315_h_;

    private EndBiomeProviderMixin(List<Biome> biomes) {
        super(biomes);
    }

    @Inject(at={@At(value="RETURN")}, method={"<init>"})
    private void be_init(Registry<Biome> lookupRegistry, long seed, CallbackInfo info) {
        if (CommonConfig.isVanillaEndIntegrationEnabled()) {
            this.field_226837_c_ = this.be_getBiomes(lookupRegistry);
            this.mapLand = new BiomeMap(seed, CommonConfig.biomeSizeLand(), ModBiomes.LAND_BIOMES);
            this.mapVoid = new BiomeMap(seed, CommonConfig.biomeSizeVoid(), ModBiomes.VOID_BIOMES);
            this.centerBiome = (Biome)lookupRegistry.func_243576_d(Biomes.field_76779_k);
            this.barrens = (Biome)lookupRegistry.func_243576_d(Biomes.field_201939_S);
            ModBiomes.mutateRegistry(lookupRegistry);
        }
    }

    private List<Biome> be_getBiomes(Registry<Biome> biomeRegistry) {
        ArrayList list = Lists.newArrayList();
        biomeRegistry.forEach(biome -> {
            if (ModBiomes.hasBiome(biomeRegistry.func_177774_c(biome))) {
                list.add(biome);
            }
        });
        return list;
    }

    @Inject(at={@At(value="HEAD")}, method={"getNoiseBiome(III)Lnet/minecraft/world/biome/Biome;"}, cancellable=true)
    private void be_getNoiseBiome(int x, int y, int z, CallbackInfoReturnable<Biome> info) {
        if (CommonConfig.isVanillaEndIntegrationEnabled()) {
            boolean hasVoid = !CommonConfig.isNewGeneratorEnabled() || !CommonConfig.noRingVoid();
            long i = (long)x * (long)x;
            long j = (long)z * (long)z;
            if (hasVoid && i + j <= 65536L) {
                info.setReturnValue((Object)this.centerBiome);
                info.cancel();
                return;
            }
            if (x == 0 && z == 0) {
                this.mapLand.clearCache();
                this.mapVoid.clearCache();
            }
            if (CommonConfig.isNewGeneratorEnabled()) {
                if (TerrainGenerator.isLand(x, z)) {
                    info.setReturnValue((Object)this.mapLand.getBiome(x << 2, z << 2).getActualBiome());
                    info.cancel();
                    return;
                }
                info.setReturnValue((Object)this.mapVoid.getBiome(x << 2, z << 2).getActualBiome());
                info.cancel();
                return;
            }
            float height = EndBiomeProvider.func_235317_a_((SimplexNoiseGenerator)this.field_201546_a, (int)((x >> 1) + 1), (int)((z >> 1) + 1)) + (float)SMALL_NOISE.eval(x, z) * 5.0f;
            if (height > -20.0f && height < -5.0f) {
                info.setReturnValue((Object)this.barrens);
                info.cancel();
                return;
            }
            BetterEndBiome endBiome = height < -10.0f ? this.mapVoid.getBiome(x << 2, z << 2) : this.mapLand.getBiome(x << 2, z << 2);
            info.setReturnValue((Object)endBiome.getActualBiome());
            info.cancel();
            return;
        }
    }

    @Inject(method={"getBiomeProvider"}, at={@At(value="HEAD")}, cancellable=true)
    private void be_getBiomeProvider(long seed, CallbackInfoReturnable<BiomeProvider> info) {
        if (CommonConfig.isVanillaEndIntegrationEnabled()) {
            info.setReturnValue((Object)new EndBiomeProvider(this.field_242640_g, seed));
            info.cancel();
        }
    }
}

