/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.mixin;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import mod.beethoven92.betterendforge.common.block.template.EndAnvilBlock;
import mod.beethoven92.betterendforge.common.interfaces.ExtendedRepairContainer;
import mod.beethoven92.betterendforge.common.recipes.AnvilSmithingRecipe;
import net.minecraft.block.AnvilBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.AbstractRepairContainer;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.RepairContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.IntReferenceHolder;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={RepairContainer.class})
public abstract class RepairContainerMixin
extends AbstractRepairContainer
implements ExtendedRepairContainer {
    private final World world;
    private final RecipeManager recipeManager;
    private List<AnvilSmithingRecipe> be_recipes;
    private AnvilSmithingRecipe be_currentRecipe;
    private IntReferenceHolder anvilLevel;

    public RepairContainerMixin(ContainerType<?> p_i231587_1_, int p_i231587_2_, PlayerInventory p_i231587_3_, IWorldPosCallable p_i231587_4_) {
        super(p_i231587_1_, p_i231587_2_, p_i231587_3_, p_i231587_4_);
        this.world = this.field_234645_f_.field_70170_p;
        this.recipeManager = this.world.func_199532_z();
        this.be_recipes = Collections.emptyList();
    }

    @Inject(method={"<init>*"}, at={@At(value="TAIL")})
    public void be_initAnvilLevel(int id, PlayerInventory inventory, IWorldPosCallable worldPosCallable, CallbackInfo info) {
        int anvLevel = (Integer)worldPosCallable.func_221485_a((world, blockPos) -> {
            Block anvilBlock = world.func_180495_p(blockPos).func_177230_c();
            if (anvilBlock instanceof EndAnvilBlock) {
                return ((EndAnvilBlock)anvilBlock).getCraftingLevel();
            }
            return 1;
        }, (Object)1);
        IntReferenceHolder anvilLevel = IntReferenceHolder.func_221492_a();
        anvilLevel.func_221494_a(anvLevel);
        this.anvilLevel = this.func_216958_a(anvilLevel);
    }

    @Shadow
    public abstract void func_82848_d();

    @Inject(method={"func_230303_b_"}, at={@At(value="HEAD")}, cancellable=true)
    protected void be_canTakeOutput(PlayerEntity player, boolean present, CallbackInfoReturnable<Boolean> info) {
        if (this.be_currentRecipe != null) {
            info.setReturnValue((Object)this.be_currentRecipe.checkHammerDurability(this.field_234643_d_, player));
        }
    }

    @Inject(method={"func_230301_a_"}, at={@At(value="HEAD")}, cancellable=true)
    protected void be_onTakeOutput(PlayerEntity player, ItemStack stack, CallbackInfoReturnable<ItemStack> info) {
        if (this.be_currentRecipe != null) {
            this.field_234643_d_.func_70301_a(1).func_190918_g(this.be_currentRecipe.inputCount);
            stack = this.be_currentRecipe.craft(this.field_234643_d_, player);
            this.func_75130_a(this.field_234643_d_);
            this.field_234644_e_.func_221486_a((world, blockPos) -> {
                BlockState anvilState = world.func_180495_p(blockPos);
                if (!player.field_71075_bZ.field_75098_d && anvilState.func_235714_a_((ITag)BlockTags.field_200572_k) && player.func_70681_au().nextFloat() < 0.12f) {
                    BlockState landingState = AnvilBlock.func_196433_f((BlockState)anvilState);
                    if (landingState == null) {
                        world.func_217377_a(blockPos, false);
                        world.func_217379_c(1029, blockPos, 0);
                    } else {
                        world.func_180501_a(blockPos, landingState, 2);
                        world.func_217379_c(1030, blockPos, 0);
                    }
                } else {
                    world.func_217379_c(1030, blockPos, 0);
                }
            });
            info.setReturnValue((Object)stack);
        }
    }

    @Inject(method={"updateRepairOutput"}, at={@At(value="HEAD")}, cancellable=true)
    public void updateRepairOutput(CallbackInfo info) {
        this.be_recipes = this.recipeManager.func_215370_b(AnvilSmithingRecipe.TYPE, this.field_234643_d_, this.world);
        if (this.be_recipes.size() > 0) {
            int anvilLevel = this.anvilLevel.func_221495_b();
            this.be_recipes = this.be_recipes.stream().filter(recipe -> anvilLevel >= recipe.anvilLevel).collect(Collectors.toList());
            if (this.be_recipes.size() > 0) {
                if (this.be_currentRecipe == null || !this.be_recipes.contains(this.be_currentRecipe)) {
                    this.be_currentRecipe = this.be_recipes.get(0);
                }
                this.be_updateResult();
                info.cancel();
            } else {
                this.be_currentRecipe = null;
            }
        }
    }

    @Inject(method={"updateItemName"}, at={@At(value="HEAD")}, cancellable=true)
    public void updateItemName(String string, CallbackInfo info) {
        if (this.be_currentRecipe != null) {
            info.cancel();
        }
    }

    public boolean func_75140_a(PlayerEntity playerIn, int id) {
        if (id == 0) {
            this.be_previousRecipe();
            return true;
        }
        if (id == 1) {
            this.be_nextRecipe();
            return true;
        }
        return super.func_75140_a(playerIn, id);
    }

    private void be_updateResult() {
        if (this.be_currentRecipe == null) {
            return;
        }
        this.field_234642_c_.func_70299_a(0, this.be_currentRecipe.func_77572_b(this.field_234643_d_));
        this.func_75142_b();
    }

    @Override
    public void be_updateCurrentRecipe(AnvilSmithingRecipe recipe) {
        this.be_currentRecipe = recipe;
        this.be_updateResult();
    }

    @Override
    public AnvilSmithingRecipe be_getCurrentRecipe() {
        return this.be_currentRecipe;
    }

    @Override
    public List<AnvilSmithingRecipe> be_getRecipes() {
        return this.be_recipes;
    }
}

