/*
 * Decompiled with CFR 0.152.
 */
package io.socol.betterthirdperson;

import io.socol.betterthirdperson.AngleUtils;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.MovementInput;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.event.TickEvent;

public class CustomCamera {
    private float cameraYaw;
    private float playerYaw;
    private Vector3d lastTickPlayerPos;
    private float prevInputYaw = 0.0f;
    private float inputYaw = 0.0f;
    private boolean hasMovementInputs = false;
    private boolean canBeAttached = false;

    public CustomCamera(PlayerEntity player) {
        this.playerYaw = player.field_70177_z;
        this.cameraYaw = player.field_70177_z;
        this.lastTickPlayerPos = player.func_213303_ch();
    }

    public void handleInputs(MovementInput input) {
        this.prevInputYaw = this.inputYaw;
        if (input.field_187257_e || input.field_187258_f || input.field_187255_c || input.field_187256_d) {
            if (input.field_187255_c != input.field_187256_d) {
                float f = this.inputYaw = input.field_187255_c ? 0.0f : -180.0f;
                if (input.field_187257_e != input.field_187258_f) {
                    this.inputYaw += (input.field_187257_e ? -45.0f : 45.0f) * (float)(input.field_187255_c ? 1 : -1);
                }
            } else if (input.field_187257_e != input.field_187258_f) {
                this.inputYaw = input.field_187257_e ? -90.0f : 90.0f;
            }
            input.field_192832_b = Math.max(Math.abs(input.field_192832_b), Math.abs(input.field_78902_a));
            input.field_78902_a = 0.0f;
            input.field_187257_e = false;
            input.field_187258_f = false;
            input.field_187256_d = false;
            input.field_187255_c = true;
            this.hasMovementInputs = true;
        } else {
            this.hasMovementInputs = false;
        }
    }

    public void setup(PlayerEntity player, float partialTicks) {
        if (this.playerYaw != player.field_70177_z) {
            this.cameraYaw += player.field_70177_z - this.playerYaw;
        }
        if (this.hasMovementInputs) {
            this.playerYaw = this.cameraYaw + AngleUtils.smoothAngle(partialTicks, this.prevInputYaw, this.inputYaw);
        }
        player.field_70177_z = this.playerYaw;
    }

    public void tryAttach(PlayerEntity player) {
        if (this.canBeAttached) {
            player.field_70177_z += this.cameraYaw - this.playerYaw;
            player.field_70126_B += this.cameraYaw - this.playerYaw;
            this.canBeAttached = false;
        }
    }

    public void detach(PlayerEntity player) {
        player.field_70177_z -= this.cameraYaw - this.playerYaw;
        player.field_70126_B -= this.cameraYaw - this.playerYaw;
    }

    public void checkPosition(TickEvent.Phase phase, ClientPlayerEntity player) {
        Vector3d currentPos = player.func_213303_ch();
        if (phase == TickEvent.Phase.START) {
            if (!this.lastTickPlayerPos.equals((Object)currentPos)) {
                this.resetToPlayerView(player);
            }
        } else {
            this.lastTickPlayerPos = currentPos;
        }
    }

    public void reset() {
        this.canBeAttached = true;
    }

    public void resetToPlayerView(ClientPlayerEntity player) {
        this.playerYaw = player.field_70177_z;
        this.cameraYaw = player.field_70177_z;
    }
}

