/*
 * Decompiled with CFR 0.152.
 */
package io.socol.betterthirdperson;

import io.socol.betterthirdperson.CustomCamera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.settings.PointOfView;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.MovementInput;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.InputUpdateEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class CustomCameraManager {
    private CustomCamera customCamera;

    public CustomCameraManager() {
        MinecraftForge.EVENT_BUS.register((Object)new Listener());
    }

    public CustomCamera getCustomCamera() {
        return this.customCamera;
    }

    public boolean hasCustomCamera() {
        return this.customCamera != null;
    }

    private boolean mustHaveCustomCamera(PlayerEntity player) {
        boolean customCameraInitialized;
        PointOfView pointOfView = Minecraft.func_71410_x().field_71474_y.func_243230_g();
        boolean mustHaveCustomCamera = !pointOfView.func_243192_a() && !pointOfView.func_243193_b() && !player.func_184218_aH();
        boolean bl = customCameraInitialized = this.customCamera != null;
        if (mustHaveCustomCamera != customCameraInitialized) {
            this.customCamera = mustHaveCustomCamera ? new CustomCamera(player) : null;
        }
        return mustHaveCustomCamera;
    }

    private class Listener {
        private Listener() {
        }

        @SubscribeEvent
        public void onPlayerTick(TickEvent.PlayerTickEvent event) {
            if (CustomCameraManager.this.hasCustomCamera() && event.player instanceof ClientPlayerEntity) {
                CustomCameraManager.this.customCamera.checkPosition(event.phase, (ClientPlayerEntity)event.player);
            }
        }

        @SubscribeEvent
        public void onInputs(InputUpdateEvent event) {
            if (!CustomCameraManager.this.mustHaveCustomCamera(event.getPlayer())) {
                return;
            }
            MovementInput input = event.getMovementInput();
            CustomCameraManager.this.customCamera.handleInputs(input);
        }

        @SubscribeEvent
        public void onFOVModified(EntityViewRenderEvent.FOVModifier event) {
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            if (player == null || !CustomCameraManager.this.mustHaveCustomCamera((PlayerEntity)player)) {
                return;
            }
            CustomCameraManager.this.customCamera.tryAttach((PlayerEntity)player);
        }

        @SubscribeEvent
        public void onCameraSetup(EntityViewRenderEvent.CameraSetup event) {
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            if (player == null || !CustomCameraManager.this.mustHaveCustomCamera((PlayerEntity)player)) {
                return;
            }
            CustomCameraManager.this.customCamera.detach((PlayerEntity)player);
        }

        @SubscribeEvent
        public void onRender(TickEvent.RenderTickEvent event) {
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            if (player == null || !CustomCameraManager.this.mustHaveCustomCamera((PlayerEntity)player)) {
                return;
            }
            if (event.phase == TickEvent.Phase.START) {
                CustomCameraManager.this.customCamera.setup((PlayerEntity)player, event.renderTickTime);
            } else {
                CustomCameraManager.this.customCamera.reset();
            }
        }
    }
}

