/*
 * Decompiled with CFR 0.152.
 */
package io.socol.betterthirdperson.api;

import io.socol.betterthirdperson.api.CustomCamera;
import io.socol.betterthirdperson.api.DelayedActionManager;
import io.socol.betterthirdperson.api.TickPhase;
import io.socol.betterthirdperson.api.action.MouseAction;
import io.socol.betterthirdperson.api.adapter.IClientAdapter;
import io.socol.betterthirdperson.api.adapter.IMovementInputAdapter;
import io.socol.betterthirdperson.api.adapter.IPlayerAdapter;
import io.socol.betterthirdperson.api.config.CustomCameraConfig;
import io.socol.betterthirdperson.api.config.DefaultCustomCameraConfig;

public class CustomCameraManager {
    private final IClientAdapter client;
    private CustomCamera customCamera;
    private CustomCameraConfig config = DefaultCustomCameraConfig.INSTANCE;
    private final DelayedActionManager delayedActions = new DelayedActionManager();

    public CustomCameraManager(IClientAdapter client) {
        this.client = client;
    }

    public CustomCamera getCustomCamera() {
        return this.customCamera;
    }

    public boolean hasCustomCamera() {
        return this.customCamera != null;
    }

    public void setConfig(CustomCameraConfig config) {
        this.config = config;
    }

    private boolean mustHaveCustomCamera(IPlayerAdapter player) {
        boolean customCameraInitialized;
        boolean mustHaveCustomCamera = !this.client.isFirstPerson() && !this.client.isCameraMirrored() && !player.isPassenger();
        boolean bl = customCameraInitialized = this.customCamera != null;
        if (mustHaveCustomCamera != customCameraInitialized) {
            this.customCamera = mustHaveCustomCamera ? new CustomCamera(player, this.config) : null;
        }
        return mustHaveCustomCamera;
    }

    public void onPlayerTick(IPlayerAdapter player, TickPhase phase) {
        if (this.hasCustomCamera()) {
            this.customCamera.checkPosition(phase, player);
        }
    }

    public void onInputs(IPlayerAdapter player, IMovementInputAdapter inputs) {
        if (this.mustHaveCustomCamera(player)) {
            this.customCamera.handleInputs(inputs, this.client);
        }
    }

    public void onRenderTickStart(IPlayerAdapter player, float partialTicks) {
        if (!this.mustHaveCustomCamera(player)) {
            return;
        }
        this.customCamera.setup(player, partialTicks);
    }

    public boolean onMouseAction(IPlayerAdapter player, MouseAction action) {
        if (!this.delayedActions.isReplayingActions() && this.mustHaveCustomCamera(player)) {
            boolean delay = this.customCamera.handleMouseAction(player, this.client);
            if (delay) {
                this.delayedActions.writeAction(action);
            }
            return delay;
        }
        return false;
    }

    public void onMovementSend(IPlayerAdapter player) {
        this.delayedActions.replayActions();
        if (this.mustHaveCustomCamera(player)) {
            this.customCamera.onRotationSend();
        }
    }
}

