/*
 * Decompiled with CFR 0.152.
 */
package io.socol.betterthirdperson.integration.cloth;

import io.socol.betterthirdperson.api.config.CustomCameraConfig;
import io.socol.betterthirdperson.api.config.DefaultCustomCameraConfig;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.Comment;

@Config(name="betterthirdperson")
public class ClothModConfig
implements ConfigData,
CustomCameraConfig {
    @Comment(value="Align player to camera on left & right clicks (delayed by Flick Timeout)")
    public boolean aimOnInteract = DefaultCustomCameraConfig.INSTANCE.shouldAimPlayerOnInteract();
    @Comment(value="Angle in degrees within the player will slightly follow camera rotation")
    @ConfigEntry.BoundedDiscrete(min=0L, max=90L)
    public int followYaw = DefaultCustomCameraConfig.INSTANCE.getFollowYaw();
    @Comment(value="Does camera should rotate freely during elytra flight")
    public boolean freeCameraDuringElytraFlight = DefaultCustomCameraConfig.INSTANCE.hasFreeCameraDuringElytraFlight();

    public static CustomCameraConfig create() {
        AutoConfig.register(ClothModConfig.class, JanksonConfigSerializer::new);
        return (CustomCameraConfig)AutoConfig.getConfigHolder(ClothModConfig.class).getConfig();
    }

    @Override
    public boolean shouldAimPlayerOnInteract() {
        return this.aimOnInteract;
    }

    @Override
    public int getFollowYaw() {
        return this.followYaw;
    }

    @Override
    public boolean hasFreeCameraDuringElytraFlight() {
        return this.freeCameraDuringElytraFlight;
    }
}

