/*
 * Decompiled with CFR 0.152.
 */
package io.socol.betterthirdperson.api.util;

import io.socol.betterthirdperson.api.util.Rotation;
import java.util.Objects;

public class WorldPos {
    public final double x;
    public final double y;
    public final double z;

    public WorldPos(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorldPos worldPos = (WorldPos)o;
        return Double.compare(worldPos.x, this.x) == 0 && Double.compare(worldPos.y, this.y) == 0 && Double.compare(worldPos.z, this.z) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y, this.z);
    }

    public WorldPos add(double dx, double dy, double dz) {
        return new WorldPos(this.x + dx, this.y + dy, this.z + dz);
    }

    public String toString() {
        return "(" + this.x + "," + this.y + "," + this.z + ")";
    }

    public double distanceTo(WorldPos other) {
        double dx = this.x - other.x;
        double dy = this.y - other.y;
        double dz = this.z - other.z;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public double horizontalDistanceTo(WorldPos other) {
        double dx = this.x - other.x;
        double dz = this.z - other.z;
        return Math.sqrt(dx * dx + dz * dz);
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public double lengthSqr() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public WorldPos normalize() {
        double l = 1.0 / this.length();
        return new WorldPos(this.x * l, this.y * l, this.z * l);
    }

    public WorldPos add(WorldPos other) {
        return new WorldPos(this.x + other.x, this.y + other.y, this.z + other.z);
    }

    public WorldPos addScaled(WorldPos other, double s) {
        return new WorldPos(this.x + other.x * s, this.y + other.y * s, this.z + other.z * s);
    }

    public WorldPos subtract(WorldPos other) {
        return new WorldPos(this.x - other.x, this.y - other.y, this.z - other.z);
    }

    public WorldPos invert() {
        return new WorldPos(-this.x, -this.y, -this.z);
    }

    public WorldPos interpolate(WorldPos other, double progress) {
        return new WorldPos(this.x + (other.x - this.x) * progress, this.y + (other.y - this.y) * progress, this.z + (other.z - this.z) * progress);
    }

    public Rotation asRotation() {
        return Rotation.fromDirection(this.x, this.y, this.z);
    }

    public static WorldPos fromRotation(float yaw, float pitch) {
        float f = pitch * ((float)Math.PI / 180);
        float g = -yaw * ((float)Math.PI / 180);
        double h = Math.cos(g);
        double i = Math.sin(g);
        double j = Math.cos(f);
        double k = Math.sin(f);
        return new WorldPos(i * j, -k, h * j);
    }

    public boolean isZero() {
        return this.x == 0.0 && this.y == 0.0 && this.z == 0.0;
    }
}

