/*
 * Decompiled with CFR 0.152.
 */
package io.socol.betterthirdperson.api;

import io.socol.betterthirdperson.api.AngleUtils;
import io.socol.betterthirdperson.api.TickPhase;
import io.socol.betterthirdperson.api.adapter.IClientAdapter;
import io.socol.betterthirdperson.api.adapter.IMovementInputAdapter;
import io.socol.betterthirdperson.api.adapter.IPlayerAdapter;
import io.socol.betterthirdperson.api.adapter.IPlayerPosition;

public class CustomCamera {
    private static final float STATIC_ANGULAR_YAW = 45.0f;
    private static final int FLICK_TIMEOUT = 7;
    private float angularYaw;
    private float cameraYaw;
    private float playerYaw;
    private boolean cameraAligned;
    private IPlayerPosition lastTickPlayerPos;
    private float prevInputYaw = 0.0f;
    private float inputYaw = 0.0f;
    private boolean isMoving = false;
    private boolean mousePressed = false;
    private long mousePressedTicks = 0L;
    private long aimTimeout = 0L;
    private long maxAimTimeout = 0L;
    private boolean flicked = false;

    public CustomCamera(IPlayerAdapter player) {
        this.resetToPlayerView(player);
        this.lastTickPlayerPos = player.getPosition();
    }

    public void handleInputs(IMovementInputAdapter input, IClientAdapter client) {
        this.prevInputYaw = this.inputYaw;
        boolean leftKeyDown = input.isLeftKeyDown();
        boolean rightKeyDown = input.isRightKeyDown();
        boolean forwardKeyDown = input.isForwardKeyDown();
        boolean backKeyDown = input.isBackKeyDown();
        this.isMoving = leftKeyDown || rightKeyDown || forwardKeyDown || backKeyDown;
        this.mousePressed = client.isMousePressed();
        if (this.flicked && !this.mousePressed) {
            this.aimTimeout = this.maxAimTimeout = Math.max(0L, 7L - this.mousePressedTicks);
            this.flicked = false;
        }
        long l = this.mousePressedTicks = this.mousePressed ? this.mousePressedTicks + 1L : 0L;
        if (this.isMoving && this.mousePressedTicks <= this.aimTimeout) {
            if (forwardKeyDown != backKeyDown) {
                float f = this.inputYaw = forwardKeyDown ? 0.0f : -180.0f;
                if (leftKeyDown != rightKeyDown) {
                    this.inputYaw += (leftKeyDown ? -45.0f : 45.0f) * (float)(forwardKeyDown ? 1 : -1);
                }
            } else if (leftKeyDown != rightKeyDown) {
                this.inputYaw = leftKeyDown ? -90.0f : 90.0f;
            }
            float moveImpulse = Math.max(Math.abs(input.getMoveForward()), Math.abs(input.getMoveStrafe()));
            input.setMoveForward(moveImpulse);
            input.setMoveStrafe(0.0f);
            input.setLeftKeyDown(false);
            input.setRightKeyDown(false);
            input.setBackKeyDown(false);
            input.setForwardKeyDown(true);
        } else {
            this.inputYaw = 0.0f;
        }
        if (this.aimTimeout > 0L) {
            this.inputYaw *= 1.0f - (float)this.aimTimeout / (float)this.maxAimTimeout;
            --this.aimTimeout;
        }
    }

    public void setup(IPlayerAdapter player, float partialTicks) {
        if (this.playerYaw != player.getRotationYaw()) {
            float yawDelta = player.getRotationYaw() - this.playerYaw;
            if (Math.signum(yawDelta) != Math.signum(this.angularYaw)) {
                this.angularYaw = 0.0f;
            }
            this.angularYaw += yawDelta;
            this.cameraYaw += yawDelta;
            if (Math.abs(this.angularYaw) <= 45.0f) {
                this.playerYaw = (float)((double)this.playerYaw + (double)yawDelta * (1.0 - this.easeInExpo(Math.abs(this.angularYaw) / 45.0f)));
            }
            this.cameraYaw = AngleUtils.wrapAngle(this.playerYaw, this.cameraYaw);
        }
        if (this.isMoving || this.mousePressed) {
            this.playerYaw = this.cameraYaw + AngleUtils.smoothAngle(partialTicks, this.prevInputYaw, this.inputYaw);
        }
        if (this.playerYaw != player.getRotationYaw()) {
            player.setRotationYaw(this.playerYaw);
        }
    }

    public float getYawDelta() {
        return this.cameraYaw - this.playerYaw;
    }

    public void checkPosition(TickPhase phase, IPlayerAdapter player) {
        IPlayerPosition currentPos = player.getPosition();
        if (phase == TickPhase.START) {
            if (!this.lastTickPlayerPos.equals(currentPos)) {
                this.resetToPlayerView(player);
            }
        } else {
            this.lastTickPlayerPos = currentPos;
        }
    }

    boolean handleMouseAction(IPlayerAdapter player, IClientAdapter client) {
        if (!this.cameraAligned && this.aimTimeout == 0L) {
            this.flicked = this.flicked || this.isMoving;
            player.setRotationYawSafe(this.cameraYaw);
            client.updateHitResult();
            this.resetToPlayerView(player);
            return true;
        }
        return false;
    }

    private void resetToPlayerView(IPlayerAdapter player) {
        this.playerYaw = player.getRotationYaw();
        this.cameraYaw = player.getRotationYaw();
        this.angularYaw = 0.0f;
    }

    private double easeInExpo(double x) {
        return x == 0.0 ? 0.0 : Math.pow(2.0, 10.0 * x - 10.0);
    }

    public void onRotationSend() {
        this.cameraAligned = this.cameraYaw == this.playerYaw;
    }
}

