/*
 * Decompiled with CFR 0.152.
 */
package io.socol.betterthirdperson;

import io.socol.betterthirdperson.api.config.CustomCameraConfig;
import io.socol.betterthirdperson.api.config.DefaultCustomCameraConfig;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class CustomCameraConfigImpl
implements CustomCameraConfig {
    private final ForgeConfigSpec config;
    private final ForgeConfigSpec.BooleanValue aimOnInteract;
    private final ForgeConfigSpec.IntValue flickTimeout;
    private final ForgeConfigSpec.IntValue followYaw;

    public CustomCameraConfigImpl() {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        this.aimOnInteract = builder.comment("Align player to camera on left & right clicks (delayed by Flick Timeout)").define("aimPlayerOnInteract", DefaultCustomCameraConfig.INSTANCE.shouldAimPlayerOnInteract());
        this.flickTimeout = builder.comment("Delay in ticks between moments when player can flick towards the target in third person").defineInRange("flickTimeout", DefaultCustomCameraConfig.INSTANCE.getFlickTimeout(), 1, 20);
        this.followYaw = builder.comment("Angle in degrees within the player will slightly follow camera rotation").defineInRange("followYaw", DefaultCustomCameraConfig.INSTANCE.getFollowYaw(), 0, 90);
        this.config = builder.build();
    }

    public static CustomCameraConfig create() {
        CustomCameraConfigImpl configImpl = new CustomCameraConfigImpl();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)configImpl.config);
        return configImpl;
    }

    @Override
    public boolean shouldAimPlayerOnInteract() {
        return (Boolean)this.aimOnInteract.get();
    }

    @Override
    public int getFlickTimeout() {
        return (Integer)this.flickTimeout.get();
    }

    @Override
    public int getFollowYaw() {
        return (Integer)this.followYaw.get();
    }
}

