/*
 * Decompiled with CFR 0.152.
 */
package io.socol.betterthirdperson;

import io.socol.betterthirdperson.api.CustomCameraManager;
import io.socol.betterthirdperson.api.TickPhase;
import io.socol.betterthirdperson.impl.MovementInputAdapter;
import io.socol.betterthirdperson.impl.PlayerAdapter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.MovementInputUpdateEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class CustomCameraListener {
    private final CustomCameraManager manager;

    public CustomCameraListener(CustomCameraManager manager) {
        this.manager = manager;
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.player instanceof LocalPlayer) {
            PlayerAdapter player = new PlayerAdapter((AbstractClientPlayer)event.player);
            TickPhase phase = event.phase == TickEvent.Phase.START ? TickPhase.START : TickPhase.END;
            this.manager.onPlayerTick(player, phase);
        }
    }

    @SubscribeEvent
    public void onInputs(MovementInputUpdateEvent event) {
        PlayerAdapter player = new PlayerAdapter((AbstractClientPlayer)Minecraft.m_91087_().f_91074_);
        MovementInputAdapter inputs = new MovementInputAdapter(event.getInput());
        this.manager.onInputs(player, inputs);
    }

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (event.phase != TickEvent.Phase.START || player == null) {
            return;
        }
        PlayerAdapter playerAdapter = new PlayerAdapter((AbstractClientPlayer)player);
        this.manager.onRenderTickStart(playerAdapter, event.renderTickTime);
    }
}

