/*
 * Decompiled with CFR 0.152.
 */
package io.socol.betterthirdperson.mixin;

import io.socol.betterthirdperson.BetterThirdPerson;
import io.socol.betterthirdperson.api.action.ItemRepeatableUseAction;
import io.socol.betterthirdperson.api.action.MouseAction;
import io.socol.betterthirdperson.impl.ClientAdapter;
import io.socol.betterthirdperson.impl.PlayerAdapter;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Minecraft.class})
public abstract class MinecraftClientMixin {
    @Shadow
    private int rightClickDelay;
    @Shadow
    @Final
    public Options options;

    @Shadow
    protected abstract boolean startAttack();

    @Shadow
    protected abstract void startUseItem();

    @Shadow
    protected abstract void continueAttack(boolean var1);

    @Inject(method={"handleKeybinds()V"}, at={@At(value="HEAD")})
    public void onHandleInputEvents(CallbackInfo ci) {
        PlayerAdapter player = new PlayerAdapter((Player)Minecraft.getInstance().player);
        BetterThirdPerson.getCameraManager().onInputEvents(player);
    }

    @Inject(method={"runTick(Z)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/profiling/ProfilerFiller;popPush(Ljava/lang/String;)V", shift=At.Shift.BEFORE)}, slice={@Slice(from=@At(value="FIELD", opcode=180, target="Lnet/minecraft/client/Minecraft;noRender:Z", shift=At.Shift.AFTER), to=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/GameRenderer;render(Lnet/minecraft/client/DeltaTracker;Z)V", shift=At.Shift.BEFORE))})
    public void preRenderHook(boolean tick, CallbackInfo ci) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null) {
            float tickDelta = Minecraft.getInstance().getDeltaTracker().getGameTimeDeltaPartialTick(true);
            BetterThirdPerson.getCameraManager().onRenderTickStart(new PlayerAdapter((Player)player), tickDelta);
        }
    }

    @Inject(method={"startAttack()Z"}, at={@At(value="HEAD")}, cancellable=true)
    public void onDoAttack(CallbackInfoReturnable<Boolean> cir) {
        PlayerAdapter player = new PlayerAdapter((Player)Minecraft.getInstance().player);
        if (BetterThirdPerson.getCameraManager().onMouseAction(player, new MouseAction(this::startAttack))) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"continueAttack(Z)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void onBlockBreaking(boolean pressed, CallbackInfo ci) {
        PlayerAdapter player = new PlayerAdapter((Player)Minecraft.getInstance().player);
        if (pressed && BetterThirdPerson.getCameraManager().onMouseAction(player, new MouseAction(() -> this.continueAttack(true)))) {
            ci.cancel();
        }
    }

    @Redirect(method={"handleKeybinds()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/Minecraft;startUseItem()V", ordinal=0))
    public void onDoItemUse(Minecraft client) {
        PlayerAdapter player = new PlayerAdapter((Player)client.player);
        if (!BetterThirdPerson.getCameraManager().onMouseAction(player, new MouseAction(this::startUseItem))) {
            this.startUseItem();
        }
    }

    @Redirect(method={"handleKeybinds()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/Minecraft;startUseItem()V", ordinal=1))
    public void onItemUseRepeatable(Minecraft client) {
        PlayerAdapter player = new PlayerAdapter((Player)client.player);
        if (!BetterThirdPerson.getCameraManager().onMouseAction(player, new ItemRepeatableUseAction(ClientAdapter.INSTANCE, () -> this.rightClickDelay, this::startUseItem))) {
            this.startUseItem();
        }
    }

    @Inject(method={"handleKeybinds()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/Options;setCameraType(Lnet/minecraft/client/CameraType;)V", shift=At.Shift.AFTER)})
    public void onSetPerspective(CallbackInfo ci) {
        if (BetterThirdPerson.getCameraManager().getConfig().skipThirdPersonFrontView() && this.options.getCameraType() == CameraType.THIRD_PERSON_FRONT) {
            this.options.setCameraType(CameraType.FIRST_PERSON);
        }
    }
}

