/*
 * Decompiled with CFR 0.152.
 */
package com.bewitchment.api.capability.magicpower;

import com.bewitchment.Bewitchment;
import com.bewitchment.ModConfig;
import com.bewitchment.common.block.tile.entity.TileEntityWitchesAltar;
import com.bewitchment.common.item.tool.ItemBastardsGrimoire;
import com.bewitchment.common.item.tool.ItemGrimoireMagia;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;

public class MagicPower
implements ICapabilitySerializable<NBTTagCompound>,
Capability.IStorage<MagicPower> {
    @CapabilityInject(value=MagicPower.class)
    public static final Capability<MagicPower> CAPABILITY = null;
    public int amount;
    public int maxAmount;

    public MagicPower() {
        this.maxAmount = ModConfig.misc.maxGrimoirePower;
    }

    public static boolean attemptDrain(TileEntity tile, EntityPlayer player, int amount) {
        World world = null;
        if (player != null) {
            world = player.field_70170_p;
        } else if (tile != null) {
            world = tile.func_145831_w();
        }
        if (world == null) {
            return false;
        }
        boolean flag = MagicPower.attemptDrain(tile, player, amount, true);
        if (flag && !world.field_72995_K) {
            MagicPower.attemptDrain(tile, player, amount, false);
        }
        return flag;
    }

    public static boolean attemptDrain(TileEntity tile, EntityPlayer player, int amount, boolean simulate) {
        if (amount == 0) {
            return true;
        }
        if (tile instanceof TileEntityWitchesAltar && ((MagicPower)tile.getCapability(CAPABILITY, null)).drain(amount, simulate)) {
            return true;
        }
        if (player != null) {
            List<ItemStack> inv = Bewitchment.proxy.getEntireInventory(player);
            for (ItemStack stack : inv) {
                if (!(stack.func_77973_b() instanceof ItemGrimoireMagia) && !(stack.func_77973_b() instanceof ItemBastardsGrimoire) || !stack.func_77942_o()) continue;
                NBTTagCompound tag = stack.func_77978_p();
                MagicPower cap = new MagicPower();
                cap.amount = tag.func_74762_e("amount");
                cap.maxAmount = tag.func_74762_e("maxAmount");
                if (!cap.drain(amount, simulate)) continue;
                if (!simulate) {
                    tag.func_74768_a("amount", cap.amount);
                }
                return true;
            }
        }
        return false;
    }

    public static boolean transfer(MagicPower to, MagicPower from, int amount, float loss) {
        if (to.amount - amount >= 0 && from.amount < from.maxAmount) {
            return to.drain(amount) && from.fill((int)((float)amount * loss));
        }
        return false;
    }

    @Nullable
    public NBTBase writeNBT(Capability<MagicPower> capability, MagicPower instance, EnumFacing face) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("amount", instance.amount);
        tag.func_74768_a("maxAmount", instance.maxAmount);
        return tag;
    }

    public void readNBT(Capability<MagicPower> capability, MagicPower instance, EnumFacing face, NBTBase nbt) {
        NBTTagCompound tag = (NBTTagCompound)nbt;
        instance.amount = tag.func_74762_e("amount");
        instance.maxAmount = tag.func_74762_e("maxAmount");
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing face) {
        return this.getCapability(capability, null) != null;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing face) {
        return (T)(capability == CAPABILITY ? CAPABILITY.cast((Object)this) : null);
    }

    public NBTTagCompound serializeNBT() {
        return (NBTTagCompound)CAPABILITY.getStorage().writeNBT(CAPABILITY, (Object)this, null);
    }

    public void deserializeNBT(NBTTagCompound tag) {
        CAPABILITY.getStorage().readNBT(CAPABILITY, (Object)this, null, (NBTBase)tag);
    }

    public boolean drain(int amount) {
        return this.drain(amount, false);
    }

    public boolean drain(int amount, boolean simulate) {
        if (this.amount - amount >= 0) {
            if (!simulate) {
                this.amount -= amount;
            }
            return true;
        }
        return false;
    }

    public boolean fill(int amount) {
        return this.fill(amount, false);
    }

    public boolean fill(int amount, boolean simulate) {
        if (this.amount < this.maxAmount) {
            if (!simulate) {
                this.amount = Math.min(this.amount + amount, this.maxAmount);
            }
            return true;
        }
        return false;
    }
}

