/*
 * Decompiled with CFR 0.152.
 */
package com.bewitchment.client.integration.jei.category;

import com.bewitchment.api.registry.CauldronRecipe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;

public class CauldronCategory
implements IRecipeCategory<Wrapper> {
    public static final String UID = "jei.cauldron";
    private final IDrawable bg;

    public CauldronCategory(IGuiHelper helper) {
        this.bg = helper.drawableBuilder(new ResourceLocation("bewitchment", "textures/gui/jei_cauldron.png"), 0, 0, 160, 64).setTextureSize(160, 64).build();
    }

    public String getUid() {
        return UID;
    }

    public String getTitle() {
        return I18n.func_135052_a((String)UID, (Object[])new Object[0]);
    }

    public String getModName() {
        return "Bewitchment";
    }

    public IDrawable getBackground() {
        return this.bg;
    }

    public void setRecipe(IRecipeLayout recipeLayout, Wrapper recipeWrapper, IIngredients ingredients) {
        int i;
        for (i = 0; i < recipeWrapper.input.size(); ++i) {
            recipeLayout.getItemStacks().init(i, true, 18 * i + (160 - 18 * recipeWrapper.input.size()) / 2, 2);
            recipeLayout.getItemStacks().set(i, (List)recipeWrapper.input.get(i));
        }
        if (recipeWrapper.output != null) {
            for (i = 0; i < recipeWrapper.output.size(); ++i) {
                recipeLayout.getItemStacks().init(i + recipeWrapper.input.size(), false, 18 * i + (160 - 18 * recipeWrapper.output.size()) / 2, 44);
                recipeLayout.getItemStacks().set(i + recipeWrapper.input.size(), (ItemStack)recipeWrapper.output.get(i));
            }
        }
    }

    public static class Wrapper
    implements IRecipeWrapper {
        private final List<List<ItemStack>> input = new ArrayList<List<ItemStack>>();
        private final List<ItemStack> output;

        public Wrapper(CauldronRecipe recipe) {
            for (Ingredient ing : recipe.input) {
                this.input.add(Arrays.asList(ing.func_193365_a()));
            }
            this.output = recipe.output;
        }

        public void getIngredients(IIngredients ingredients) {
            ingredients.setInputLists(VanillaTypes.ITEM, this.input);
            if (this.output != null && !this.output.isEmpty()) {
                ingredients.setOutputs(VanillaTypes.ITEM, this.output);
            }
        }
    }
}

