/*
 * Decompiled with CFR 0.152.
 */
package com.bewitchment.client.integration.jei.category;

import com.bewitchment.api.registry.Ritual;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.api.recipe.IRecipeWrapperFactory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class RitualCategory
implements IRecipeCategory<Wrapper> {
    public static final String UID = "jei.ritual";
    private final IDrawable bg;

    public RitualCategory(IGuiHelper helper) {
        this.bg = helper.createBlankDrawable(180, 110);
    }

    public String getUid() {
        return UID;
    }

    public String getTitle() {
        return I18n.func_135052_a((String)UID, (Object[])new Object[0]);
    }

    public String getModName() {
        return "Bewitchment";
    }

    public IDrawable getBackground() {
        return this.bg;
    }

    public void setRecipe(IRecipeLayout recipeLayout, Wrapper recipeWrapper, IIngredients ingredients) {
        int i;
        for (i = 0; i < recipeWrapper.input.size(); ++i) {
            recipeLayout.getItemStacks().init(i, true, 18 * i + (180 - 18 * recipeWrapper.input.size()) / 2, 10);
            recipeLayout.getItemStacks().set(i, (List)recipeWrapper.input.get(i));
        }
        if (recipeWrapper.output != null) {
            for (i = 0; i < recipeWrapper.output.size(); ++i) {
                recipeLayout.getItemStacks().init(i + recipeWrapper.input.size(), false, 18 * i + (180 - 18 * recipeWrapper.output.size()) / 2, 68);
                recipeLayout.getItemStacks().set(i + recipeWrapper.input.size(), (ItemStack)recipeWrapper.output.get(i));
            }
        }
    }

    public static class RitualWrapperFactory
    implements IRecipeWrapperFactory<Ritual> {
        private final IGuiHelper helper;

        public RitualWrapperFactory(IGuiHelper helper) {
            this.helper = helper;
        }

        public IRecipeWrapper getRecipeWrapper(Ritual ritual) {
            return new Wrapper(ritual, this.helper);
        }
    }

    public static class Wrapper
    implements IRecipeWrapper {
        private static IDrawable center;
        private static IDrawable small;
        private static IDrawable medium;
        private static IDrawable large;
        private final int[] circles;
        private final List<List<ItemStack>> input;
        private final List<ItemStack> output;
        private final int startingPower;
        private final int runningPower;
        private final String name;

        public Wrapper(Ritual ritual, IGuiHelper helper) {
            this.circles = ritual.circles;
            this.input = new ArrayList<List<ItemStack>>();
            for (Ingredient ing : ritual.input) {
                this.input.add(Arrays.asList(ing.func_193365_a()));
            }
            this.output = ritual.output;
            this.startingPower = ritual.startingPower;
            this.runningPower = ritual.runningPower;
            this.name = I18n.func_135052_a((String)("ritual." + ritual.getRegistryName().toString().replace(":", ".")), (Object[])new Object[0]);
            center = helper.drawableBuilder(new ResourceLocation("bewitchment", "textures/gui/jei_ritual_0.png"), 0, 0, 34, 34).setTextureSize(34, 34).build();
            small = helper.drawableBuilder(new ResourceLocation("bewitchment", "textures/gui/jei_ritual_1.png"), 0, 0, 34, 34).setTextureSize(34, 34).build();
            medium = helper.drawableBuilder(new ResourceLocation("bewitchment", "textures/gui/jei_ritual_2.png"), 0, 0, 34, 34).setTextureSize(34, 34).build();
            large = helper.drawableBuilder(new ResourceLocation("bewitchment", "textures/gui/jei_ritual_3.png"), 0, 0, 34, 34).setTextureSize(34, 34).build();
        }

        public void getIngredients(IIngredients ingredients) {
            ingredients.setInputLists(VanillaTypes.ITEM, this.input);
            if (this.output != null && !this.output.isEmpty()) {
                ingredients.setOutputs(VanillaTypes.ITEM, this.output);
            }
        }

        public void drawInfo(Minecraft minecraft, int width, int height, int mouseX, int mouseY) {
            FontRenderer font = minecraft.field_71466_p;
            font.func_78276_b(this.name, (width - font.func_78256_a(this.name)) / 2, 0, 0);
            String startingPower = I18n.func_135052_a((String)"jei.ritual.startingPower", (Object[])new Object[]{this.startingPower});
            String runningPower = I18n.func_135052_a((String)"jei.ritual.runningPower", (Object[])new Object[]{this.runningPower});
            if (this.startingPower > 0) {
                font.func_78276_b(startingPower, (width - font.func_78256_a(startingPower)) / 2, height - (this.runningPower > 0 ? 3 : 2) * font.field_78288_b * 4 / 5, 0);
            }
            if (this.runningPower > 0) {
                font.func_78276_b(runningPower, (width - font.func_78256_a(runningPower)) / 2, height - 2 * font.field_78288_b * 2 / 3, 0);
            }
            int x = 73;
            int y = 24;
            this.color(minecraft, 0);
            center.draw(minecraft, x, y * 5 / 4);
            this.color(minecraft, this.circles[0]);
            small.draw(minecraft, x, y * 5 / 4);
            if (this.circles[1] > 0) {
                this.color(minecraft, this.circles[1]);
                medium.draw(minecraft, x, y * 5 / 4);
                if (this.circles[2] > 0) {
                    this.color(minecraft, this.circles[2]);
                    large.draw(minecraft, x, y * 5 / 4);
                }
            }
        }

        private void color(Minecraft minecraft, int type) {
            if (type == 0) {
                GL11.glColor3f((float)1.0f, (float)1.0f, (float)0.0f);
            } else if (type == 1) {
                GL11.glColor3f((float)0.9f, (float)0.9f, (float)0.9f);
            } else if (type == 2) {
                GL11.glColor3f((float)0.8f, (float)0.0f, (float)0.0f);
            } else if (type == 3) {
                GL11.glColor3f((float)0.5f, (float)0.0f, (float)0.5f);
            } else {
                int r = (int)(minecraft.field_71441_e.func_82737_E() % 60L / 20L);
                if (r == 0) {
                    this.color(minecraft, 1);
                } else if (r == 1) {
                    this.color(minecraft, 2);
                } else {
                    this.color(minecraft, 3);
                }
            }
        }
    }
}

