/*
 * Decompiled with CFR 0.152.
 */
package com.bewitchment.client.integration.jei.category;

import com.bewitchment.api.registry.SpinningWheelRecipe;
import com.bewitchment.registry.ModObjects;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;

public class SpinningWheelCategory
implements IRecipeCategory<Wrapper> {
    public static final String UID = ModObjects.spinning_wheel.func_149739_a() + ".name";
    private final IDrawable bg;

    public SpinningWheelCategory(IGuiHelper helper) {
        this.bg = helper.drawableBuilder(new ResourceLocation("bewitchment", "textures/gui/jei_spinning_wheel.png"), 0, 0, 90, 36).setTextureSize(90, 36).build();
    }

    public String getUid() {
        return UID;
    }

    public String getTitle() {
        return I18n.func_135052_a((String)UID, (Object[])new Object[0]);
    }

    public String getModName() {
        return "Bewitchment";
    }

    public IDrawable getBackground() {
        return this.bg;
    }

    public void setRecipe(IRecipeLayout recipeLayout, Wrapper recipeWrapper, IIngredients ingredients) {
        int i;
        for (i = 0; i < recipeWrapper.input.size(); ++i) {
            recipeLayout.getItemStacks().init(i + 2, true, i % 2 * 18, i / 2 * 18);
            recipeLayout.getItemStacks().set(i + 2, Arrays.asList(((Ingredient)recipeWrapper.input.get(i)).func_193365_a()));
        }
        for (i = 0; i < recipeWrapper.output.size(); ++i) {
            recipeLayout.getItemStacks().init(i, false, 72, i * 18);
            recipeLayout.getItemStacks().set(i, (ItemStack)recipeWrapper.output.get(i));
        }
    }

    public static class Wrapper
    implements IRecipeWrapper {
        private final List<Ingredient> input;
        private final List<ItemStack> output;

        public Wrapper(SpinningWheelRecipe recipe) {
            this.input = recipe.input;
            this.output = recipe.output;
        }

        public void getIngredients(IIngredients ingredients) {
            ArrayList<List<ItemStack>> lists = new ArrayList<List<ItemStack>>();
            for (Ingredient ing : this.input) {
                lists.add(Arrays.asList(ing.func_193365_a()));
            }
            ingredients.setInputLists(VanillaTypes.ITEM, lists);
            ingredients.setOutputs(VanillaTypes.ITEM, this.output);
        }
    }
}

