/*
 * Decompiled with CFR 0.152.
 */
package com.bewitchment.common.block;

import com.bewitchment.Util;
import com.bewitchment.common.block.tile.entity.TileEntitySigil;
import com.bewitchment.common.block.util.ModBlock;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockSigil
extends ModBlock
implements ITileEntityProvider {
    public static final PropertyDirection FACING = PropertyDirection.func_177714_a((String)"facing");
    public static final PropertyInteger VARIATION = PropertyInteger.func_177719_a((String)"variation", (int)0, (int)9);
    private static final AxisAlignedBB UP_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.01, 1.0);
    private static final AxisAlignedBB DOWN_AABB = new AxisAlignedBB(0.0, 0.99, 0.0, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB EAST_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.01, 1.0, 1.0);
    private static final AxisAlignedBB WEST_AABB = new AxisAlignedBB(0.99, 0.0, 0.0, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB SOUTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.01);
    private static final AxisAlignedBB NORTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.99, 1.0, 1.0, 1.0);

    public BlockSigil() {
        super(Material.field_151594_q);
        Util.registerBlock(this, "sigil", Blocks.field_150325_L, new String[0]);
        this.field_149783_u = true;
        this.func_149713_g(0);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
    }

    @Override
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return state.func_177226_a((IProperty)VARIATION, (Comparable)Integer.valueOf(Math.abs(pos.func_177958_n() + pos.func_177956_o() + pos.func_177952_p() * 2) % 10));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
            case EAST: {
                return EAST_AABB;
            }
            case WEST: {
                return WEST_AABB;
            }
            case SOUTH: {
                return SOUTH_AABB;
            }
            case NORTH: {
                return NORTH_AABB;
            }
            case UP: {
                return UP_AABB;
            }
            case DOWN: {
                return DOWN_AABB;
            }
        }
        return UP_AABB;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        switch (facing) {
            case UP: {
                world.func_175688_a(EnumParticleTypes.REDSTONE, (double)pos.func_177958_n() + rand.nextGaussian() / 5.0, (double)pos.func_177956_o(), (double)pos.func_177952_p() + rand.nextGaussian() / 5.0, 0.0, 0.0, 0.0, new int[0]);
                break;
            }
            case DOWN: {
                world.func_175688_a(EnumParticleTypes.REDSTONE, (double)pos.func_177958_n() + rand.nextGaussian() / 5.0, (double)pos.func_177956_o() + 0.8, (double)pos.func_177952_p() + rand.nextGaussian() / 5.0, 0.0, 0.0, 0.0, new int[0]);
                break;
            }
            case EAST: {
                world.func_175688_a(EnumParticleTypes.REDSTONE, (double)pos.func_177958_n(), (double)pos.func_177956_o() + rand.nextGaussian() / 5.0 + 0.5, (double)pos.func_177952_p() + rand.nextGaussian() / 5.0, 0.0, 0.0, 0.0, new int[0]);
                break;
            }
            case WEST: {
                world.func_175688_a(EnumParticleTypes.REDSTONE, (double)(pos.func_177958_n() + 1), (double)pos.func_177956_o() + rand.nextGaussian() / 5.0 + 0.5, (double)pos.func_177952_p() + rand.nextGaussian() / 5.0, 0.0, 0.0, 0.0, new int[0]);
                break;
            }
            case SOUTH: {
                world.func_175688_a(EnumParticleTypes.REDSTONE, (double)pos.func_177958_n() + rand.nextGaussian() / 5.0, (double)pos.func_177956_o() + rand.nextGaussian() / 5.0 + 0.5, (double)pos.func_177952_p(), 0.0, 0.0, 0.0, new int[0]);
                break;
            }
            case NORTH: {
                world.func_175688_a(EnumParticleTypes.REDSTONE, (double)pos.func_177958_n() + rand.nextGaussian() / 5.0, (double)pos.func_177956_o() + rand.nextGaussian() / 5.0 + 0.5, (double)(pos.func_177952_p() + 1), 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        if (!worldIn.func_180495_p(pos.func_177972_a(enumfacing.func_176734_d())).func_185904_a().func_76220_a()) {
            worldIn.func_175698_g(pos);
        }
        super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
    }

    public boolean func_176198_a(World worldIn, BlockPos pos, EnumFacing side) {
        return super.func_176198_a(worldIn, pos, side) && worldIn.func_180495_p(pos.func_177972_a(side.func_176734_d())).func_193401_d((IBlockAccess)worldIn, pos.func_177972_a(side.func_176734_d()), side) == BlockFaceShape.SOLID;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return ((TileEntitySigil)worldIn.func_175625_s(pos)).activate(worldIn, pos, playerIn, hand, facing);
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.DESTROY;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIATION, FACING});
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return 4;
    }

    public boolean isFlammable(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return false;
    }

    public boolean canPlaceTorchOnTop(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        if (world.func_175625_s(pos) instanceof TileEntitySigil) {
            return new ItemStack((Item)((TileEntitySigil)world.func_175625_s((BlockPos)pos)).sigil);
        }
        return super.getPickBlock(state, target, world, pos, player);
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing);
    }

    @Nullable
    public PathNodeType getAiPathNodeType(IBlockState state, IBlockAccess world, BlockPos pos, @Nullable EntityLiving entity) {
        return PathNodeType.OPEN;
    }

    @Nullable
    public TileEntity func_149915_a(World world, int i) {
        return new TileEntitySigil();
    }
}

