/*
 * Decompiled with CFR 0.152.
 */
package com.bewitchment.common.block.tile.entity;

import com.bewitchment.Util;
import com.bewitchment.api.event.CurseEvent;
import com.bewitchment.api.registry.Curse;
import com.bewitchment.api.registry.Incense;
import com.bewitchment.common.block.BlockBrazier;
import com.bewitchment.common.block.tile.entity.util.ModTileEntity;
import com.bewitchment.common.item.ItemTaglock;
import com.bewitchment.registry.ModObjects;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFlintAndSteel;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityBrazier
extends ModTileEntity
implements ITickable {
    public ItemStackHandler handler = new ItemStackHandler(9);
    public Incense incense = null;
    private int litTime = 0;

    private void getIncense() {
        Incense incense = GameRegistry.findRegistry(Incense.class).getValuesCollection().stream().filter(p -> p.matches(this.handler)).findFirst().orElse(null);
        if (incense != null) {
            this.incense = incense;
            this.litTime = 0;
        }
        this.func_70296_d();
    }

    private void curse(EntityPlayer caster) {
        Curse curse = GameRegistry.findRegistry(Curse.class).getValuesCollection().stream().filter(p -> p.matches(this.handler)).findFirst().orElse(null);
        if (curse != null) {
            EntityPlayer target = null;
            for (int i = 0; i < this.handler.getSlots() && (target = ItemTaglock.getPlayerFromTaglock(this.handler.getStackInSlot(i))) == null; ++i) {
            }
            if (target != null) {
                int days = 7;
                CurseEvent.PlayerCursedEvent event = new CurseEvent.PlayerCursedEvent(target, caster, curse, days);
                MinecraftForge.EVENT_BUS.post((Event)event);
                if (!event.isCanceled()) {
                    event.getCurse().apply(event.getTarget(), event.getCurseDuration());
                }
            }
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        this.readUpdateTag(tag);
        super.func_145839_a(tag);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        this.writeUpdateTag(tag);
        return super.func_189515_b(tag);
    }

    @Override
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = new NBTTagCompound();
        this.writeUpdateTag(tag);
        return new SPacketUpdateTileEntity(this.field_174879_c, this.func_145832_p(), tag);
    }

    @Override
    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = super.func_189517_E_();
        this.writeUpdateTag(tag);
        return tag;
    }

    @Override
    public void onDataPacket(NetworkManager manager, SPacketUpdateTileEntity packet) {
        NBTTagCompound tag = packet.func_148857_g();
        this.readUpdateTag(tag);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean activate(World world, BlockPos pos, EntityPlayer player, EnumHand hand, EnumFacing face) {
        IBlockState state = world.func_180495_p(pos);
        if (!((Boolean)state.func_177229_b((IProperty)BlockBrazier.LIT)).booleanValue()) {
            if (player.func_70093_af()) return false;
            if (player.func_184586_b(hand).func_77973_b() instanceof ItemFlintAndSteel) {
                if (TileEntityBrazier.isEmpty(this.handler)) return false;
                world.func_175656_a(pos, state.func_177226_a((IProperty)BlockBrazier.LIT, (Comparable)Boolean.valueOf(true)));
                if (player.field_70170_p.field_72995_K) {
                    player.field_70170_p.func_184133_a(player, pos, SoundEvents.field_187606_E, SoundCategory.BLOCKS, 1.0f, 1.0f);
                }
                this.getIncense();
                if (this.incense == null) {
                    this.curse(player);
                }
                this.clearBrazier();
                this.func_70296_d();
                return true;
            }
            int slot = TileEntityBrazier.getFirstEmptySlot(this.handler);
            if (slot == -1) return super.activate(world, pos, player, hand, face);
            Item heldItem = player.func_184586_b(hand).func_77973_b();
            if (heldItem.func_77668_q() != null) {
                Util.giveItem(player, new ItemStack(heldItem.func_77668_q()));
            } else if (heldItem instanceof ItemTaglock) {
                Util.giveItem(player, new ItemStack(ModObjects.taglock));
            }
            player.field_71071_by.func_70437_b(this.handler.insertItem(slot, player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, 1), false));
            this.func_70296_d();
            world.func_184138_a(pos, state, state, 3);
            return true;
        }
        if (!(player.func_184586_b(hand).func_77973_b() instanceof ItemSpade)) return super.activate(world, pos, player, hand, face);
        this.stopBurning();
        return true;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.handler;
        }
        return (T)super.getCapability(capability, facing);
    }

    private void writeUpdateTag(NBTTagCompound tag) {
        tag.func_74778_a("incense", this.incense == null ? "" : this.incense.getRegistryName().toString());
        tag.func_74768_a("time", this.litTime);
        tag.func_74782_a("handler", (NBTBase)this.handler.serializeNBT());
    }

    private void readUpdateTag(NBTTagCompound tag) {
        this.incense = tag.func_74779_i("incense").isEmpty() ? null : (Incense)GameRegistry.findRegistry(Incense.class).getValue(new ResourceLocation(tag.func_74779_i("incense")));
        this.litTime = tag.func_74762_e("time");
        this.handler.deserializeNBT(tag.func_74775_l("handler"));
    }

    public void func_73660_a() {
        if (this.incense != null && this.field_145850_b.func_82737_E() % 20L == 0L) {
            ++this.litTime;
            if (this.litTime > this.incense.time) {
                this.stopBurning();
            }
        }
        if (this.litTime > 168000) {
            this.stopBurning();
        }
    }

    private void stopBurning() {
        this.litTime = 0;
        this.incense = null;
        this.field_145850_b.func_175656_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)BlockBrazier.LIT, (Comparable)Boolean.valueOf(false)));
        this.func_70296_d();
    }

    private void clearBrazier() {
        for (int i = 0; i < this.handler.getSlots(); ++i) {
            this.handler.setStackInSlot(i, ItemStack.field_190927_a);
        }
        this.func_70296_d();
    }
}

