/*
 * Decompiled with CFR 0.152.
 */
package com.bewitchment.common.handler;

import com.bewitchment.Util;
import com.bewitchment.api.BewitchmentAPI;
import com.bewitchment.api.misc.Weakness;
import com.bewitchment.registry.ModEnchantments;
import com.bewitchment.registry.ModObjects;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

public class MaterialHandler {
    public static final Set<Item> SILVER_TOOLS = new HashSet<Item>();
    public static final Set<Item> SILVER_ARMOR = new HashSet<Item>();
    public static final Set<Item> COLD_IRON_TOOLS = new HashSet<Item>();
    public static final Set<Item> COLD_IRON_ARMOR = new HashSet<Item>();

    public static float getDamage(float initialDamage, Weakness weakness, EntityLivingBase target, EntityLivingBase attacker, Set<Item> tools, Set<Item> armor) {
        float amount = weakness.get(target);
        if (amount > 1.0f && tools.contains(attacker.func_184614_ca().func_77973_b())) {
            return initialDamage * amount;
        }
        amount = weakness.get(attacker);
        if (amount > 1.0f) {
            int a = 0;
            for (ItemStack stack : target.func_184193_aE()) {
                if (!armor.contains(stack.func_77973_b())) continue;
                ++a;
            }
            if (a > 0) {
                attacker.func_70097_a(DamageSource.func_92087_a((Entity)target), (float)a);
                return initialDamage * (1.0f - 0.06f * (float)a);
            }
        }
        return initialDamage;
    }

    @SubscribeEvent
    public void livingUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (!entity.field_70170_p.field_72995_K && entity.field_70173_aa % 20 == 0) {
            int armor;
            if (BewitchmentAPI.SILVER_WEAKNESS.contains(entity)) {
                armor = 0;
                for (ItemStack stack : entity.func_184193_aE()) {
                    if (!SILVER_ARMOR.contains(stack.func_77973_b())) continue;
                    ++armor;
                }
                if (armor > 0) {
                    entity.func_70097_a(DamageSource.field_76376_m, (float)armor);
                }
            }
            if (BewitchmentAPI.COLD_IRON_WEAKNESS.contains(entity)) {
                armor = 0;
                for (ItemStack stack : entity.func_184193_aE()) {
                    if (!COLD_IRON_ARMOR.contains(stack.func_77973_b())) continue;
                    ++armor;
                }
                if (armor > 0) {
                    entity.func_70097_a(DamageSource.field_76376_m, (float)armor);
                }
            }
        }
    }

    @SubscribeEvent
    public void livingHurt(@NotNull LivingHurtEvent event) {
        EntityLivingBase target = event.getEntityLiving();
        Entity entity = event.getSource().func_76364_f();
        if (!target.field_70170_p.field_72995_K && entity instanceof EntityLivingBase) {
            EntityLivingBase attacker = (EntityLivingBase)entity;
            float damage = MaterialHandler.getDamage(event.getAmount(), BewitchmentAPI.SILVER_WEAKNESS, target, attacker, SILVER_TOOLS, SILVER_ARMOR);
            event.setAmount(damage);
            damage = MaterialHandler.getDamage(event.getAmount(), BewitchmentAPI.COLD_IRON_WEAKNESS, target, attacker, COLD_IRON_TOOLS, COLD_IRON_ARMOR);
            event.setAmount(damage);
            ModEnchantments.magic_protection.applyEnchantment(event, Util.getArmorPieces(target, ModObjects.ARMOR_WITCHES));
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void materialToolTip(ItemTooltipEvent event) {
        if (SILVER_TOOLS.contains(event.getItemStack().func_77973_b())) {
            event.getToolTip().add(TextFormatting.GOLD + I18n.func_135052_a((String)"tooltip.bewitchment.silver_tool_description.name", (Object[])new Object[0]));
        }
        if (SILVER_ARMOR.contains(event.getItemStack().func_77973_b())) {
            event.getToolTip().add(TextFormatting.GOLD + I18n.func_135052_a((String)"tooltip.bewitchment.silver_armor_description.name", (Object[])new Object[0]));
        }
        if (COLD_IRON_TOOLS.contains(event.getItemStack().func_77973_b())) {
            event.getToolTip().add(TextFormatting.GOLD + I18n.func_135052_a((String)"tooltip.bewitchment.cold_iron_tool_description.name", (Object[])new Object[0]));
        }
        if (COLD_IRON_ARMOR.contains(event.getItemStack().func_77973_b())) {
            event.getToolTip().add(TextFormatting.GOLD + I18n.func_135052_a((String)"tooltip.bewitchment.cold_iron_armor_description.name", (Object[])new Object[0]));
        }
    }
}

