/*
 * Decompiled with CFR 0.152.
 */
package com.bewitchment.common.integration.patchouli;

import com.bewitchment.api.registry.Ritual;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.GameRegistry;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariableProvider;
import vazkii.patchouli.api.PatchouliAPI;

public class ProcessorRitual
implements IComponentProcessor {
    private Ritual recipe;

    public void setup(IVariableProvider<String> provider) {
        this.recipe = (Ritual)GameRegistry.findRegistry(Ritual.class).getValue(new ResourceLocation((String)provider.get("recipe")));
    }

    public String process(String key) {
        if (this.recipe == null) {
            return null;
        }
        if (key.startsWith("input")) {
            int id = Integer.parseInt(key.substring(5));
            if (this.recipe.input.size() > id) {
                return PatchouliAPI.instance.serializeIngredient(this.recipe.input.get(id));
            }
        } else if (key.startsWith("output")) {
            int id = Integer.parseInt(key.substring(6));
            if (this.recipe.output != null && this.recipe.output.size() > id) {
                return PatchouliAPI.instance.serializeItemStack(this.recipe.output.get(id));
            }
        } else {
            if (key.equals("foci")) {
                return "bewitchment:textures/gui/patchouli/circle/foci.png";
            }
            if (key.startsWith("circle")) {
                int id = Integer.parseInt(key.substring(6));
                if (this.recipe.circles[id] > -1) {
                    return "bewitchment:textures/gui/patchouli/circle/circle" + this.recipe.circles[id] + id + ".png";
                }
                return "bewitchment:textures/gui/patchouli/circle/foci.png";
            }
            if (key.equals("name")) {
                return I18n.func_135052_a((String)("ritual." + this.recipe.getRegistryName().toString().replace(":", ".")), (Object[])new Object[0]);
            }
            if (key.equals("startingCost")) {
                return "Starting Cost: " + this.recipe.startingPower;
            }
            if (key.equals("runningCost")) {
                return "Running Cost: " + this.recipe.runningPower;
            }
        }
        return null;
    }
}

