/*
 * Decompiled with CFR 0.152.
 */
package com.bewitchment.common.item;

import com.bewitchment.Bewitchment;
import com.bewitchment.Util;
import com.bewitchment.api.capability.extendedplayer.ExtendedPlayer;
import com.bewitchment.api.message.SpawnParticle;
import com.bewitchment.api.registry.Contract;
import com.bewitchment.api.registry.Curse;
import com.bewitchment.common.item.ItemTaglock;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class ItemContract
extends Item {
    public ItemContract() {
        Util.registerItem(this, "contract", Collections.singletonList(s -> s.func_77942_o() && s.func_77978_p().func_74764_b("boundName")), new String[0]);
        this.func_77625_d(1);
    }

    public boolean complete(ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemContract && stack.func_77942_o()) {
            NBTTagCompound tag = stack.func_77978_p();
            if (tag.func_74764_b("mobsComplete") && tag.func_74764_b("mobsTotal") && tag.func_74762_e("mobsTotal") - tag.func_74762_e("mobsComplete") == 0) {
                return true;
            }
            if (tag.func_74764_b("items")) {
                NBTTagList list = tag.func_150295_c("items", 10);
                boolean flag = true;
                for (int i = 0; i < list.func_74745_c(); ++i) {
                    NBTTagCompound compound = list.func_150305_b(i);
                    if (compound.func_74762_e("amountTotal") - compound.func_74762_e("amountComplete") == 0) continue;
                    flag = false;
                }
                return flag;
            }
        }
        return false;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (heldItem.func_77942_o() && heldItem.func_77978_p().func_74764_b("contract")) {
            Contract temp = (Contract)GameRegistry.findRegistry(Curse.class).getValue(new ResourceLocation(heldItem.func_77978_p().func_74779_i("contract")));
            if (!heldItem.func_77978_p().func_74764_b("boundId") && !heldItem.func_77978_p().func_74764_b("boundName")) {
                heldItem.func_77978_p().func_74778_a("boundId", player.getPersistentID().toString());
                heldItem.func_77978_p().func_74778_a("boundName", player.func_70005_c_());
                player.func_184611_a(hand, heldItem);
                if (world.field_72995_K) {
                    world.func_184133_a(player, player.func_180425_c(), SoundEvents.field_187604_bf, SoundCategory.NEUTRAL, 10.0f, 1.0f);
                }
                return new ActionResult(EnumActionResult.PASS, (Object)player.func_184586_b(hand));
            }
            if (heldItem.func_77978_p().func_74764_b("boundId") && Util.findPlayer(heldItem.func_77978_p().func_74779_i("boundId")) == player && this.complete(heldItem) && player.hasCapability(ExtendedPlayer.CAPABILITY, null) && temp != null) {
                EntityPlayer target;
                ItemStack offhand = player.func_184586_b(hand == EnumHand.MAIN_HAND ? EnumHand.OFF_HAND : EnumHand.MAIN_HAND);
                if (temp.isPositive()) {
                    ((ExtendedPlayer)player.getCapability(ExtendedPlayer.CAPABILITY, null)).addCurse(temp, 7);
                    if (!world.field_72995_K) {
                        for (int i = 0; i < 128; ++i) {
                            Bewitchment.network.sendTo((IMessage)new SpawnParticle(EnumParticleTypes.FLAME, player.field_70165_t + world.field_73012_v.nextGaussian() / 4.0, player.field_70163_u + 1.6, player.field_70161_v + world.field_73012_v.nextGaussian() / 4.0), (EntityPlayerMP)player);
                        }
                        player.func_184586_b(hand).func_190918_g(1);
                    }
                    return new ActionResult(EnumActionResult.PASS, (Object)ItemStack.field_190927_a);
                }
                if (offhand.func_77973_b() instanceof ItemTaglock && offhand.func_77942_o() && offhand.func_77978_p().func_74764_b("boundId") && (target = Util.findPlayer(offhand.func_77978_p().func_74779_i("boundId"))) != null && target.hasCapability(ExtendedPlayer.CAPABILITY, null)) {
                    ((ExtendedPlayer)target.getCapability(ExtendedPlayer.CAPABILITY, null)).addCurse(temp, 1);
                    player.func_184586_b(hand).func_190918_g(1);
                    return new ActionResult(EnumActionResult.PASS, (Object)ItemStack.field_190927_a);
                }
            }
        }
        return super.func_77659_a(world, player, hand);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (stack.func_77942_o()) {
            NBTTagCompound compound = stack.func_77978_p();
            if (compound.func_74764_b("contract")) {
                tooltip.add(TextFormatting.DARK_RED + I18n.func_135052_a((String)compound.func_74779_i("contract").replace(":", "."), (Object[])new Object[0]));
            }
            if (compound.func_74764_b("boundName")) {
                String boundName = compound.func_74779_i("boundName");
                tooltip.add(I18n.func_135052_a((String)"tooltip.bewitchment.contract_bound", (Object[])new Object[]{boundName}));
            }
            if (compound.func_74764_b("items")) {
                NBTTagList list = compound.func_150295_c("items", 10);
                for (int i = 0; i < list.func_74745_c(); ++i) {
                    NBTTagCompound tag = list.func_150305_b(i);
                    tooltip.add(I18n.func_135052_a((String)"tooltip.bewitchment.contract_items", (Object[])new Object[]{tag.func_74762_e("amountComplete"), tag.func_74762_e("amountTotal"), I18n.func_135052_a((String)(((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(tag.func_74779_i("item")))).func_77658_a() + ".name"), (Object[])new Object[0])}));
                }
            }
            if (compound.func_74764_b("mobsTotal") && compound.func_74764_b("mobsComplete") && compound.func_74764_b("contract")) {
                Contract temp = (Contract)GameRegistry.findRegistry(Curse.class).getValue(new ResourceLocation(stack.func_77978_p().func_74779_i("contract")));
                tooltip.add(I18n.func_135052_a((String)("tooltip." + temp.getRegistryName().toString().replace(":", ".") + "_entities"), (Object[])new Object[]{compound.func_74762_e("mobsComplete"), compound.func_74762_e("mobsTotal")}));
            }
        }
    }

    public boolean func_77636_d(ItemStack stack) {
        return this.complete(stack);
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return false;
    }
}

