/*
 * Decompiled with CFR 0.152.
 */
package net.flytre.biome_locator;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_1074;
import net.minecraft.class_156;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2385;
import net.minecraft.class_2960;

public class BiomeUtils {
    private static final Map<String, String> modNameCache = Maps.newHashMap();
    private static final Random RANDOM = new Random();

    public static class_1959 getBiome(class_2960 id, class_1937 world) {
        return (class_1959)world.method_30349().method_30530(class_2378.field_25114).method_10223(id);
    }

    public static class_2960 getId(class_1959 biome, class_1937 world) {
        return BiomeUtils.getRegistryKey(world).method_10221((Object)biome);
    }

    public static class_2960 getWorldId(class_1959 biome, class_1937 world) {
        return world.method_30349().method_30530(class_2378.field_25114).method_10221((Object)biome);
    }

    @Environment(value=EnvType.CLIENT)
    public static String getBiomeName(class_2960 biome) {
        return class_1074.method_4662((String)class_156.method_646((String)"biome", (class_2960)biome), (Object[])new Object[0]);
    }

    @Environment(value=EnvType.CLIENT)
    public static String getBiomeName(class_1959 biome, class_1937 world) {
        return class_1074.method_4662((String)class_156.method_646((String)"biome", (class_2960)BiomeUtils.getId(biome, world)), (Object[])new Object[0]);
    }

    public static String getMod(class_1959 biome, class_1937 world) {
        class_2960 id = BiomeUtils.getId(biome, world);
        return BiomeUtils.getModFromModId(id.method_12836());
    }

    public static String getModFromModId(String modid) {
        if (modid == null) {
            return "";
        }
        String any = modNameCache.getOrDefault(modid, null);
        if (any != null) {
            return any;
        }
        String s = FabricLoader.getInstance().getModContainer(modid).map(ModContainer::getMetadata).map(ModMetadata::getName).orElse(modid);
        modNameCache.put(modid, s);
        return s;
    }

    public static class_2385<class_1959> getRegistryKey(class_1937 world) {
        return world.method_30349().method_30530(class_2378.field_25114);
    }

    public static List<class_1959> getAllBiomes(class_1937 world) {
        return BiomeUtils.getRegistryKey(world).method_10220().filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static String translate(String type, class_2960 id) {
        return class_1074.method_4662((String)class_156.method_646((String)type, (class_2960)id), (Object[])new Object[0]);
    }
}

