/*
 * Decompiled with CFR 0.152.
 */
package net.flytre.biome_locator;

import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.flytre.biome_locator.BiomeUtils;
import net.flytre.biome_locator.LocatorItem;
import net.flytre.biome_locator.config.ConfigHandler;
import net.flytre.biome_locator.config.UILocation;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import net.minecraft.class_746;
import net.minecraft.class_918;

@Environment(value=EnvType.CLIENT)
public class HUD {
    private final class_310 client = class_310.method_1551();

    public HUD() {
        HudRenderCallback.EVENT.register((__, ___) -> this.render());
    }

    private void draw(class_327 renderer, class_4587 matrices, class_2561 text, float x, float y, int color, UILocation location) {
        if (this.isLeftAligned(location)) {
            renderer.method_30883(matrices, text, x, y, color);
        } else {
            int width = renderer.method_27525((class_5348)text);
            renderer.method_30883(matrices, text, x - (float)width, y, color);
        }
    }

    private boolean isLeftAligned(UILocation location) {
        return location == UILocation.TOP_LEFT || location == UILocation.BOTTOM_LEFT;
    }

    @Environment(value=EnvType.CLIENT)
    private void render() {
        class_746 player = this.client.field_1724;
        class_327 textRenderer = this.client.field_1772;
        class_4587 matrixStack = new class_4587();
        class_918 itemRenderer = this.client.method_1480();
        if (player == null) {
            return;
        }
        class_1799 stack = player.method_6079();
        if (!(stack.method_7909() instanceof LocatorItem)) {
            stack = player.method_6047();
        }
        if (!(stack.method_7909() instanceof LocatorItem)) {
            return;
        }
        int x = this.client.method_22683().method_4486();
        int y = this.client.method_22683().method_4502();
        Function<Integer, Integer> xPos = null;
        Function<Integer, Integer> yPos = null;
        UILocation location = ConfigHandler.CONFIG.getClient().getUiLocation();
        if (location == UILocation.TOP_LEFT) {
            xPos = i -> 10;
            yPos = i -> (i + 1) * 15 + (i % 2 == 0 ? -5 : -10);
        }
        if (location == UILocation.TOP_RIGHT) {
            xPos = i -> x - 10;
            yPos = i -> (i + 1) * 15 + (i % 2 == 0 ? -5 : -10);
        }
        if (location == UILocation.BOTTOM_LEFT) {
            xPos = i -> 10;
            yPos = i -> y - 130 + ((i + 1) * 15 + (i % 2 == 0 ? -5 : -10));
        }
        if (location == UILocation.BOTTOM_RIGHT) {
            xPos = i -> x - 10;
            yPos = i -> y - 130 + ((i + 1) * 15 + (i % 2 == 0 ? -5 : -10));
        }
        if (LocatorItem.hasPosition(stack)) {
            class_2338 pos = LocatorItem.getPosition(stack);
            if (pos.equals((Object)new class_2338(-1, -1, -1))) {
                this.draw(textRenderer, matrixStack, (class_2561)new class_2588("hud.biome_locator.status"), xPos.apply(0).intValue(), yPos.apply(0).intValue(), -1, location);
                this.draw(textRenderer, matrixStack, (class_2561)new class_2588("hud.biome_locator.searching"), xPos.apply(1).intValue(), yPos.apply(1).intValue(), -10724260, location);
            } else if (pos.equals((Object)new class_2338(-11, -11, -11))) {
                this.draw(textRenderer, matrixStack, (class_2561)new class_2588("hud.biome_locator.status"), xPos.apply(0).intValue(), yPos.apply(0).intValue(), -1, location);
                this.draw(textRenderer, matrixStack, (class_2561)new class_2588("hud.biome_locator.not_found"), xPos.apply(1).intValue(), yPos.apply(1).intValue(), -10724260, location);
            } else {
                this.draw(textRenderer, matrixStack, (class_2561)new class_2588("hud.biome_locator.status"), xPos.apply(0).intValue(), yPos.apply(0).intValue(), -1, location);
                this.draw(textRenderer, matrixStack, (class_2561)new class_2588("hud.biome_locator.found"), xPos.apply(1).intValue(), yPos.apply(1).intValue(), -10724260, location);
                this.draw(textRenderer, matrixStack, (class_2561)new class_2588("hud.biome_locator.biome"), xPos.apply(2).intValue(), yPos.apply(2).intValue(), -1, location);
                class_2960 biome = LocatorItem.getBiome(stack);
                this.draw(textRenderer, matrixStack, class_2561.method_30163((String)(biome == null ? "Error" : BiomeUtils.getBiomeName(biome))), xPos.apply(3).intValue(), yPos.apply(3).intValue(), -10724260, location);
                String formattedCoords = pos.method_10263() + ", " + pos.method_10260();
                this.draw(textRenderer, matrixStack, (class_2561)new class_2588("hud.biome_locator.coordinates"), xPos.apply(4).intValue(), yPos.apply(4).intValue(), -1, location);
                this.draw(textRenderer, matrixStack, class_2561.method_30163((String)formattedCoords), xPos.apply(5).intValue(), yPos.apply(5).intValue(), -10724260, location);
                this.draw(textRenderer, matrixStack, (class_2561)new class_2588("hud.biome_locator.distance"), xPos.apply(6).intValue(), yPos.apply(6).intValue(), -1, location);
                int distance = (int)Math.sqrt(pos.method_10268(player.method_23317(), (double)pos.method_10264(), player.method_23321(), false));
                class_1959 pBiome = this.client.field_1687.method_23753(player.method_24515());
                class_2960 playerBiome = BiomeUtils.getWorldId(pBiome, (class_1937)this.client.field_1687);
                if (playerBiome.equals((Object)biome)) {
                    this.draw(textRenderer, matrixStack, (class_2561)new class_2588("hud.biome_locator.reached"), xPos.apply(7).intValue(), yPos.apply(7).intValue(), -10724260, location);
                } else {
                    this.draw(textRenderer, matrixStack, class_2561.method_30163((String)("" + distance)), xPos.apply(7).intValue(), yPos.apply(7).intValue(), -10724260, location);
                }
            }
        }
    }
}

