/*
 * Decompiled with CFR 0.152.
 */
package net.flytre.biome_locator.client;

import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.flytre.biome_locator.BiomeDataFetcher;
import net.flytre.biome_locator.BiomeLocator;
import net.flytre.biome_locator.BiomeUtils;
import net.flytre.biome_locator.GiantBiomePacket;
import net.flytre.biome_locator.HUD;
import net.flytre.biome_locator.LocatorItem;
import net.flytre.biome_locator.client.screen.BiomeSelectionScreen;
import net.flytre.biome_locator.client.screen.BiomeStatDisplay;
import net.flytre.biome_locator.mixin.ModelPredicateProviderRegistryMixin;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1533;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1800;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class BiomeLocatorClient
implements ClientModInitializer {
    private HUD hud;

    public void onInitializeClient() {
        ModelPredicateProviderRegistryMixin.register(BiomeLocator.BIOME_LOCATOR, new class_2960("angle"), new class_1800(){
            private final AngleInterpolator value = new AngleInterpolator();
            private final AngleInterpolator speed = new AngleInterpolator();

            public float call(class_1799 itemStack, @Nullable class_638 clientWorld, @Nullable class_1309 livingEntity) {
                class_1309 entity;
                Object object = entity = livingEntity != null ? livingEntity : itemStack.method_27319();
                if (entity == null) {
                    return 0.0f;
                }
                if (clientWorld == null && entity.field_6002 instanceof class_638) {
                    clientWorld = (class_638)entity.field_6002;
                }
                class_2338 blockPos = LocatorItem.hasPosition(itemStack) ? LocatorItem.getPosition(itemStack) : this.getSpawnPos(clientWorld);
                long l = clientWorld.method_8510();
                if (blockPos != null && !(entity.method_19538().method_1028((double)blockPos.method_10263() + 0.5, entity.method_19538().method_10214(), (double)blockPos.method_10260() + 0.5) < (double)1.0E-5f)) {
                    double h;
                    boolean bl = livingEntity instanceof class_1657 && ((class_1657)livingEntity).method_7340();
                    double e = 0.0;
                    if (bl) {
                        e = livingEntity.field_6031;
                    } else if (entity instanceof class_1533) {
                        e = this.getItemFrameAngleOffset((class_1533)entity);
                    } else if (entity instanceof class_1542) {
                        e = 180.0f - ((class_1542)entity).method_27314(0.5f) / ((float)Math.PI * 2) * 360.0f;
                    } else if (livingEntity != null) {
                        e = livingEntity.field_6283;
                    }
                    e = class_3532.method_15367((double)(e / 360.0), (double)1.0);
                    double f = this.getAngleToPos(class_243.method_24953((class_2382)blockPos), (class_1297)entity) / 6.2831854820251465;
                    if (bl) {
                        if (this.value.shouldUpdate(l)) {
                            this.value.update(l, 0.5 - (e - 0.25));
                        }
                        h = f + this.value.value;
                    } else {
                        h = 0.5 - (e - 0.25 - f);
                    }
                    return class_3532.method_15341((float)((float)h), (float)1.0f);
                }
                if (this.speed.shouldUpdate(l)) {
                    this.speed.update(l, Math.random());
                }
                double d = this.speed.value + (double)((float)itemStack.hashCode() / 2.1474836E9f);
                return class_3532.method_15341((float)((float)d), (float)1.0f);
            }

            @Nullable
            private class_2338 getSpawnPos(class_638 world) {
                return world.method_8597().method_28537() ? world.method_27874() : null;
            }

            private double getItemFrameAngleOffset(class_1533 itemFrame) {
                class_2350 direction = itemFrame.method_5735();
                int i = direction.method_10166().method_10178() ? 90 * direction.method_10171().method_10181() : 0;
                return class_3532.method_15392((int)(180 + direction.method_10161() * 90 + itemFrame.method_6934() * 45 + i));
            }

            private double getAngleToPos(class_243 pos, class_1297 entity) {
                return Math.atan2(pos.method_10215() - entity.method_23321(), pos.method_10216() - entity.method_23317());
            }
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)BiomeLocator.OPEN_UI_PACKET, (client, handler, buf, responseSender) -> {
            class_310 mc = class_310.method_1551();
            class_746 player = mc.field_1724;
            client.execute(() -> BiomeLocatorClient.lambda$onInitializeClient$0((class_1657)player, mc));
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)GiantBiomePacket.PACKET_ID, (client, handler, buf, responseSender) -> {
            GiantBiomePacket packet = GiantBiomePacket.fromPacket(buf);
            client.execute(() -> {
                BiomeDataFetcher.mobs = packet.getMobs();
                BiomeDataFetcher.blocks = packet.getBlocks();
            });
        });
        this.hud = new HUD();
    }

    private static /* synthetic */ void lambda$onInitializeClient$0(class_1657 player, class_310 mc) {
        if (player.method_5715()) {
            BiomeSelectionScreen selectionScreen = new BiomeSelectionScreen(player.field_6002);
            class_1959 biome = class_310.method_1551().field_1687.method_23753(player.method_24515());
            class_2960 id = BiomeUtils.getWorldId(biome, player.field_6002);
            class_1959 exact = BiomeUtils.getBiome(id, player.field_6002);
            mc.method_1507((class_437)new BiomeStatDisplay(selectionScreen, exact));
        } else {
            mc.method_1507((class_437)new BiomeSelectionScreen(player.field_6002));
        }
        BiomeDataFetcher.requestCacheIfNeeded();
    }

    @Environment(value=EnvType.CLIENT)
    static class AngleInterpolator {
        private double value;
        private double speed;
        private long lastUpdateTime;

        private AngleInterpolator() {
        }

        private boolean shouldUpdate(long time) {
            return this.lastUpdateTime != time;
        }

        private void update(long time, double d) {
            this.lastUpdateTime = time;
            double e = d - this.value;
            e = class_3532.method_15367((double)(e + 0.5), (double)1.0) - 0.5;
            this.speed += e * 0.1;
            this.speed *= 0.8;
            this.value = class_3532.method_15367((double)(this.value + this.speed), (double)1.0);
        }
    }
}

