/*
 * Decompiled with CFR 0.152.
 */
package net.flytre.biome_locator.client.screen;

import java.util.Objects;
import net.flytre.biome_locator.BiomeUtils;
import net.flytre.biome_locator.client.screen.BiomeList;
import net.flytre.biome_locator.client.screen.BiomeSelectionScreen;
import net.minecraft.class_156;
import net.minecraft.class_1959;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_350;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_5348;

public class BiomeEntry
extends class_350.class_351<BiomeEntry> {
    protected final class_310 client;
    protected final BiomeSelectionScreen selectionScreen;
    protected final class_1959 biome;
    protected final BiomeList biomesList;
    protected long lastClickTime;

    public BiomeEntry(BiomeList biomesList, class_1959 biome) {
        this.biomesList = biomesList;
        this.biome = biome;
        this.selectionScreen = biomesList.getSelectionScreen();
        this.client = class_310.method_1551();
    }

    public void method_25343(class_4587 matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
        class_5250 precipitation;
        switch (this.biome.method_8694()) {
            case field_9382: {
                precipitation = new class_2588("weather.biome_locator.rain").method_10862(class_2583.field_24360.method_27703(class_5251.method_27717((int)-16758337)));
                break;
            }
            case field_9383: {
                precipitation = new class_2588("weather.biome_locator.snow").method_10862(class_2583.field_24360.method_27703(class_5251.method_27717((int)-4210753)));
                break;
            }
            default: {
                precipitation = new class_2588("weather.biome_locator.none").method_10862(class_2583.field_24360.method_27703(class_5251.method_27717((int)-11579569)));
            }
        }
        class_5250 temperature = (double)this.biome.method_8712() <= 0.5 ? new class_2588("temperature.biome_locator.cold").method_10862(class_2583.field_24360.method_27703(class_5251.method_27717((int)-4210753))) : ((double)this.biome.method_8712() <= 1.5 ? new class_2588("temperature.biome_locator.medium").method_10862(class_2583.field_24360.method_27703(class_5251.method_27717((int)-11579569))) : new class_2588("temperature.biome_locator.warm").method_10862(class_2583.field_24360.method_27703(class_5251.method_27717((int)-3898624))));
        class_327 textRenderer = this.client.field_1772;
        class_5251 color = this.biome.method_8688() == class_1959.class_1961.field_9367 ? class_5251.method_27717((int)this.biome.method_8687()) : (this.biome.method_8688() == class_1959.class_1961.field_9366 || this.biome.method_8688() == class_1959.class_1961.field_9360 || this.biome.method_8688() == class_1959.class_1961.field_9362 ? class_5251.method_27717((int)this.biome.method_24376()) : class_5251.method_27717((int)this.biome.method_8698()));
        class_5250 name = new class_2585(BiomeUtils.getBiomeName(this.biome, this.selectionScreen.world)).method_10862(class_2583.field_24360.method_27703(color));
        class_5250 src = new class_2585(BiomeUtils.getMod(this.biome, this.selectionScreen.world)).method_10862(class_2583.field_24360.method_27703(class_5251.method_27717((int)0x665555FF)).method_10978(Boolean.valueOf(true)));
        Objects.requireNonNull(textRenderer);
        double height = 9.0;
        double requiredHeight = height * 4.0 + 6.0;
        double start = ((double)(entryHeight + 4) - requiredHeight) / 2.0;
        this.drawCenteredText(matrices, (class_2561)name, 0.5f, (int)((double)y + start), 0xFFFFFF);
        double d = (double)y + start;
        Objects.requireNonNull(textRenderer);
        this.drawCenteredText(matrices, (class_2561)temperature, 0.5f, (int)(d + 9.0 + 2.0), 0x808080);
        double d2 = (double)y + start;
        Objects.requireNonNull(textRenderer);
        this.drawCenteredText(matrices, (class_2561)precipitation, 0.5f, (int)(d2 + (double)(9 * 2) + 4.0), 0x808080);
        double d3 = (double)y + start;
        Objects.requireNonNull(textRenderer);
        this.drawCenteredText(matrices, (class_2561)src, 0.5f, (int)(d3 + (double)(9 * 3) + 6.0), 0x808080);
    }

    protected void drawCenteredText(class_4587 matrixStack, class_2561 text, float percent, int y, int color) {
        float baseX = (float)this.selectionScreen.field_22789 / (1.0f / percent);
        this.client.field_1772.method_30883(matrixStack, text, baseX - (float)this.client.field_1772.method_27525((class_5348)text) / 2.0f, (float)y, color);
    }

    public class_1959 getBiome() {
        return this.biome;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.biomesList.selectBiome(this);
            if (class_156.method_658() - this.lastClickTime < 250L) {
                this.selectionScreen.search(this.biome);
                return true;
            }
            this.lastClickTime = class_156.method_658();
            return false;
        }
        return false;
    }
}

