/*
 * Decompiled with CFR 0.152.
 */
package net.flytre.biome_locator.client.screen;

import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.flytre.biome_locator.BiomeDataFetcher;
import net.flytre.biome_locator.BiomeLocator;
import net.flytre.biome_locator.BiomeUtils;
import net.flytre.biome_locator.client.screen.BiomeEntry;
import net.flytre.biome_locator.client.screen.BiomeList;
import net.flytre.biome_locator.client.screen.BiomeStatDisplay;
import net.flytre.biome_locator.client.screen.FancyButton;
import net.flytre.biome_locator.client.screen.SearchType;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_437;
import net.minecraft.class_4587;

public class BiomeSelectionScreen
extends class_437 {
    public final class_1937 world;
    private final List<class_1959> allowedBiomes;
    private List<class_1959> biomesMatchingSearch;
    private FancyButton startSearchButton;
    private FancyButton cancelButton;
    private FancyButton infoButton;
    private class_342 searchTextField;
    private BiomeList selectionList;
    private FancyButton searchModeButton;
    public SearchType searchType;

    public BiomeSelectionScreen(class_1937 world) {
        super((class_2561)new class_2588("item.biome_locator.compass"));
        this.world = world;
        this.allowedBiomes = BiomeUtils.getAllBiomes(world);
        this.biomesMatchingSearch = new ArrayList<class_1959>(this.allowedBiomes);
        this.searchType = SearchType.NAME;
    }

    public BiomeList getSelectionList() {
        return this.selectionList;
    }

    public void search(class_1959 biome) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.method_10812(BiomeUtils.getId(biome, this.world));
        ClientPlayNetworking.send((class_2960)BiomeLocator.SEARCH_BIOME_PACKET, (class_2540)buf);
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        this.method_25420(matrices);
        this.selectionList.method_25394(matrices, mouseX, mouseY, delta);
        this.searchTextField.method_25394(matrices, mouseX, mouseY, delta);
        super.method_25394(matrices, mouseX, mouseY, delta);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        boolean superValue = super.method_25404(keyCode, scanCode, modifiers);
        if (this.searchTextField.method_25370()) {
            this.updateSearch();
            return true;
        }
        return superValue;
    }

    public boolean method_25400(char typedChar, int keyCode) {
        boolean superValue = super.method_25400(typedChar, keyCode);
        if (this.searchTextField.method_25370()) {
            this.updateSearch();
            return true;
        }
        return superValue;
    }

    public void method_25419() {
        super.method_25419();
        this.field_22787.field_1774.method_1462(false);
    }

    public void selectBiome(BiomeEntry entry) {
        this.startSearchButton.field_22763 = entry != null;
        this.infoButton.field_22763 = entry != null && this.searchModeButton.field_22763;
    }

    public boolean method_25421() {
        return false;
    }

    public void updateSearch() {
        this.biomesMatchingSearch = new ArrayList<class_1959>();
        for (class_1959 biome : this.allowedBiomes) {
            if (this.searchType == SearchType.NAME) {
                if (!BiomeUtils.getBiomeName(biome, this.world).toLowerCase().contains(this.searchTextField.method_1882().toLowerCase())) continue;
                this.biomesMatchingSearch.add(biome);
                continue;
            }
            if (this.searchType != SearchType.RESOURCE || !BiomeDataFetcher.hasResource(this.searchTextField.method_1882().toLowerCase(), biome, this.world)) continue;
            this.biomesMatchingSearch.add(biome);
        }
        this.selectionList.refreshList();
    }

    public String getSearch() {
        return this.searchTextField.method_1882();
    }

    public List<class_1959> sortBiomes() {
        List<class_1959> biomes = this.biomesMatchingSearch;
        biomes.sort(Comparator.comparing(biome -> BiomeUtils.getBiomeName(biome, this.world)));
        return biomes;
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        return this.selectionList.method_25401(mouseX, mouseY, amount);
    }

    public void method_25393() {
        this.searchTextField.method_1865();
        this.searchModeButton.field_22763 = BiomeDataFetcher.blocks.size() > 0 || BiomeDataFetcher.mobs.size() > 0;
    }

    protected void method_25426() {
        this.field_22787.field_1774.method_1462(true);
        this.field_22791.clear();
        this.cancelButton = (FancyButton)this.method_25411((class_339)new FancyButton(10, this.field_22790 - 30, 110, 20, (class_2561)new class_2588("gui.cancel"), onPress -> this.field_22787.method_1507(null)));
        this.startSearchButton = (FancyButton)this.method_25411((class_339)new FancyButton(this.field_22789 - 140, this.field_22790 - 30, 110, 20, (class_2561)new class_2588("gui.biome_locator.search"), onPress -> {
            if (this.selectionList.hasSelection()) {
                class_1959 biome = ((BiomeEntry)this.selectionList.method_25334()).getBiome();
                if (biome != null) {
                    this.search(biome);
                }
                this.field_22787.method_1507(null);
            }
        }));
        this.infoButton = (FancyButton)this.method_25411((class_339)new FancyButton(this.field_22789 - 140, this.field_22790 - 60, 110, 20, (class_2561)new class_2588("gui.biome_locator.info"), onPress -> {
            if (this.selectionList.hasSelection()) {
                class_310.method_1551().method_1507((class_437)new BiomeStatDisplay(this, ((BiomeEntry)this.selectionList.method_25334()).getBiome()));
            }
        }));
        this.searchModeButton = (FancyButton)this.method_25411((class_339)new FancyButton(10, this.field_22790 - 60, 110, 20, (class_2561)new class_2588(this.searchType == SearchType.NAME ? "gui.biome_locator.searchType.name" : "gui.biome_locator.searchType.resource"), onPress -> {
            if (this.searchType == SearchType.NAME) {
                this.searchType = SearchType.RESOURCE;
                onPress.method_25355((class_2561)new class_2588("gui.biome_locator.searchType.resource"));
            } else {
                this.searchType = SearchType.NAME;
                onPress.method_25355((class_2561)new class_2588("gui.biome_locator.searchType.name"));
            }
            this.updateSearch();
        }));
        this.startSearchButton.field_22763 = false;
        this.infoButton.field_22763 = false;
        this.searchTextField = new class_342(this.field_22793, (this.field_22789 - 140) / 2, 10, 140, 20, (class_2561)new class_2588("gui.biome_locator.search"));
        this.field_22786.add(this.searchTextField);
        if (this.selectionList == null) {
            this.selectionList = new BiomeList(this, this.field_22787, this.field_22789, this.field_22790, 60, this.field_22790 - 20, 50);
        }
        this.field_22786.add(this.selectionList);
        this.selectionList.refreshList();
    }
}

