/*
 * Decompiled with CFR 0.152.
 */
package net.flytre.biome_locator.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.fabricmc.loader.api.FabricLoader;
import net.flytre.biome_locator.config.Config;
import net.flytre.biome_locator.config.UILocation;

public class ConfigHandler {
    private static final Config DEFAULT;
    private static final Gson GSON;
    public static Config CONFIG;

    public static void handleConfig() {
        Path location = FabricLoader.getInstance().getConfigDir();
        File config = location.toFile();
        File configFile = null;
        for (File file : config.listFiles()) {
            if (!file.getName().equals("biome_locator.json")) continue;
            configFile = file;
            break;
        }
        if (configFile == null) {
            Path path = Paths.get(location.toString(), "biome_locator.json");
            try {
                FileWriter writer = new FileWriter(path.toFile());
                GSON.toJson((Object)DEFAULT, (Appendable)writer);
                ((Writer)writer).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            try (FileReader reader = new FileReader(configFile);){
                CONFIG = (Config)GSON.fromJson((Reader)reader, Config.class);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    static {
        CONFIG = null;
        DEFAULT = new Config(new Config.ClientConfig(UILocation.TOP_LEFT), new Config.ServerConfig(6400));
        GSON = new GsonBuilder().setPrettyPrinting().create();
    }
}

