/*
 * Decompiled with CFR 0.152.
 */
package com.imwindow.buildersplus.blocks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;

public class PillarBlock
extends Block {
    public static final BooleanProperty UP = BooleanProperty.func_177716_a((String)"up");
    public static final BooleanProperty DOWN = BooleanProperty.func_177716_a((String)"down");
    public final ImmutableMap<BlockState, VoxelShape> SHAPES;

    public PillarBlock(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((IProperty)UP, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)DOWN, (Comparable)Boolean.valueOf(false)));
        this.SHAPES = this.generateShapes((ImmutableList<BlockState>)this.func_176194_O().func_177619_a());
    }

    private ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape CENTER = Block.func_208617_a((double)1.5, (double)0.0, (double)1.5, (double)14.5, (double)16.0, (double)14.5);
        VoxelShape BOTTOM = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0);
        VoxelShape TOP = Block.func_208617_a((double)0.0, (double)10.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BlockState state : states) {
            boolean up = (Boolean)state.func_177229_b((IProperty)UP);
            boolean down = (Boolean)state.func_177229_b((IProperty)DOWN);
            ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
            shapes.add(CENTER);
            if (!up & !down) {
                shapes.add(BOTTOM);
                shapes.add(TOP);
            } else if (up & !down) {
                shapes.add(BOTTOM);
            } else if (!up) {
                shapes.add(TOP);
            } else {
                shapes.add(CENTER);
            }
            builder.put((Object)state, (Object)PillarBlock.combine(shapes));
        }
        return builder.build();
    }

    public static VoxelShape combine(Collection<VoxelShape> shapes) {
        VoxelShape empty = VoxelShapes.func_197880_a();
        for (VoxelShape shape : shapes) {
            empty = VoxelShapes.func_197882_b((VoxelShape)empty, (VoxelShape)shape, (IBooleanFunction)IBooleanFunction.field_223244_o_);
        }
        return empty.func_197753_c();
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader reader, BlockPos pos, ISelectionContext context) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader reader, BlockPos pos, ISelectionContext context) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        boolean up = worldIn.func_180495_p(currentPos.func_177984_a()).func_177230_c() == this;
        boolean down = worldIn.func_180495_p(currentPos.func_177977_b()).func_177230_c() == this;
        return (BlockState)((BlockState)stateIn.func_206870_a((IProperty)UP, (Comparable)Boolean.valueOf(up))).func_206870_a((IProperty)DOWN, (Comparable)Boolean.valueOf(down));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new IProperty[]{UP, DOWN});
    }

    public static class Flammable
    extends PillarBlock {
        public Flammable(Block.Properties properties) {
            super(properties);
        }

        public boolean isFlammable(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
            return true;
        }

        public int getFlammability(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
            return 25;
        }

        public int getFireSpreadSpeed(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
            return 150;
        }
    }
}

