/*
 * Decompiled with CFR 0.152.
 */
package com.imwindow.buildersplus.blocks;

import java.util.Random;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.Half;
import net.minecraft.state.properties.StairsShape;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class QStairsBlock
extends Block
implements IWaterLoggable {
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    public static final EnumProperty<Half> HALF = BlockStateProperties.field_208164_Q;
    public static final EnumProperty<StairsShape> SHAPE = BlockStateProperties.field_208146_au;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    protected static final VoxelShape AABB_SLAB_TOP = Block.func_208617_a((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape AABB_SLAB_BOTTOM = VoxelShapes.func_197878_a((VoxelShape)Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), (VoxelShape)Block.func_208617_a((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0), (IBooleanFunction)IBooleanFunction.field_223244_o_);
    protected static final VoxelShape NWD_CORNER = Stream.of(Block.func_208617_a((double)0.0, (double)8.0, (double)0.0, (double)12.0, (double)12.0, (double)12.0), Block.func_208617_a((double)0.0, (double)4.0, (double)0.0, (double)8.0, (double)8.0, (double)8.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)4.0, (double)4.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    protected static final VoxelShape SWD_CORNER = Stream.of(Block.func_208617_a((double)0.0, (double)8.0, (double)4.0, (double)12.0, (double)12.0, (double)16.0), Block.func_208617_a((double)0.0, (double)4.0, (double)8.0, (double)8.0, (double)8.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)12.0, (double)4.0, (double)4.0, (double)16.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    protected static final VoxelShape NWU_CORNER = Stream.of(Block.func_208617_a((double)0.0, (double)12.0, (double)0.0, (double)4.0, (double)16.0, (double)4.0), Block.func_208617_a((double)0.0, (double)8.0, (double)0.0, (double)8.0, (double)12.0, (double)8.0), Block.func_208617_a((double)0.0, (double)4.0, (double)0.0, (double)12.0, (double)8.0, (double)12.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    protected static final VoxelShape SWU_CORNER = Stream.of(Block.func_208617_a((double)0.0, (double)4.0, (double)4.0, (double)12.0, (double)8.0, (double)16.0), Block.func_208617_a((double)0.0, (double)8.0, (double)8.0, (double)8.0, (double)12.0, (double)16.0), Block.func_208617_a((double)0.0, (double)12.0, (double)12.0, (double)4.0, (double)16.0, (double)16.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    protected static final VoxelShape NED_CORNER = Stream.of(Block.func_208617_a((double)4.0, (double)8.0, (double)0.0, (double)16.0, (double)12.0, (double)12.0), Block.func_208617_a((double)8.0, (double)4.0, (double)0.0, (double)16.0, (double)8.0, (double)8.0), Block.func_208617_a((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)4.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    protected static final VoxelShape SED_CORNER = Stream.of(Block.func_208617_a((double)4.0, (double)8.0, (double)4.0, (double)16.0, (double)12.0, (double)16.0), Block.func_208617_a((double)8.0, (double)4.0, (double)8.0, (double)16.0, (double)8.0, (double)16.0), Block.func_208617_a((double)12.0, (double)0.0, (double)12.0, (double)16.0, (double)4.0, (double)16.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    protected static final VoxelShape NEU_CORNER = Stream.of(Block.func_208617_a((double)4.0, (double)4.0, (double)0.0, (double)16.0, (double)8.0, (double)12.0), Block.func_208617_a((double)8.0, (double)8.0, (double)0.0, (double)16.0, (double)12.0, (double)8.0), Block.func_208617_a((double)12.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    protected static final VoxelShape SEU_CORNER = Stream.of(Block.func_208617_a((double)4.0, (double)4.0, (double)4.0, (double)16.0, (double)8.0, (double)16.0), Block.func_208617_a((double)8.0, (double)8.0, (double)8.0, (double)16.0, (double)12.0, (double)16.0), Block.func_208617_a((double)12.0, (double)12.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    protected static final VoxelShape NORTH = Stream.of(Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), Block.func_208617_a((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)8.0, (double)12.0), Block.func_208617_a((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)12.0, (double)8.0), Block.func_208617_a((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    protected static final VoxelShape EAST = Stream.of(Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), Block.func_208617_a((double)4.0, (double)4.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), Block.func_208617_a((double)8.0, (double)8.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), Block.func_208617_a((double)12.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    protected static final VoxelShape SOUTH = Stream.of(Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), Block.func_208617_a((double)0.0, (double)4.0, (double)4.0, (double)16.0, (double)8.0, (double)16.0), Block.func_208617_a((double)0.0, (double)8.0, (double)8.0, (double)16.0, (double)12.0, (double)16.0), Block.func_208617_a((double)0.0, (double)12.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    protected static final VoxelShape WEST = Stream.of(Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), Block.func_208617_a((double)0.0, (double)4.0, (double)0.0, (double)12.0, (double)8.0, (double)16.0), Block.func_208617_a((double)0.0, (double)8.0, (double)0.0, (double)8.0, (double)12.0, (double)16.0), Block.func_208617_a((double)0.0, (double)12.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    protected static final VoxelShape WESTUP = Stream.of(Block.func_208617_a((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.func_208617_a((double)0.0, (double)8.0, (double)0.0, (double)12.0, (double)12.0, (double)16.0), Block.func_208617_a((double)0.0, (double)4.0, (double)0.0, (double)8.0, (double)8.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)4.0, (double)16.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    protected static final VoxelShape NORTHUP = Stream.of(Block.func_208617_a((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.func_208617_a((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)12.0, (double)12.0), Block.func_208617_a((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)8.0, (double)8.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)4.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    protected static final VoxelShape EASTUP = Stream.of(Block.func_208617_a((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.func_208617_a((double)4.0, (double)8.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), Block.func_208617_a((double)8.0, (double)4.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), Block.func_208617_a((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    protected static final VoxelShape SOUTHUP = Stream.of(Block.func_208617_a((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.func_208617_a((double)0.0, (double)8.0, (double)4.0, (double)16.0, (double)12.0, (double)16.0), Block.func_208617_a((double)0.0, (double)4.0, (double)8.0, (double)16.0, (double)8.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)4.0, (double)16.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    protected static final VoxelShape NEU_INNER = Stream.of(Block.func_208617_a((double)12.0, (double)12.0, (double)4.0, (double)16.0, (double)16.0, (double)16.0), Block.func_208617_a((double)8.0, (double)8.0, (double)8.0, (double)16.0, (double)12.0, (double)16.0), Block.func_208617_a((double)4.0, (double)4.0, (double)12.0, (double)16.0, (double)8.0, (double)16.0), Block.func_208617_a((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0), Block.func_208617_a((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)12.0, (double)8.0), Block.func_208617_a((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)8.0, (double)12.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    protected static final VoxelShape NED_INNER = Stream.of(Block.func_208617_a((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.func_208617_a((double)4.0, (double)8.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), Block.func_208617_a((double)8.0, (double)4.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), Block.func_208617_a((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), Block.func_208617_a((double)0.0, (double)8.0, (double)0.0, (double)4.0, (double)12.0, (double)12.0), Block.func_208617_a((double)0.0, (double)4.0, (double)0.0, (double)8.0, (double)8.0, (double)8.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)12.0, (double)4.0, (double)4.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    protected static final VoxelShape NWU_INNER = Stream.of(Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), Block.func_208617_a((double)0.0, (double)4.0, (double)0.0, (double)12.0, (double)8.0, (double)16.0), Block.func_208617_a((double)0.0, (double)8.0, (double)0.0, (double)8.0, (double)12.0, (double)16.0), Block.func_208617_a((double)0.0, (double)12.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0), Block.func_208617_a((double)12.0, (double)4.0, (double)0.0, (double)16.0, (double)8.0, (double)12.0), Block.func_208617_a((double)8.0, (double)8.0, (double)0.0, (double)16.0, (double)12.0, (double)8.0), Block.func_208617_a((double)4.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    protected static final VoxelShape NWD_INNER = Stream.of(Block.func_208617_a((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.func_208617_a((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)12.0, (double)12.0), Block.func_208617_a((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)8.0, (double)8.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)4.0), Block.func_208617_a((double)0.0, (double)8.0, (double)12.0, (double)12.0, (double)12.0, (double)16.0), Block.func_208617_a((double)0.0, (double)4.0, (double)8.0, (double)8.0, (double)8.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)4.0, (double)4.0, (double)4.0, (double)16.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    protected static final VoxelShape SED_INNER = Stream.of(Block.func_208617_a((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.func_208617_a((double)0.0, (double)8.0, (double)4.0, (double)16.0, (double)12.0, (double)16.0), Block.func_208617_a((double)0.0, (double)4.0, (double)8.0, (double)16.0, (double)8.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)4.0, (double)16.0), Block.func_208617_a((double)4.0, (double)8.0, (double)0.0, (double)16.0, (double)12.0, (double)4.0), Block.func_208617_a((double)8.0, (double)4.0, (double)0.0, (double)16.0, (double)8.0, (double)8.0), Block.func_208617_a((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)12.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    protected static final VoxelShape SEU_INNER = Stream.of(Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), Block.func_208617_a((double)4.0, (double)4.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), Block.func_208617_a((double)0.0, (double)4.0, (double)4.0, (double)4.0, (double)8.0, (double)16.0), Block.func_208617_a((double)8.0, (double)8.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), Block.func_208617_a((double)0.0, (double)8.0, (double)8.0, (double)8.0, (double)12.0, (double)16.0), Block.func_208617_a((double)12.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.func_208617_a((double)0.0, (double)12.0, (double)12.0, (double)12.0, (double)16.0, (double)16.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    protected static final VoxelShape SWD_INNER = Stream.of(Block.func_208617_a((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.func_208617_a((double)0.0, (double)8.0, (double)0.0, (double)12.0, (double)12.0, (double)16.0), Block.func_208617_a((double)0.0, (double)4.0, (double)0.0, (double)8.0, (double)8.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)4.0, (double)16.0), Block.func_208617_a((double)12.0, (double)8.0, (double)4.0, (double)16.0, (double)12.0, (double)16.0), Block.func_208617_a((double)8.0, (double)4.0, (double)8.0, (double)16.0, (double)8.0, (double)16.0), Block.func_208617_a((double)4.0, (double)0.0, (double)12.0, (double)16.0, (double)4.0, (double)16.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    protected static final VoxelShape SWU_INNER = Stream.of(Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), Block.func_208617_a((double)0.0, (double)4.0, (double)4.0, (double)16.0, (double)8.0, (double)16.0), Block.func_208617_a((double)0.0, (double)4.0, (double)0.0, (double)12.0, (double)8.0, (double)4.0), Block.func_208617_a((double)0.0, (double)8.0, (double)8.0, (double)16.0, (double)12.0, (double)16.0), Block.func_208617_a((double)0.0, (double)8.0, (double)0.0, (double)8.0, (double)12.0, (double)8.0), Block.func_208617_a((double)0.0, (double)12.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0), Block.func_208617_a((double)0.0, (double)12.0, (double)0.0, (double)4.0, (double)16.0, (double)12.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    protected static final VoxelShape[] SLAB_TOP_SHAPES = QStairsBlock.makeShapes(AABB_SLAB_TOP, NWD_CORNER, NED_CORNER, SWD_CORNER, SED_CORNER, NORTHUP, EASTUP, SOUTHUP, WESTUP, NWD_INNER, NED_INNER, SWD_INNER, SED_INNER);
    protected static final VoxelShape[] SLAB_BOTTOM_SHAPES = QStairsBlock.makeShapes(AABB_SLAB_BOTTOM, NWU_CORNER, NEU_CORNER, SWU_CORNER, SEU_CORNER, NORTH, EAST, SOUTH, WEST, NWU_INNER, NEU_INNER, SWU_INNER, SEU_INNER);
    private static final int[] field_196522_K = new int[]{12, 5, 3, 10, 14, 13, 7, 11, 13, 7, 11, 14, 8, 4, 1, 2, 4, 1, 2, 8};
    private final Block modelBlock;
    private final BlockState modelState;
    private final Supplier<BlockState> stateSupplier;

    private static VoxelShape[] makeShapes(VoxelShape slabShape, VoxelShape nwCorner, VoxelShape neCorner, VoxelShape swCorner, VoxelShape seCorner, VoxelShape north, VoxelShape east, VoxelShape south, VoxelShape west, VoxelShape nwInner, VoxelShape neInner, VoxelShape swInner, VoxelShape seInner) {
        return (VoxelShape[])IntStream.range(0, 16).mapToObj(p_199780_5_ -> QStairsBlock.combineShapes(p_199780_5_, slabShape, nwCorner, neCorner, swCorner, seCorner, north, east, south, west, nwInner, neInner, swInner, seInner)).toArray(VoxelShape[]::new);
    }

    private static VoxelShape combineShapes(int bitfield, VoxelShape slabShape, VoxelShape nwCorner, VoxelShape neCorner, VoxelShape swCorner, VoxelShape seCorner, VoxelShape north, VoxelShape east, VoxelShape south, VoxelShape west, VoxelShape nwInner, VoxelShape neInner, VoxelShape swInner, VoxelShape seInner) {
        VoxelShape voxelshape = slabShape;
        if ((bitfield & 1) == 1) {
            voxelshape = VoxelShapes.func_197872_a((VoxelShape)slabShape, (VoxelShape)nwCorner);
        }
        if ((bitfield & 2) == 2) {
            voxelshape = VoxelShapes.func_197872_a((VoxelShape)voxelshape, (VoxelShape)neCorner);
        }
        if ((bitfield & 4) == 4) {
            voxelshape = VoxelShapes.func_197872_a((VoxelShape)voxelshape, (VoxelShape)swCorner);
        }
        if ((bitfield & 8) == 8) {
            voxelshape = VoxelShapes.func_197872_a((VoxelShape)voxelshape, (VoxelShape)seCorner);
        }
        if ((bitfield & 0xC) == 12) {
            voxelshape = VoxelShapes.func_216384_a((VoxelShape)south, (VoxelShape[])new VoxelShape[0]);
        }
        if ((bitfield & 5) == 5) {
            voxelshape = VoxelShapes.func_216384_a((VoxelShape)west, (VoxelShape[])new VoxelShape[0]);
        }
        if ((bitfield & 3) == 3) {
            voxelshape = VoxelShapes.func_216384_a((VoxelShape)north, (VoxelShape[])new VoxelShape[0]);
        }
        if ((bitfield & 0xA) == 10) {
            voxelshape = VoxelShapes.func_216384_a((VoxelShape)east, (VoxelShape[])new VoxelShape[0]);
        }
        if ((bitfield & 7) == 7) {
            voxelshape = VoxelShapes.func_216384_a((VoxelShape)nwInner, (VoxelShape[])new VoxelShape[0]);
        }
        if ((bitfield & 0xB) == 11) {
            voxelshape = VoxelShapes.func_216384_a((VoxelShape)neInner, (VoxelShape[])new VoxelShape[0]);
        }
        if ((bitfield & 0xD) == 13) {
            voxelshape = VoxelShapes.func_216384_a((VoxelShape)swInner, (VoxelShape[])new VoxelShape[0]);
        }
        if ((bitfield & 0xE) == 14) {
            voxelshape = VoxelShapes.func_216384_a((VoxelShape)seInner, (VoxelShape[])new VoxelShape[0]);
        }
        return voxelshape;
    }

    @Deprecated
    public QStairsBlock(BlockState state, Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)FACING, (Comparable)Direction.NORTH)).func_206870_a(HALF, (Comparable)Half.BOTTOM)).func_206870_a(SHAPE, (Comparable)StairsShape.STRAIGHT)).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.modelBlock = state.func_177230_c();
        this.modelState = state;
        this.stateSupplier = () -> state;
    }

    public QStairsBlock(Supplier<BlockState> state, Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)FACING, (Comparable)Direction.NORTH)).func_206870_a(HALF, (Comparable)Half.BOTTOM)).func_206870_a(SHAPE, (Comparable)StairsShape.STRAIGHT)).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.modelBlock = Blocks.field_150350_a;
        this.modelState = Blocks.field_150350_a.func_176223_P();
        this.stateSupplier = state;
    }

    public boolean func_220074_n(BlockState state) {
        return false;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return (state.func_177229_b(HALF) == Half.TOP ? SLAB_TOP_SHAPES : SLAB_BOTTOM_SHAPES)[field_196522_K[this.func_196511_x(state)]];
    }

    private int func_196511_x(BlockState state) {
        return ((StairsShape)state.func_177229_b(SHAPE)).ordinal() * 4 + ((Direction)state.func_177229_b((IProperty)FACING)).func_176736_b();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        this.modelBlock.func_180655_c(stateIn, worldIn, pos, rand);
    }

    public void func_196270_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player) {
        this.modelState.func_196942_a(worldIn, pos, player);
    }

    public void func_176206_d(IWorld worldIn, BlockPos pos, BlockState state) {
        this.modelBlock.func_176206_d(worldIn, pos, state);
    }

    public float func_149638_a() {
        return this.modelBlock.func_149638_a();
    }

    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (state.func_177230_c() != state.func_177230_c()) {
            this.modelBlock.func_220082_b(this.modelState, worldIn, pos, oldState, false);
        }
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != state.func_177230_c()) {
            this.modelState.func_196947_b(worldIn, pos, newState, isMoving);
        }
    }

    public void func_176199_a(World worldIn, BlockPos pos, Entity entityIn) {
        this.modelBlock.func_176199_a(worldIn, pos, entityIn);
    }

    public boolean func_149653_t(BlockState state) {
        return this.modelBlock.func_149653_t(state);
    }

    public void func_225542_b_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        this.modelBlock.func_225542_b_(state, worldIn, pos, random);
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        this.modelBlock.func_225534_a_(state, worldIn, pos, rand);
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        return this.modelState.func_227031_a_(worldIn, player, handIn, hit);
    }

    public void func_180652_a(World worldIn, BlockPos pos, Explosion explosionIn) {
        this.modelBlock.func_180652_a(worldIn, pos, explosionIn);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction direction = context.func_196000_l();
        BlockPos blockpos = context.func_195995_a();
        IFluidState fluidstate = context.func_195991_k().func_204610_c(blockpos);
        BlockState blockstate = (BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)context.func_195992_f())).func_206870_a(HALF, (Comparable)(!(direction == Direction.DOWN || direction != Direction.UP && context.func_221532_j().field_72448_b - (double)blockpos.func_177956_o() > 0.5) ? Half.BOTTOM : Half.TOP))).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.func_206886_c() == Fluids.field_204546_a));
        return (BlockState)blockstate.func_206870_a(SHAPE, (Comparable)QStairsBlock.getShapeProperty(blockstate, (IBlockReader)context.func_195991_k(), blockpos));
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return facing.func_176740_k().func_176722_c() ? (BlockState)stateIn.func_206870_a(SHAPE, (Comparable)QStairsBlock.getShapeProperty(stateIn, (IBlockReader)worldIn, currentPos)) : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    private static StairsShape getShapeProperty(BlockState state, IBlockReader worldIn, BlockPos pos) {
        Direction direction2;
        Direction direction1;
        Direction direction = (Direction)state.func_177229_b((IProperty)FACING);
        BlockState blockstate = worldIn.func_180495_p(pos.func_177972_a(direction));
        if (QStairsBlock.isBlockStairs(blockstate) && state.func_177229_b(HALF) == blockstate.func_177229_b(HALF) && (direction1 = (Direction)blockstate.func_177229_b((IProperty)FACING)).func_176740_k() != ((Direction)state.func_177229_b((IProperty)FACING)).func_176740_k() && QStairsBlock.isDifferentStairs(state, worldIn, pos, direction1.func_176734_d())) {
            if (direction1 == direction.func_176735_f()) {
                return StairsShape.OUTER_LEFT;
            }
            return StairsShape.OUTER_RIGHT;
        }
        BlockState blockstate1 = worldIn.func_180495_p(pos.func_177972_a(direction.func_176734_d()));
        if (QStairsBlock.isBlockStairs(blockstate1) && state.func_177229_b(HALF) == blockstate1.func_177229_b(HALF) && (direction2 = (Direction)blockstate1.func_177229_b((IProperty)FACING)).func_176740_k() != ((Direction)state.func_177229_b((IProperty)FACING)).func_176740_k() && QStairsBlock.isDifferentStairs(state, worldIn, pos, direction2)) {
            if (direction2 == direction.func_176735_f()) {
                return StairsShape.INNER_LEFT;
            }
            return StairsShape.INNER_RIGHT;
        }
        return StairsShape.STRAIGHT;
    }

    private static boolean isDifferentStairs(BlockState state, IBlockReader worldIn, BlockPos pos, Direction face) {
        BlockState blockstate = worldIn.func_180495_p(pos.func_177972_a(face));
        return !QStairsBlock.isBlockStairs(blockstate) || blockstate.func_177229_b((IProperty)FACING) != state.func_177229_b((IProperty)FACING) || blockstate.func_177229_b(HALF) != state.func_177229_b(HALF);
    }

    public static boolean isBlockStairs(BlockState state) {
        return state.func_177230_c() instanceof QStairsBlock;
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        Direction direction = (Direction)state.func_177229_b((IProperty)FACING);
        StairsShape stairsshape = (StairsShape)state.func_177229_b(SHAPE);
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                if (direction.func_176740_k() != Direction.Axis.Z) break;
                switch (stairsshape) {
                    case INNER_LEFT: {
                        return (BlockState)state.func_185907_a(Rotation.CLOCKWISE_90).func_206870_a(SHAPE, (Comparable)StairsShape.INNER_RIGHT);
                    }
                    case INNER_RIGHT: {
                        return (BlockState)state.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a(SHAPE, (Comparable)StairsShape.INNER_LEFT);
                    }
                    case OUTER_LEFT: {
                        return (BlockState)state.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a(SHAPE, (Comparable)StairsShape.OUTER_RIGHT);
                    }
                    case OUTER_RIGHT: {
                        return (BlockState)state.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a(SHAPE, (Comparable)StairsShape.OUTER_LEFT);
                    }
                }
                return (BlockState)state.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a(SHAPE, (Comparable)StairsShape.STRAIGHT);
            }
            case FRONT_BACK: {
                if (direction.func_176740_k() != Direction.Axis.X) break;
                switch (stairsshape) {
                    case INNER_LEFT: {
                        return (BlockState)state.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a(SHAPE, (Comparable)StairsShape.INNER_LEFT);
                    }
                    case INNER_RIGHT: {
                        return (BlockState)state.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a(SHAPE, (Comparable)StairsShape.INNER_RIGHT);
                    }
                    case OUTER_LEFT: {
                        return (BlockState)state.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a(SHAPE, (Comparable)StairsShape.OUTER_RIGHT);
                    }
                    case OUTER_RIGHT: {
                        return (BlockState)state.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a(SHAPE, (Comparable)StairsShape.OUTER_LEFT);
                    }
                    case STRAIGHT: {
                        return (BlockState)state.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a(SHAPE, (Comparable)StairsShape.STRAIGHT);
                    }
                }
            }
        }
        return super.func_185471_a(state, mirrorIn);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING, HALF, SHAPE, WATERLOGGED});
    }

    public IFluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }

    private Block getModelBlock() {
        return this.getModelState().func_177230_c();
    }

    private BlockState getModelState() {
        return this.stateSupplier.get();
    }

    public static class Flammable
    extends QStairsBlock {
        public Flammable(Supplier<BlockState> state, Block.Properties properties) {
            super(state, properties);
        }

        public boolean isFlammable(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
            return true;
        }

        public int getFlammability(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
            return 25;
        }

        public int getFireSpreadSpeed(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
            return 150;
        }
    }
}

