/*
 * Decompiled with CFR 0.152.
 */
package com.imwindow.buildersplus.blocks;

import com.imwindow.buildersplus.init.ModSoundEvents;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalFaceBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.AttachFace;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SwitchBlock
extends HorizontalFaceBlock {
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;
    protected static final VoxelShape LEVER_NORTH_AABB = Block.func_208617_a((double)5.0, (double)4.0, (double)13.0, (double)11.0, (double)12.0, (double)16.0);
    protected static final VoxelShape LEVER_SOUTH_AABB = Block.func_208617_a((double)5.0, (double)4.0, (double)0.0, (double)11.0, (double)12.0, (double)3.0);
    protected static final VoxelShape LEVER_WEST_AABB = Block.func_208617_a((double)13.0, (double)4.0, (double)5.0, (double)16.0, (double)12.0, (double)11.0);
    protected static final VoxelShape LEVER_EAST_AABB = Block.func_208617_a((double)0.0, (double)4.0, (double)5.0, (double)3.0, (double)12.0, (double)11.0);
    protected static final VoxelShape FLOOR_Z_SHAPE = Block.func_208617_a((double)5.0, (double)0.0, (double)4.0, (double)11.0, (double)3.0, (double)12.0);
    protected static final VoxelShape FLOOR_X_SHAPE = Block.func_208617_a((double)4.0, (double)0.0, (double)5.0, (double)12.0, (double)3.0, (double)11.0);
    protected static final VoxelShape CEILING_Z_SHAPE = Block.func_208617_a((double)5.0, (double)13.0, (double)4.0, (double)11.0, (double)16.0, (double)12.0);
    protected static final VoxelShape CEILING_X_SHAPE = Block.func_208617_a((double)4.0, (double)13.0, (double)5.0, (double)12.0, (double)16.0, (double)11.0);

    public SwitchBlock(Block.Properties builder) {
        super(builder);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)field_185512_D, (Comparable)Direction.NORTH)).func_206870_a((IProperty)POWERED, (Comparable)Boolean.FALSE)).func_206870_a((IProperty)field_196366_M, (Comparable)AttachFace.WALL));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        switch ((AttachFace)state.func_177229_b((IProperty)field_196366_M)) {
            case FLOOR: {
                switch (((Direction)state.func_177229_b((IProperty)field_185512_D)).func_176740_k()) {
                    case X: {
                        return FLOOR_X_SHAPE;
                    }
                }
                return FLOOR_Z_SHAPE;
            }
            case WALL: {
                switch ((Direction)state.func_177229_b((IProperty)field_185512_D)) {
                    case EAST: {
                        return LEVER_EAST_AABB;
                    }
                    case WEST: {
                        return LEVER_WEST_AABB;
                    }
                    case SOUTH: {
                        return LEVER_SOUTH_AABB;
                    }
                }
                return LEVER_NORTH_AABB;
            }
        }
        switch (((Direction)state.func_177229_b((IProperty)field_185512_D)).func_176740_k()) {
            case X: {
                return CEILING_X_SHAPE;
            }
        }
        return CEILING_Z_SHAPE;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (worldIn.field_72995_K) {
            BlockState blockstate1 = (BlockState)state.func_177231_a((IProperty)POWERED);
            if (((Boolean)blockstate1.func_177229_b((IProperty)POWERED)).booleanValue()) {
                SwitchBlock.addParticles(blockstate1, (IWorld)worldIn, pos, 1.0f);
            }
            return ActionResultType.SUCCESS;
        }
        BlockState blockstate = this.setPowered(state, worldIn, pos);
        float f = (Boolean)blockstate.func_177229_b((IProperty)POWERED) != false ? 0.6f : 0.5f;
        worldIn.func_184133_a(null, pos, ModSoundEvents.BLOCK_SWITCH_CLICK, SoundCategory.BLOCKS, 0.3f, f);
        return ActionResultType.CONSUME;
    }

    public BlockState setPowered(BlockState state, World world, BlockPos pos) {
        state = (BlockState)state.func_177231_a((IProperty)POWERED);
        world.func_180501_a(pos, state, 3);
        this.updateNeighbors(state, world, pos);
        return state;
    }

    private static void addParticles(BlockState state, IWorld worldIn, BlockPos pos, float alpha) {
        Direction direction = ((Direction)state.func_177229_b((IProperty)field_185512_D)).func_176734_d();
        Direction direction1 = SwitchBlock.func_196365_i((BlockState)state).func_176734_d();
        double d0 = (double)pos.func_177958_n() + 0.5 + 0.1 * (double)direction.func_82601_c() + 0.2 * (double)direction1.func_82601_c();
        double d1 = (double)pos.func_177956_o() + 0.5 + 0.1 * (double)direction.func_96559_d() + 0.2 * (double)direction1.func_96559_d();
        double d2 = (double)pos.func_177952_p() + 0.5 + 0.1 * (double)direction.func_82599_e() + 0.2 * (double)direction1.func_82599_e();
        worldIn.func_195594_a((IParticleData)new RedstoneParticleData(1.0f, 0.0f, 0.0f, alpha), d0, d1, d2, 0.0, 0.0, 0.0);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (((Boolean)stateIn.func_177229_b((IProperty)POWERED)).booleanValue() && rand.nextFloat() < 0.25f) {
            SwitchBlock.addParticles(stateIn, (IWorld)worldIn, pos, 0.5f);
        }
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!isMoving && state.func_177230_c() != newState.func_177230_c()) {
            if (((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) {
                this.updateNeighbors(state, worldIn, pos);
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    public int func_180656_a(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        return (Boolean)blockState.func_177229_b((IProperty)POWERED) != false ? 15 : 0;
    }

    public int func_176211_b(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        return (Boolean)blockState.func_177229_b((IProperty)POWERED) != false && SwitchBlock.func_196365_i((BlockState)blockState) == side ? 15 : 0;
    }

    public boolean func_149744_f(BlockState state) {
        return true;
    }

    private void updateNeighbors(BlockState state, World world, BlockPos pos) {
        world.func_195593_d(pos, (Block)this);
        world.func_195593_d(pos.func_177972_a(SwitchBlock.func_196365_i((BlockState)state).func_176734_d()), (Block)this);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{field_196366_M, field_185512_D, POWERED});
    }
}

