/*
 * Decompiled with CFR 0.152.
 */
package com.imwindow.buildersplus.blocks.banners;

import com.google.common.collect.Lists;
import com.imwindow.buildersplus.util.ModDyeColor;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IExtensibleEnum;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="buildersplus", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public enum ModBannerPattern implements IExtensibleEnum
{
    BASE("base", "b", false),
    SQUARE_BOTTOM_LEFT("square_bottom_left", "bl"),
    SQUARE_BOTTOM_RIGHT("square_bottom_right", "br"),
    SQUARE_TOP_LEFT("square_top_left", "tl"),
    SQUARE_TOP_RIGHT("square_top_right", "tr"),
    STRIPE_BOTTOM("stripe_bottom", "bs"),
    STRIPE_TOP("stripe_top", "ts"),
    STRIPE_LEFT("stripe_left", "ls"),
    STRIPE_RIGHT("stripe_right", "rs"),
    STRIPE_CENTER("stripe_center", "cs"),
    STRIPE_MIDDLE("stripe_middle", "ms"),
    STRIPE_DOWNRIGHT("stripe_downright", "drs"),
    STRIPE_DOWNLEFT("stripe_downleft", "dls"),
    STRIPE_SMALL("small_stripes", "ss"),
    CROSS("cross", "cr"),
    STRAIGHT_CROSS("straight_cross", "sc"),
    TRIANGLE_BOTTOM("triangle_bottom", "bt"),
    TRIANGLE_TOP("triangle_top", "tt"),
    TRIANGLES_BOTTOM("triangles_bottom", "bts"),
    TRIANGLES_TOP("triangles_top", "tts"),
    DIAGONAL_LEFT("diagonal_left", "ld"),
    DIAGONAL_RIGHT("diagonal_up_right", "rd"),
    DIAGONAL_LEFT_MIRROR("diagonal_up_left", "lud"),
    DIAGONAL_RIGHT_MIRROR("diagonal_right", "rud"),
    CIRCLE_MIDDLE("circle", "mc"),
    RHOMBUS_MIDDLE("rhombus", "mr"),
    HALF_VERTICAL("half_vertical", "vh"),
    HALF_HORIZONTAL("half_horizontal", "hh"),
    HALF_VERTICAL_MIRROR("half_vertical_right", "vhr"),
    HALF_HORIZONTAL_MIRROR("half_horizontal_bottom", "hhb"),
    BORDER("border", "bo"),
    CURLY_BORDER("curly_border", "cbo"),
    GRADIENT("gradient", "gra"),
    GRADIENT_UP("gradient_up", "gru"),
    BRICKS("bricks", "bri"),
    GLOBE("globe", "glb", true),
    CREEPER("creeper", "cre", true),
    SKULL("skull", "sku", true),
    FLOWER("flower", "flo", true),
    MOJANG("mojang", "moj", true),
    PIGLIN("piglin", "pig", true);

    private static final ModBannerPattern[] BANNER_PATTERNS;
    public static final int BANNER_PATTERNS_COUNT;
    public static final int BANNERS_WITH_ITEMS;
    public static final int PATTERN_ITEM_INDEX;
    private final boolean hasPatternItem;
    private final String fileName;
    private final String hashname;

    private ModBannerPattern(String fileNameIn, String hashNameIn) {
        this(fileNameIn, hashNameIn, false);
    }

    private ModBannerPattern(String p_i231861_3_, String p_i231861_4_, boolean p_i231861_5_) {
        this.fileName = p_i231861_3_;
        this.hashname = p_i231861_4_;
        this.hasPatternItem = p_i231861_5_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation getTextureLocation(boolean isBanner) {
        String s = isBanner ? "banner" : "shield";
        return new ResourceLocation("entity/" + s + "/" + this.getFileName());
    }

    @OnlyIn(value=Dist.CLIENT)
    public String getFileName() {
        return this.fileName;
    }

    public String getHashname() {
        return this.hashname;
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public static ModBannerPattern byHash(String hash) {
        for (ModBannerPattern bannerpattern : ModBannerPattern.values()) {
            if (!bannerpattern.hashname.equals(hash)) continue;
            return bannerpattern;
        }
        return null;
    }

    public static ModBannerPattern create(String enumName, String fileNameIn, String hashNameIn) {
        throw new IllegalStateException("Enum not extended");
    }

    public static ModBannerPattern create(String enumName, String fileNameIn, String hashNameIn, boolean p_i231861_5_) {
        throw new IllegalStateException("Enum not extended");
    }

    static {
        BANNER_PATTERNS = ModBannerPattern.values();
        BANNER_PATTERNS_COUNT = BANNER_PATTERNS.length;
        BANNERS_WITH_ITEMS = (int)Arrays.stream(BANNER_PATTERNS).filter(p_235649_0_ -> p_235649_0_.hasPatternItem).count();
        PATTERN_ITEM_INDEX = BANNER_PATTERNS_COUNT - BANNERS_WITH_ITEMS - 1;
    }

    public static class Builder {
        private final List<Pair<ModBannerPattern, ModDyeColor>> patternColors = Lists.newArrayList();

        public Builder setPatternWithColor(ModBannerPattern p_222477_1_, ModDyeColor p_222477_2_) {
            this.patternColors.add((Pair<ModBannerPattern, ModDyeColor>)Pair.of((Object)((Object)p_222477_1_), (Object)((Object)p_222477_2_)));
            return this;
        }

        public ListNBT buildNBT() {
            ListNBT listnbt = new ListNBT();
            for (Pair<ModBannerPattern, ModDyeColor> pair : this.patternColors) {
                CompoundNBT compoundnbt = new CompoundNBT();
                compoundnbt.func_74778_a("Pattern", ((ModBannerPattern)((Object)pair.getLeft())).hashname);
                compoundnbt.func_74768_a("Color", ((ModDyeColor)((Object)pair.getRight())).getId());
                listnbt.add((Object)compoundnbt);
            }
            return listnbt;
        }
    }
}

