/*
 * Decompiled with CFR 0.152.
 */
package com.imwindow.buildersplus.blocks.banners;

import com.google.common.collect.Lists;
import com.imwindow.buildersplus.blocks.banners.AbstractModBanner;
import com.imwindow.buildersplus.blocks.banners.ModBanner;
import com.imwindow.buildersplus.blocks.banners.ModBannerPattern;
import com.imwindow.buildersplus.init.ModTileEntities;
import com.imwindow.buildersplus.util.ModDyeColor;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.INameable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ModBannerTileEntity
extends TileEntity
implements INameable {
    @Nullable
    private ITextComponent name;
    @Nullable
    private ModDyeColor baseColor = ModDyeColor.WHITE;
    @Nullable
    private ListNBT patterns;
    private boolean patternDataSet;
    @Nullable
    private List<Pair<ModBannerPattern, ModDyeColor>> patternList;

    public ModBannerTileEntity() {
        super((TileEntityType)ModTileEntities.BANNER.get());
    }

    public ModBannerTileEntity(ModDyeColor p_i47731_1_) {
        this();
        this.baseColor = p_i47731_1_;
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public static ListNBT getPatternsFromItemStack(ItemStack p_230139_0_) {
        ListNBT listnbt = null;
        CompoundNBT compoundnbt = p_230139_0_.func_179543_a("BlockEntityTag");
        if (compoundnbt != null && compoundnbt.func_150297_b("Patterns", 9)) {
            listnbt = compoundnbt.func_150295_c("Patterns", 10).func_74737_b();
        }
        return listnbt;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void loadFromItemStack(ItemStack p_195534_1_, ModDyeColor p_195534_2_) {
        this.patterns = ModBannerTileEntity.getPatternsFromItemStack(p_195534_1_);
        this.baseColor = p_195534_2_;
        this.patternList = null;
        this.patternDataSet = true;
        this.name = p_195534_1_.func_82837_s() ? p_195534_1_.func_200301_q() : null;
    }

    public ITextComponent func_200200_C_() {
        return this.name != null ? this.name : new TranslationTextComponent("block.minecraft.banner", new Object[0]);
    }

    @Nullable
    public ITextComponent func_200201_e() {
        return this.name;
    }

    public void func_213136_a(ITextComponent p_213136_1_) {
        this.name = p_213136_1_;
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        if (this.patterns != null) {
            compound.func_218657_a("Patterns", (INBT)this.patterns);
        }
        if (this.name != null) {
            compound.func_74778_a("CustomName", ITextComponent.Serializer.func_150696_a((ITextComponent)this.name));
        }
        return compound;
    }

    public void func_145839_a(CompoundNBT nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_150297_b("CustomName", 8)) {
            this.name = ITextComponent.Serializer.func_150699_a((String)nbt.func_74779_i("CustomName"));
        }
        this.baseColor = this.func_145830_o() ? ((AbstractModBanner)this.func_195044_w().func_177230_c()).getColor() : null;
        this.patterns = nbt.func_150295_c("Patterns", 10);
        this.patternList = null;
        this.patternDataSet = true;
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 6, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public static int getPatterns(ItemStack stack) {
        CompoundNBT compoundnbt = stack.func_179543_a("BlockEntityTag");
        return compoundnbt != null && compoundnbt.func_74764_b("Patterns") ? compoundnbt.func_150295_c("Patterns", 10).size() : 0;
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        super.onDataPacket(net, pkt);
        this.handleUpdateTag(pkt.func_148857_g());
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<Pair<ModBannerPattern, ModDyeColor>> getPatternList() {
        if (this.patternList == null && this.patternDataSet) {
            this.patternList = ModBannerTileEntity.createPatternList(this.getBaseColor(() -> ((ModBannerTileEntity)this).func_195044_w()), this.patterns);
        }
        return this.patternList;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static List<Pair<ModBannerPattern, ModDyeColor>> createPatternList(ModDyeColor p_230138_0_, @Nullable ListNBT p_230138_1_) {
        ArrayList list = Lists.newArrayList();
        list.add(Pair.of((Object)((Object)ModBannerPattern.BASE), (Object)((Object)p_230138_0_)));
        if (p_230138_1_ != null) {
            for (int i = 0; i < p_230138_1_.size(); ++i) {
                CompoundNBT compoundnbt = p_230138_1_.func_150305_b(i);
                ModBannerPattern bannerpattern = ModBannerPattern.byHash(compoundnbt.func_74779_i("Pattern"));
                if (bannerpattern == null) continue;
                int j = compoundnbt.func_74762_e("Color");
                list.add(Pair.of((Object)((Object)bannerpattern), (Object)((Object)ModDyeColor.byId(j))));
            }
        }
        return list;
    }

    public static void removeBannerData(ItemStack stack) {
        ListNBT listnbt;
        CompoundNBT compoundnbt = stack.func_179543_a("BlockEntityTag");
        if (compoundnbt != null && compoundnbt.func_150297_b("Patterns", 9) && !(listnbt = compoundnbt.func_150295_c("Patterns", 10)).isEmpty()) {
            listnbt.remove(listnbt.size() - 1);
            if (listnbt.isEmpty()) {
                stack.func_196083_e("BlockEntityTag");
            }
        }
    }

    public ItemStack getItem(BlockState p_190615_1_) {
        ItemStack itemstack = new ItemStack((IItemProvider)ModBanner.forColor(this.getBaseColor(() -> p_190615_1_)));
        if (this.patterns != null && !this.patterns.isEmpty()) {
            itemstack.func_190925_c("BlockEntityTag").func_218657_a("Patterns", (INBT)this.patterns.func_74737_b());
        }
        if (this.name != null) {
            itemstack.func_200302_a(this.name);
        }
        return itemstack;
    }

    public ModDyeColor getBaseColor(Supplier<BlockState> p_195533_1_) {
        if (this.baseColor == null) {
            this.baseColor = ((AbstractModBanner)p_195533_1_.get().func_177230_c()).getColor();
        }
        return this.baseColor;
    }
}

