/*
 * Decompiled with CFR 0.152.
 */
package com.imwindow.buildersplus.blocks.shulker;

import com.imwindow.buildersplus.blocks.shulker.ModShulkerTileEntity;
import com.imwindow.buildersplus.init.ModBlocks;
import com.imwindow.buildersplus.util.ModDyeColor;
import com.imwindow.buildersplus.util.OtherModDyeColor;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.DirectionalBlock;
import net.minecraft.block.ShulkerBoxBlock;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ModShulkerBoxBlock
extends ShulkerBoxBlock {
    public static final EnumProperty<Direction> FACING = DirectionalBlock.field_176387_N;
    public static final ResourceLocation CONTENTS = new ResourceLocation("contents");
    @Nullable
    private final OtherModDyeColor color;

    public ModShulkerBoxBlock(DyeColor color1, @Nullable OtherModDyeColor color, Block.Properties properties) {
        super(color1, properties);
        this.color = color;
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(FACING, (Comparable)Direction.UP));
    }

    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new ModShulkerTileEntity(this.color);
    }

    public boolean func_229869_c_(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return true;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (worldIn.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        if (player.func_175149_v()) {
            return ActionResultType.SUCCESS;
        }
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof ModShulkerTileEntity) {
            boolean flag;
            Direction direction = (Direction)state.func_177229_b(FACING);
            ModShulkerTileEntity ModShulkerTileEntity2 = (ModShulkerTileEntity)tileentity;
            if (ModShulkerTileEntity2.getAnimationStatus() == ModShulkerTileEntity.AnimationStatus.CLOSED) {
                AxisAlignedBB axisalignedbb = VoxelShapes.func_197868_b().func_197752_a().func_72321_a((double)(0.5f * (float)direction.func_82601_c()), (double)(0.5f * (float)direction.func_96559_d()), (double)(0.5f * (float)direction.func_82599_e())).func_191195_a((double)direction.func_82601_c(), (double)direction.func_96559_d(), (double)direction.func_82599_e());
                flag = worldIn.func_226664_a_(axisalignedbb.func_186670_a(pos.func_177972_a(direction)));
            } else {
                flag = true;
            }
            if (flag) {
                player.func_213829_a((INamedContainerProvider)ModShulkerTileEntity2);
                player.func_195066_a(Stats.field_191272_ae);
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a(FACING, (Comparable)context.func_196000_l());
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING});
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof ModShulkerTileEntity) {
            ModShulkerTileEntity ModShulkerTileEntity2 = (ModShulkerTileEntity)tileentity;
            if (!worldIn.field_72995_K && player.func_184812_l_() && !ModShulkerTileEntity2.func_191420_l()) {
                ItemStack itemstack = ModShulkerBoxBlock.getColoredItemStack(this.getModColor());
                CompoundNBT compoundnbt = ModShulkerTileEntity2.saveToNbt(new CompoundNBT());
                if (!compoundnbt.isEmpty()) {
                    itemstack.func_77983_a("BlockEntityTag", (INBT)compoundnbt);
                }
                if (ModShulkerTileEntity2.func_145818_k_()) {
                    itemstack.func_200302_a(ModShulkerTileEntity2.func_200201_e());
                }
                ItemEntity itementity = new ItemEntity(worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), itemstack);
                itementity.func_174869_p();
                worldIn.func_217376_c((Entity)itementity);
            } else {
                ModShulkerTileEntity2.func_184281_d(player);
            }
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        TileEntity tileentity = (TileEntity)builder.func_216019_b(LootParameters.field_216288_h);
        if (tileentity instanceof ModShulkerTileEntity) {
            ModShulkerTileEntity ModShulkerTileEntity2 = (ModShulkerTileEntity)tileentity;
            builder = builder.func_216017_a(CONTENTS, (p_220168_1_, p_220168_2_) -> {
                for (int i = 0; i < ModShulkerTileEntity2.func_70302_i_(); ++i) {
                    p_220168_2_.accept(ModShulkerTileEntity2.func_70301_a(i));
                }
            });
        }
        return super.func_220076_a(state, builder);
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        TileEntity tileentity;
        if (stack.func_82837_s() && (tileentity = worldIn.func_175625_s(pos)) instanceof ModShulkerTileEntity) {
            ((ModShulkerTileEntity)tileentity).func_213903_a(stack.func_200301_q());
        }
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileEntity tileentity = worldIn.func_175625_s(pos);
            if (tileentity instanceof ModShulkerTileEntity) {
                worldIn.func_175666_e(pos, state.func_177230_c());
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.DESTROY;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        return tileentity instanceof ModShulkerTileEntity ? VoxelShapes.func_197881_a((AxisAlignedBB)((ModShulkerTileEntity)tileentity).getBoundingBox(state)) : VoxelShapes.func_197868_b();
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World worldIn, BlockPos pos) {
        return Container.func_94526_b((IInventory)((IInventory)worldIn.func_175625_s(pos)));
    }

    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, BlockState state) {
        ItemStack itemstack = new ItemStack((IItemProvider)this);
        ModShulkerTileEntity ModShulkerTileEntity2 = (ModShulkerTileEntity)worldIn.func_175625_s(pos);
        CompoundNBT compoundnbt = ModShulkerTileEntity2.saveToNbt(new CompoundNBT());
        if (!compoundnbt.isEmpty()) {
            itemstack.func_77983_a("BlockEntityTag", (INBT)compoundnbt);
        }
        return itemstack;
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public static OtherModDyeColor getColorFromBlock2(Block blockIn) {
        return blockIn instanceof ModShulkerBoxBlock ? ((ModShulkerBoxBlock)blockIn).getModColor() : null;
    }

    public static Block getBlockByColor(@Nullable OtherModDyeColor colorIn) {
        switch (Objects.requireNonNull(colorIn)) {
            case CORAL: {
                return (Block)ModBlocks.CORAL_SHULKER.get();
            }
            case SALMON: {
                return (Block)ModBlocks.SALMON_SHULKER.get();
            }
            case APRICOT: {
                return (Block)ModBlocks.APRICOT_SHULKER.get();
            }
            case AMBER: {
                return (Block)ModBlocks.AMBER_SHULKER.get();
            }
            case SIENNA: {
                return (Block)ModBlocks.SIENNA_SHULKER.get();
            }
            case PEAR: {
                return (Block)ModBlocks.PEAR_SHULKER.get();
            }
            case EMERALD_GREEN: {
                return (Block)ModBlocks.EMERALD_SHULKER.get();
            }
            case FOREST_GREEN: {
                return (Block)ModBlocks.FOREST_GREEN_SHULKER.get();
            }
            case JADE: {
                return (Block)ModBlocks.JADE_SHULKER.get();
            }
            case TEAL: {
                return (Block)ModBlocks.TEAL_SHULKER.get();
            }
            case TURQUOISE: {
                return (Block)ModBlocks.TURQUOISE_SHULKER.get();
            }
            case BURGUNDY: {
                return (Block)ModBlocks.BURGUNDY_SHULKER.get();
            }
            case PLUM: {
                return (Block)ModBlocks.PLUM_SHULKER.get();
            }
            case LAVENDER: {
                return (Block)ModBlocks.LAVENDER_SHULKER.get();
            }
            case CRIMSON: {
                return (Block)ModBlocks.CRIMSON_SHULKER.get();
            }
        }
        return (Block)ModBlocks.MAROON_SHULKER.get();
    }

    public static Block getBlockByColor2(@Nullable ModDyeColor colorIn) {
        switch (Objects.requireNonNull(colorIn)) {
            case CORAL: {
                return (Block)ModBlocks.CORAL_SHULKER.get();
            }
            case SALMON: {
                return (Block)ModBlocks.SALMON_SHULKER.get();
            }
            case APRICOT: {
                return (Block)ModBlocks.APRICOT_SHULKER.get();
            }
            case AMBER: {
                return (Block)ModBlocks.AMBER_SHULKER.get();
            }
            case SIENNA: {
                return (Block)ModBlocks.SIENNA_SHULKER.get();
            }
            case PEAR: {
                return (Block)ModBlocks.PEAR_SHULKER.get();
            }
            case EMERALD_GREEN: {
                return (Block)ModBlocks.EMERALD_SHULKER.get();
            }
            case FOREST_GREEN: {
                return (Block)ModBlocks.FOREST_GREEN_SHULKER.get();
            }
            case JADE: {
                return (Block)ModBlocks.JADE_SHULKER.get();
            }
            case TEAL: {
                return (Block)ModBlocks.TEAL_SHULKER.get();
            }
            case TURQUOISE: {
                return (Block)ModBlocks.TURQUOISE_SHULKER.get();
            }
            case BURGUNDY: {
                return (Block)ModBlocks.BURGUNDY_SHULKER.get();
            }
            case PLUM: {
                return (Block)ModBlocks.PLUM_SHULKER.get();
            }
            case LAVENDER: {
                return (Block)ModBlocks.LAVENDER_SHULKER.get();
            }
            case CRIMSON: {
                return (Block)ModBlocks.CRIMSON_SHULKER.get();
            }
        }
        return (Block)ModBlocks.MAROON_SHULKER.get();
    }

    @Nullable
    public OtherModDyeColor getModColor() {
        return this.color;
    }

    public static ItemStack getColoredItemStack(@Nullable OtherModDyeColor colorIn) {
        return new ItemStack((IItemProvider)ModShulkerBoxBlock.getBlockByColor(colorIn));
    }

    public static ItemStack getColoredItemStack2(@Nullable ModDyeColor colorIn) {
        return new ItemStack((IItemProvider)ModShulkerBoxBlock.getBlockByColor2(colorIn));
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a(FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b(FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b(FACING)));
    }
}

