/*
 * Decompiled with CFR 0.152.
 */
package com.imwindow.buildersplus.blocks.shulker;

import com.imwindow.buildersplus.blocks.shulker.ModShulkerBoxBlock;
import com.imwindow.buildersplus.init.ModTileEntities;
import com.imwindow.buildersplus.util.OtherModDyeColor;
import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ShulkerBoxContainer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class ModShulkerTileEntity
extends LockableLootTileEntity
implements ISidedInventory,
ITickableTileEntity {
    private static final int[] SLOTS = IntStream.range(0, 27).toArray();
    private NonNullList<ItemStack> items = NonNullList.func_191197_a((int)27, (Object)ItemStack.field_190927_a);
    private int openCount;
    private AnimationStatus animationStatus = AnimationStatus.CLOSED;
    private float progress;
    private float progressOld;
    private OtherModDyeColor color;
    private boolean needsColorFromWorld;

    public ModShulkerTileEntity(@Nullable OtherModDyeColor colorIn) {
        super((TileEntityType)ModTileEntities.MOD_SHULKER.get());
        this.color = colorIn;
    }

    public ModShulkerTileEntity() {
        this(null);
        this.needsColorFromWorld = true;
    }

    public void func_73660_a() {
        this.updateAnimation();
        if (this.animationStatus == AnimationStatus.OPENING || this.animationStatus == AnimationStatus.CLOSING) {
            this.moveCollidedEntities();
        }
    }

    protected void updateAnimation() {
        this.progressOld = this.progress;
        switch (this.animationStatus) {
            case CLOSED: {
                this.progress = 0.0f;
                break;
            }
            case OPENING: {
                this.progress += 0.1f;
                if (!(this.progress >= 1.0f)) break;
                this.moveCollidedEntities();
                this.animationStatus = AnimationStatus.OPENED;
                this.progress = 1.0f;
                this.func_213975_v();
                break;
            }
            case CLOSING: {
                this.progress -= 0.1f;
                if (!(this.progress <= 0.0f)) break;
                this.animationStatus = AnimationStatus.CLOSED;
                this.progress = 0.0f;
                this.func_213975_v();
                break;
            }
            case OPENED: {
                this.progress = 1.0f;
            }
        }
    }

    public AnimationStatus getAnimationStatus() {
        return this.animationStatus;
    }

    public AxisAlignedBB getBoundingBox(BlockState state) {
        return this.getBoundingBox((Direction)state.func_177229_b(ModShulkerBoxBlock.FACING));
    }

    public AxisAlignedBB getBoundingBox(Direction direction) {
        float f = this.getProgress(1.0f);
        return VoxelShapes.func_197868_b().func_197752_a().func_72321_a((double)(0.5f * f * (float)direction.func_82601_c()), (double)(0.5f * f * (float)direction.func_96559_d()), (double)(0.5f * f * (float)direction.func_82599_e()));
    }

    private AxisAlignedBB getTopBoundingBox(Direction directionIn) {
        Direction direction = directionIn.func_176734_d();
        return this.getBoundingBox(directionIn).func_191195_a((double)direction.func_82601_c(), (double)direction.func_96559_d(), (double)direction.func_82599_e());
    }

    private void moveCollidedEntities() {
        Direction direction;
        AxisAlignedBB axisalignedbb;
        List list;
        assert (this.field_145850_b != null);
        BlockState blockstate = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (blockstate.func_177230_c() instanceof ModShulkerBoxBlock && !(list = this.field_145850_b.func_72839_b((Entity)null, axisalignedbb = this.getTopBoundingBox(direction = (Direction)blockstate.func_177229_b(ModShulkerBoxBlock.FACING)).func_186670_a(this.field_174879_c))).isEmpty()) {
            for (Entity entity : list) {
                if (entity.func_184192_z() == PushReaction.IGNORE) continue;
                double d0 = 0.0;
                double d1 = 0.0;
                double d2 = 0.0;
                AxisAlignedBB axisalignedbb1 = entity.func_174813_aQ();
                switch (direction.func_176740_k()) {
                    case X: {
                        d0 = direction.func_176743_c() == Direction.AxisDirection.POSITIVE ? axisalignedbb.field_72336_d - axisalignedbb1.field_72340_a : axisalignedbb1.field_72336_d - axisalignedbb.field_72340_a;
                        d0 += 0.01;
                        break;
                    }
                    case Y: {
                        d1 = direction.func_176743_c() == Direction.AxisDirection.POSITIVE ? axisalignedbb.field_72337_e - axisalignedbb1.field_72338_b : axisalignedbb1.field_72337_e - axisalignedbb.field_72338_b;
                        d1 += 0.01;
                        break;
                    }
                    case Z: {
                        d2 = direction.func_176743_c() == Direction.AxisDirection.POSITIVE ? axisalignedbb.field_72334_f - axisalignedbb1.field_72339_c : axisalignedbb1.field_72334_f - axisalignedbb.field_72339_c;
                        d2 += 0.01;
                    }
                }
                entity.func_213315_a(MoverType.SHULKER_BOX, new Vec3d(d0 * (double)direction.func_82601_c(), d1 * (double)direction.func_96559_d(), d2 * (double)direction.func_82599_e()));
            }
        }
    }

    public int func_70302_i_() {
        return this.items.size();
    }

    public boolean func_145842_c(int id, int type) {
        if (id == 1) {
            this.openCount = type;
            if (type == 0) {
                this.animationStatus = AnimationStatus.CLOSING;
                this.func_213975_v();
            }
            if (type == 1) {
                this.animationStatus = AnimationStatus.OPENING;
                this.func_213975_v();
            }
            return true;
        }
        return super.func_145842_c(id, type);
    }

    private void func_213975_v() {
        this.func_195044_w().func_196946_a((IWorld)Objects.requireNonNull(this.func_145831_w()), this.func_174877_v(), 3);
    }

    public void func_174889_b(PlayerEntity player) {
        if (!player.func_175149_v()) {
            if (this.openCount < 0) {
                this.openCount = 0;
            }
            ++this.openCount;
            assert (this.field_145850_b != null);
            this.field_145850_b.func_175641_c(this.field_174879_c, this.func_195044_w().func_177230_c(), 1, this.openCount);
            if (this.openCount == 1) {
                this.field_145850_b.func_184133_a((PlayerEntity)null, this.field_174879_c, SoundEvents.field_191262_fB, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
        }
    }

    public void func_174886_c(PlayerEntity player) {
        if (!player.func_175149_v()) {
            --this.openCount;
            assert (this.field_145850_b != null);
            this.field_145850_b.func_175641_c(this.field_174879_c, this.func_195044_w().func_177230_c(), 1, this.openCount);
            if (this.openCount <= 0) {
                this.field_145850_b.func_184133_a((PlayerEntity)null, this.field_174879_c, SoundEvents.field_191261_fA, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
        }
    }

    protected ITextComponent func_213907_g() {
        return new TranslationTextComponent("container.shulkerBox", new Object[0]);
    }

    public void func_145839_a(CompoundNBT nbt) {
        super.func_145839_a(nbt);
        this.loadFromNbt(nbt);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        return this.saveToNbt(compound);
    }

    public void loadFromNbt(CompoundNBT compound) {
        this.items = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        if (!this.func_184283_b(compound) && compound.func_150297_b("Items", 9)) {
            ItemStackHelper.func_191283_b((CompoundNBT)compound, this.items);
        }
    }

    public CompoundNBT saveToNbt(CompoundNBT compound) {
        if (!this.func_184282_c(compound)) {
            ItemStackHelper.func_191281_a((CompoundNBT)compound, this.items, (boolean)false);
        }
        return compound;
    }

    protected NonNullList<ItemStack> func_190576_q() {
        return this.items;
    }

    protected void func_199721_a(NonNullList<ItemStack> itemsIn) {
        this.items = itemsIn;
    }

    public int[] func_180463_a(Direction side) {
        return SLOTS;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, @Nullable Direction direction) {
        return !(Block.func_149634_a((Item)itemStackIn.func_77973_b()) instanceof ModShulkerBoxBlock);
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return true;
    }

    public float getProgress(float p_190585_1_) {
        return MathHelper.func_219799_g((float)p_190585_1_, (float)this.progressOld, (float)this.progress);
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public OtherModDyeColor getModColor() {
        if (this.needsColorFromWorld) {
            this.color = ModShulkerBoxBlock.getColorFromBlock2(this.func_195044_w().func_177230_c());
            this.needsColorFromWorld = false;
        }
        return this.color;
    }

    protected Container func_213906_a(int id, PlayerInventory player) {
        return new ShulkerBoxContainer(id, player, (IInventory)this);
    }

    protected IItemHandler createUnSidedHandler() {
        return new SidedInvWrapper((ISidedInventory)this, Direction.UP);
    }

    public static enum AnimationStatus {
        CLOSED,
        OPENING,
        OPENED,
        CLOSING;

    }
}

