/*
 * Decompiled with CFR 0.152.
 */
package com.imwindow.buildersplus.entity;

import com.google.common.collect.Maps;
import com.imwindow.buildersplus.entity.ModLootTables;
import com.imwindow.buildersplus.init.ModBlocks;
import com.imwindow.buildersplus.init.ModEntities;
import com.imwindow.buildersplus.util.ModDyeColor;
import com.imwindow.buildersplus.util.ModDyeItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.EatGrassGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.DyeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTables;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IShearable;

public class ModSheepEntity
extends AnimalEntity
implements IShearable {
    private static final DataParameter<Byte> DYE_COLOR = EntityDataManager.func_187226_a(ModSheepEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final Map<ModDyeColor, IItemProvider> WOOL_BY_COLOR = (Map)Util.func_200696_a((Object)Maps.newEnumMap(ModDyeColor.class), p_203402_0_ -> {
        p_203402_0_.put(ModDyeColor.WHITE, Blocks.field_196556_aL);
        p_203402_0_.put(ModDyeColor.ORANGE, Blocks.field_196557_aM);
        p_203402_0_.put(ModDyeColor.MAGENTA, Blocks.field_196558_aN);
        p_203402_0_.put(ModDyeColor.LIGHT_BLUE, Blocks.field_196559_aO);
        p_203402_0_.put(ModDyeColor.YELLOW, Blocks.field_196560_aP);
        p_203402_0_.put(ModDyeColor.LIME, Blocks.field_196561_aQ);
        p_203402_0_.put(ModDyeColor.PINK, Blocks.field_196562_aR);
        p_203402_0_.put(ModDyeColor.GRAY, Blocks.field_196563_aS);
        p_203402_0_.put(ModDyeColor.LIGHT_GRAY, Blocks.field_196564_aT);
        p_203402_0_.put(ModDyeColor.CYAN, Blocks.field_196565_aU);
        p_203402_0_.put(ModDyeColor.PURPLE, Blocks.field_196566_aV);
        p_203402_0_.put(ModDyeColor.BLUE, Blocks.field_196567_aW);
        p_203402_0_.put(ModDyeColor.BROWN, Blocks.field_196568_aX);
        p_203402_0_.put(ModDyeColor.GREEN, Blocks.field_196569_aY);
        p_203402_0_.put(ModDyeColor.RED, Blocks.field_196570_aZ);
        p_203402_0_.put(ModDyeColor.BLACK, Blocks.field_196602_ba);
        p_203402_0_.put(ModDyeColor.MAROON, ModBlocks.MAROON_WOOL.get());
        p_203402_0_.put(ModDyeColor.CORAL, ModBlocks.CORAL_WOOL.get());
        p_203402_0_.put(ModDyeColor.SALMON, ModBlocks.SALMON_WOOL.get());
        p_203402_0_.put(ModDyeColor.APRICOT, ModBlocks.APRICOT_WOOL.get());
        p_203402_0_.put(ModDyeColor.AMBER, ModBlocks.AMBER_WOOL.get());
        p_203402_0_.put(ModDyeColor.SIENNA, ModBlocks.SIENNA_WOOL.get());
        p_203402_0_.put(ModDyeColor.PEAR, ModBlocks.PEAR_WOOL.get());
        p_203402_0_.put(ModDyeColor.EMERALD_GREEN, ModBlocks.EMERALD_WOOL.get());
        p_203402_0_.put(ModDyeColor.FOREST_GREEN, ModBlocks.FOREST_GREEN_WOOL.get());
        p_203402_0_.put(ModDyeColor.JADE, ModBlocks.JADE_WOOL.get());
        p_203402_0_.put(ModDyeColor.TEAL, ModBlocks.TEAL_WOOL.get());
        p_203402_0_.put(ModDyeColor.TURQUOISE, ModBlocks.TURQUOISE_WOOL.get());
        p_203402_0_.put(ModDyeColor.BURGUNDY, ModBlocks.BURGUNDY_WOOL.get());
        p_203402_0_.put(ModDyeColor.PLUM, ModBlocks.PLUM_WOOL.get());
        p_203402_0_.put(ModDyeColor.LAVENDER, ModBlocks.LAVENDER_WOOL.get());
        p_203402_0_.put(ModDyeColor.CRIMSON, ModBlocks.CRIMSON_WOOL.get());
    });
    private static final Map<ModDyeColor, float[]> DYE_TO_RGB = Maps.newEnumMap(Arrays.stream(ModDyeColor.values()).collect(Collectors.toMap(p_200204_0_ -> p_200204_0_, ModSheepEntity::createSheepColor)));
    private int sheepTimer;
    private EatGrassGoal eatGrassGoal;

    private static float[] createSheepColor(ModDyeColor dyeColorIn) {
        if (dyeColorIn == ModDyeColor.WHITE) {
            return new float[]{0.9019608f, 0.9019608f, 0.9019608f};
        }
        float[] afloat = dyeColorIn.getColorComponentValues();
        float f = 0.75f;
        return new float[]{afloat[0] * 0.75f, afloat[1] * 0.75f, afloat[2] * 0.75f};
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)Items.field_196133_cQ);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static float[] getDyeRgb(ModDyeColor dyeColor) {
        return DYE_TO_RGB.get((Object)dyeColor);
    }

    public ModSheepEntity(EntityType<? extends ModSheepEntity> type, World worldIn) {
        super(type, worldIn);
    }

    protected void func_184651_r() {
        this.eatGrassGoal = new EatGrassGoal((MobEntity)this);
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new PanicGoal((CreatureEntity)this, 1.25));
        this.field_70714_bg.func_75776_a(2, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (Goal)new TemptGoal((CreatureEntity)this, 1.1, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151015_O}), false));
        this.field_70714_bg.func_75776_a(4, (Goal)new FollowParentGoal((AnimalEntity)this, 1.1));
        this.field_70714_bg.func_75776_a(5, (Goal)this.eatGrassGoal);
        this.field_70714_bg.func_75776_a(6, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    protected void func_70619_bc() {
        this.sheepTimer = this.eatGrassGoal.func_151499_f();
        super.func_70619_bc();
    }

    public void func_70636_d() {
        if (this.field_70170_p.field_72995_K) {
            this.sheepTimer = Math.max(0, this.sheepTimer - 1);
        }
        super.func_70636_d();
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(8.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.23f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DYE_COLOR, (Object)0);
    }

    public ResourceLocation func_184647_J() {
        if (this.getSheared()) {
            return this.func_200600_R().func_220348_g();
        }
        switch (this.getFleeceColor()) {
            default: {
                return LootTables.field_186404_L;
            }
            case ORANGE: {
                return LootTables.field_186405_M;
            }
            case MAGENTA: {
                return LootTables.field_186406_N;
            }
            case LIGHT_BLUE: {
                return LootTables.field_186407_O;
            }
            case YELLOW: {
                return LootTables.field_186408_P;
            }
            case LIME: {
                return LootTables.field_186409_Q;
            }
            case PINK: {
                return LootTables.field_186410_R;
            }
            case GRAY: {
                return LootTables.field_186411_S;
            }
            case LIGHT_GRAY: {
                return LootTables.field_197738_Y;
            }
            case CYAN: {
                return LootTables.field_186413_U;
            }
            case PURPLE: {
                return LootTables.field_186414_V;
            }
            case BLUE: {
                return LootTables.field_186415_W;
            }
            case BROWN: {
                return LootTables.field_186416_X;
            }
            case GREEN: {
                return LootTables.field_186417_Y;
            }
            case RED: {
                return LootTables.field_186418_Z;
            }
            case BLACK: {
                return LootTables.field_186376_aa;
            }
            case MAROON: {
                return ModLootTables.ENTITIES_SHEEP_MAROON;
            }
            case CORAL: {
                return ModLootTables.ENTITIES_SHEEP_CORAL;
            }
            case SALMON: {
                return ModLootTables.ENTITIES_SHEEP_SALMON;
            }
            case APRICOT: {
                return ModLootTables.ENTITIES_SHEEP_APRICOT;
            }
            case AMBER: {
                return ModLootTables.ENTITIES_SHEEP_AMBER;
            }
            case SIENNA: {
                return ModLootTables.ENTITIES_SHEEP_SIENNA;
            }
            case PEAR: {
                return ModLootTables.ENTITIES_SHEEP_PEAR;
            }
            case EMERALD_GREEN: {
                return ModLootTables.ENTITIES_SHEEP_EMERALD;
            }
            case FOREST_GREEN: {
                return ModLootTables.ENTITIES_SHEEP_FOREST_GREEN;
            }
            case JADE: {
                return ModLootTables.ENTITIES_SHEEP_JADE;
            }
            case TEAL: {
                return ModLootTables.ENTITIES_SHEEP_TEAL;
            }
            case TURQUOISE: {
                return ModLootTables.ENTITIES_SHEEP_TURQUOISE;
            }
            case BURGUNDY: {
                return ModLootTables.ENTITIES_SHEEP_BURGUNDY;
            }
            case PLUM: {
                return ModLootTables.ENTITIES_SHEEP_PLUM;
            }
            case LAVENDER: {
                return ModLootTables.ENTITIES_SHEEP_LAVENDER;
            }
            case CRIMSON: 
        }
        return ModLootTables.ENTITIES_SHEEP_CRIMSON;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 10) {
            this.sheepTimer = 40;
        } else {
            super.func_70103_a(id);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getHeadRotationPointY(float p_70894_1_) {
        if (this.sheepTimer <= 0) {
            return 0.0f;
        }
        if (this.sheepTimer >= 4 && this.sheepTimer <= 36) {
            return 1.0f;
        }
        return this.sheepTimer < 4 ? ((float)this.sheepTimer - p_70894_1_) / 4.0f : -((float)(this.sheepTimer - 40) - p_70894_1_) / 4.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getHeadRotationAngleX(float p_70890_1_) {
        if (this.sheepTimer > 4 && this.sheepTimer <= 36) {
            float f = ((float)(this.sheepTimer - 4) - p_70890_1_) / 32.0f;
            return 0.62831855f + 0.21991149f * MathHelper.func_76126_a((float)(f * 28.7f));
        }
        return this.sheepTimer > 0 ? 0.62831855f : this.field_70125_A * ((float)Math.PI / 180);
    }

    public boolean func_184645_a(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (itemstack.func_77973_b() instanceof DyeItem) {
            SheepEntity sheep = new SheepEntity(EntityType.field_200737_ac, this.field_70170_p);
            if (this.func_70089_S() && !this.getSheared()) {
                if (this.func_70631_g_()) {
                    sheep.func_70873_a(-24000);
                }
                sheep.field_70177_z = this.field_70177_z;
                sheep.field_70759_as = this.field_70759_as;
                sheep.field_70125_A = this.field_70125_A;
                sheep.func_213317_d(sheep.func_213322_ci());
                sheep.func_82149_j((Entity)this);
                sheep.func_175512_b(((DyeItem)itemstack.func_77973_b()).func_195962_g());
                this.field_70170_p.func_217376_c((Entity)sheep);
                this.func_70106_y();
                if (!player.func_184812_l_()) {
                    player.func_184614_ca().func_190918_g(1);
                }
            }
            return true;
        }
        if (itemstack.func_77973_b() == Items.field_196133_cQ) {
            ModSheepEntity modSheep = new ModSheepEntity((EntityType<? extends ModSheepEntity>)((EntityType)ModEntities.SHEEP.get()), this.field_70170_p);
            modSheep.func_82149_j((Entity)this);
            modSheep.func_70873_a(-24000);
            modSheep.setFleeceColor(this.getFleeceColor());
            this.field_70170_p.func_217376_c((Entity)modSheep);
            if (!player.func_184812_l_()) {
                player.func_184614_ca().func_190918_g(1);
            }
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    @Deprecated
    public void shear() {
        if (!this.field_70170_p.field_72995_K) {
            this.setSheared(true);
            int i = 1 + this.field_70146_Z.nextInt(3);
            for (int j = 0; j < i; ++j) {
                ItemEntity itementity = this.func_199702_a(WOOL_BY_COLOR.get((Object)this.getFleeceColor()), 1);
                if (itementity == null) continue;
                itementity.func_213317_d(itementity.func_213322_ci().func_72441_c((double)((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.1f), (double)(this.field_70146_Z.nextFloat() * 0.05f), (double)((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.1f)));
            }
        }
        this.func_184185_a(SoundEvents.field_187763_eJ, 1.0f, 1.0f);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("Sheared", this.getSheared());
        compound.func_74774_a("Color", (byte)this.getFleeceColor().getId());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setSheared(compound.func_74767_n("Sheared"));
        this.setFleeceColor(ModDyeColor.byId(compound.func_74771_c("Color")));
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187757_eG;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187761_eI;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187759_eH;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_187765_eK, 0.15f, 1.0f);
    }

    public ModDyeColor getFleeceColor() {
        return ModDyeColor.byId((Byte)this.field_70180_af.func_187225_a(DYE_COLOR) & 0x1F);
    }

    public void setFleeceColor(ModDyeColor color) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(DYE_COLOR);
        this.field_70180_af.func_187227_b(DYE_COLOR, (Object)((byte)(b0 & 0xF0 | color.getId() & 0x1F)));
    }

    public boolean getSheared() {
        return ((Byte)this.field_70180_af.func_187225_a(DYE_COLOR) & 0x20) != 0;
    }

    public void setSheared(boolean sheared) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(DYE_COLOR);
        if (sheared) {
            this.field_70180_af.func_187227_b(DYE_COLOR, (Object)((byte)(b0 | 0x20)));
        } else {
            this.field_70180_af.func_187227_b(DYE_COLOR, (Object)((byte)(b0 & 0xFFFFFFDF)));
        }
    }

    public static ModDyeColor getRandomSheepColor(Random random) {
        int i = random.nextInt(100);
        int j = random.nextInt(1000);
        if (i < 5) {
            return ModDyeColor.BLACK;
        }
        if (i < 10) {
            return ModDyeColor.GRAY;
        }
        if (i < 15) {
            return ModDyeColor.LIGHT_GRAY;
        }
        if (i < 18) {
            return ModDyeColor.BROWN;
        }
        if (j == 1) {
            return ModDyeColor.LAVENDER;
        }
        return random.nextInt(500) == 0 ? ModDyeColor.PINK : ModDyeColor.WHITE;
    }

    public ModSheepEntity createChild(AgeableEntity ageable) {
        ModSheepEntity sheepentity = (ModSheepEntity)ageable;
        ModSheepEntity sheepentity1 = (ModSheepEntity)((EntityType)ModEntities.SHEEP.get()).func_200721_a(this.field_70170_p);
        sheepentity1.setFleeceColor(this.getDyeColorMixFromParents(this, sheepentity));
        return sheepentity1;
    }

    public void func_70615_aA() {
        this.setSheared(false);
        if (this.func_70631_g_()) {
            this.func_110195_a(60);
        }
    }

    public ILivingEntityData func_213386_a(IWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        this.setFleeceColor(ModSheepEntity.getRandomSheepColor(worldIn.func_201674_k()));
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    private ModDyeColor getDyeColorMixFromParents(AnimalEntity father, AnimalEntity mother) {
        ModDyeColor dyecolor = ((ModSheepEntity)father).getFleeceColor();
        ModDyeColor dyecolor1 = ((ModSheepEntity)mother).getFleeceColor();
        CraftingInventory craftinginventory = ModSheepEntity.createDyeColorCraftingInventory(dyecolor, dyecolor1);
        return this.field_70170_p.func_199532_z().func_215371_a(IRecipeType.field_222149_a, (IInventory)craftinginventory, this.field_70170_p).map(p_213614_1_ -> p_213614_1_.func_77572_b((IInventory)craftinginventory)).map(ItemStack::func_77973_b).filter(ModDyeItem.class::isInstance).map(ModDyeItem.class::cast).map(ModDyeItem::getModDyeColor).orElseGet(() -> this.field_70170_p.field_73012_v.nextBoolean() ? dyecolor : dyecolor1);
    }

    private static CraftingInventory createDyeColorCraftingInventory(ModDyeColor color, ModDyeColor color1) {
        CraftingInventory craftinginventory = new CraftingInventory(new Container(null, -1){

            public boolean func_75145_c(PlayerEntity playerIn) {
                return false;
            }
        }, 2, 1);
        craftinginventory.func_70299_a(0, new ItemStack((IItemProvider)ModDyeItem.getModItem(color)));
        craftinginventory.func_70299_a(1, new ItemStack((IItemProvider)ModDyeItem.getModItem(color1)));
        return craftinginventory;
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 0.95f * sizeIn.field_220316_b;
    }

    public boolean isShearable(ItemStack item, IWorldReader world, BlockPos pos) {
        return !this.getSheared() && !this.func_70631_g_();
    }

    public List<ItemStack> onSheared(ItemStack item, IWorld world, BlockPos pos, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        if (!this.field_70170_p.field_72995_K) {
            this.setSheared(true);
            int i = 1 + this.field_70146_Z.nextInt(3);
            for (int j = 0; j < i; ++j) {
                ret.add(new ItemStack(WOOL_BY_COLOR.get((Object)this.getFleeceColor())));
            }
        }
        this.func_184185_a(SoundEvents.field_187763_eJ, 1.0f, 1.0f);
        return ret;
    }

    private static /* synthetic */ void lambda$processInteract$2(Hand hand, PlayerEntity p_213613_1_) {
        p_213613_1_.func_213334_d(hand);
    }
}

